/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.ContenciosoSituacaoContenciosoEnumConverter;
import br.com.elotech.tributos.converter.ContenciosoSituacaoEnumConverter;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoSituacaoContenciosoEnum;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.TipoContencioso;
import br.com.elotech.tributos.domain.contencioso.Parecerista;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosResponseDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribcontencioso")
public class Contencioso
implements Serializable,
EloEntity<Long> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="idContencioso")
    @EloSequence(sequenceName="S05IDCONTENCIOSO")
    private Long id;
    private Long entidade;
    private Long exercicio;
    @Column(name="contencioso")
    @EloSequence(sequenceName="s05contencioso_#{entidade}_#{exercicio}")
    private Long contenciosoId;
    private LocalDate data;
    @NotNull
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipoContencioso", referencedColumnName="tipoContencioso")
    private TipoContencioso tipoContencioso;
    private Long exercicioProcesso;
    private Long idProcesso;
    @NotNull
    @Length(max=2000)
    private @NotNull @Length(max=2000) String observacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral")})
    private CadastroGeral cadastroGeral;
    @Convert(converter=ContenciosoSituacaoContenciosoEnumConverter.class)
    private ContenciosoSituacaoContenciosoEnum situacaoContencioso;
    private Long instancia;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", insertable=false, updatable=false), @JoinColumn(name="fundamentoLegal", referencedColumnName="idAto", insertable=false, updatable=false)})
    private Ato fundamentoLegal;
    @Convert(converter=ContenciosoSituacaoEnumConverter.class)
    private ContenciosoSituacaoEnum situacao;
    private String usuario;
    @NotNull
    @ManyToOne
    @JoinColumn(name="idParecerista")
    private Parecerista parecerista;
    private Boolean conversao;
    @OneToMany(mappedBy="id.idContencioso", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ContenciosoDebito> debitos = new ArrayList();

    public String getSituacaoDetalhada() {
        return Optional.ofNullable(this.situacao).map(ContenciosoSituacaoEnum::getDescricao).orElse("");
    }

    public static void from(ContenciosoDebitosResponseDTO dto, Contencioso contencioso) {
        Optional.ofNullable(dto.getId()).ifPresent(arg_0 -> contencioso.setId(arg_0));
        Optional.ofNullable(dto.getContenciosoId()).ifPresent(arg_0 -> contencioso.setContenciosoId(arg_0));
        Optional.ofNullable(dto.getEntidade()).ifPresent(arg_0 -> contencioso.setEntidade(arg_0));
        Optional.ofNullable(dto.getExercicio()).ifPresent(arg_0 -> contencioso.setExercicio(arg_0));
        Optional.ofNullable(dto.getInstancia()).ifPresent(arg_0 -> contencioso.setInstancia(arg_0));
        Optional.ofNullable(dto.getCadastroGeral()).ifPresent(arg_0 -> contencioso.setCadastroGeral(arg_0));
        Optional.ofNullable(dto.getData()).ifPresent(arg_0 -> contencioso.setData(arg_0));
        Optional.ofNullable(dto.getParecerista()).ifPresent(arg_0 -> contencioso.setParecerista(arg_0));
        Optional.ofNullable(dto.getObservacao()).ifPresent(arg_0 -> contencioso.setObservacao(arg_0));
        Optional.ofNullable(dto.getUsuario()).ifPresent(arg_0 -> contencioso.setUsuario(arg_0));
        if (Objects.nonNull(dto.getTipoContencioso())) {
            TipoContencioso tipoContencioso = new TipoContencioso();
            tipoContencioso.setDescricao(dto.getTipoContencioso().getDescricao());
            tipoContencioso.setId(dto.getTipoContencioso().getId());
            contencioso.setTipoContencioso(tipoContencioso);
        }
        if (Objects.nonNull(dto.getProcesso())) {
            contencioso.setExercicioProcesso(dto.getProcesso().getAno());
            contencioso.setIdProcesso(dto.getProcesso().getNumero());
        }
        if (Objects.nonNull(dto.getSituacao())) {
            contencioso.setSituacao(ContenciosoSituacaoEnum.fromValue((String)dto.getSituacao()));
        }
        if (Objects.nonNull(dto.getSituacaoContencioso())) {
            contencioso.setSituacaoContencioso(ContenciosoSituacaoContenciosoEnum.fromValue((String)dto.getSituacaoContencioso()));
        }
    }

    @Generated
    public Contencioso() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getContenciosoId() {
        return this.contenciosoId;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public TipoContencioso getTipoContencioso() {
        return this.tipoContencioso;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public ContenciosoSituacaoContenciosoEnum getSituacaoContencioso() {
        return this.situacaoContencioso;
    }

    @Generated
    public Long getInstancia() {
        return this.instancia;
    }

    @Generated
    public Ato getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    @Generated
    public ContenciosoSituacaoEnum getSituacao() {
        return this.situacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Parecerista getParecerista() {
        return this.parecerista;
    }

    @Generated
    public Boolean getConversao() {
        return this.conversao;
    }

    @Generated
    public List<ContenciosoDebito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setContenciosoId(Long contenciosoId) {
        this.contenciosoId = contenciosoId;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setTipoContencioso(TipoContencioso tipoContencioso) {
        this.tipoContencioso = tipoContencioso;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSituacaoContencioso(ContenciosoSituacaoContenciosoEnum situacaoContencioso) {
        this.situacaoContencioso = situacaoContencioso;
    }

    @Generated
    public void setInstancia(Long instancia) {
        this.instancia = instancia;
    }

    @Generated
    public void setFundamentoLegal(Ato fundamentoLegal) {
        this.fundamentoLegal = fundamentoLegal;
    }

    @Generated
    public void setSituacao(ContenciosoSituacaoEnum situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setParecerista(Parecerista parecerista) {
        this.parecerista = parecerista;
    }

    @Generated
    public void setConversao(Boolean conversao) {
        this.conversao = conversao;
    }

    @Generated
    public void setDebitos(List<ContenciosoDebito> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public String toString() {
        return "Contencioso(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contencioso)) {
            return false;
        }
        Contencioso other = (Contencioso)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Contencioso;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

