/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.InscricaoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.InscricaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.repository.simam.DebitoInscricaoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class InscricaoDividaAtivaBatchWriter
implements ItemWriter<InscricaoCreditoDividaAtivaConsultaDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InscricaoDividaAtivaBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository;
    private final DebitoInscricaoDividaAtivaRepository debitoInscricaoDividaAtivaRepository;
    private Long nrAnoDivida;
    private LocalDate dataInicial;
    private LocalDate dataFinal;
    private boolean isImplantacaoSaldo;
    private Map<String, Long> cargaExistente = new HashMap();
    private AtomicLong ultimoNrDivida = new AtomicLong(0L);

    public InscricaoDividaAtivaBatchWriter(EntityManager entityManager, InscricaoCreditoDividaAtivaRepository inscricaoCreditoDividaAtivaRepository, DebitoInscricaoDividaAtivaRepository debitoInscricaoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.inscricaoCreditoDividaAtivaRepository = inscricaoCreditoDividaAtivaRepository;
        this.debitoInscricaoDividaAtivaRepository = debitoInscricaoDividaAtivaRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.isImplantacaoSaldo = "true".equals(stepExecution.getExecutionContext().getString("implantacaoSaldo", "false"));
        if (this.isImplantacaoSaldo) {
            this.nrAnoDivida = stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
        } else {
            this.dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
            this.dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
            this.nrAnoDivida = this.dataInicial.getYear();
        }
        this.ultimoNrDivida.set(this.inscricaoCreditoDividaAtivaRepository.findNextNrDividaByExercicio(this.nrAnoDivida));
        LOGGER.info("Carregando a carga existente");
        this.inscricaoCreditoDividaAtivaRepository.getCargaExistente(this.dataInicial, this.dataFinal).forEach(itemCargaExistente -> this.cargaExistente.put(itemCargaExistente.buildChaveAgrupamento(), itemCargaExistente.getIdInscricao()));
        LOGGER.info("Finalizou a carga dos itens existentes.");
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends InscricaoCreditoDividaAtivaConsultaDTO> items) {
        List itensGerados = items.stream().map(item -> {
            Long inscricaoCreditoDividaAtiva = this.getOrCreateInscricaoDividaAtiva(this.cargaExistente, item);
            DebitoInscricaoDividaAtiva debitoInscricaoDividaAtiva = new DebitoInscricaoDividaAtiva();
            debitoInscricaoDividaAtiva.setId(new DebitoInscricaoDividaAtivaId());
            debitoInscricaoDividaAtiva.getId().setIdtceinsccreditoda(inscricaoCreditoDividaAtiva);
            debitoInscricaoDividaAtiva.getId().setIdDebitoParcelaTributo(item.getIdDebitoParcelaTributoDestino());
            debitoInscricaoDividaAtiva.setValor(item.getValorCorrigido());
            debitoInscricaoDividaAtiva.setAnoGerado(this.nrAnoDivida);
            debitoInscricaoDividaAtiva.setMesGerado(Long.valueOf(this.isImplantacaoSaldo ? 1L : (long)this.dataInicial.getMonthValue()));
            return debitoInscricaoDividaAtiva;
        }).collect(Collectors.toList());
        this.debitoInscricaoDividaAtivaRepository.saveAll(itensGerados);
        this.entityManager.flush();
    }

    private Long getOrCreateInscricaoDividaAtiva(Map<String, Long> cargaExistente, InscricaoCreditoDividaAtivaConsultaDTO item) {
        return cargaExistente.compute(item.buildChaveAgrupamento(), (chave, inscricaoJaExistente) -> {
            if (Objects.nonNull(inscricaoJaExistente)) {
                return inscricaoJaExistente;
            }
            InscricaoCreditoDividaAtiva newValue = new InscricaoCreditoDividaAtiva();
            newValue.setTipoNaturezaCredito(TipoNaturezaCredito.fromValue((Long)item.getIdTipoNaturezaCredito()));
            if (Objects.nonNull(item.getIdTipoCredito())) {
                newValue.setTipoCredito(ClassificacaoTipoTributo.fromValue((Integer)item.getIdTipoCredito().intValue()));
            }
            newValue.setTipoOperacaoCredito(TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()));
            newValue.setDataInscricao(item.getDtInscricao());
            Long anoInscricao = Optional.ofNullable(item.getDtInscricao()).map(LocalDate::getYear).map(Long::valueOf).orElse(null);
            newValue.setNrAnoDivida(this.nrAnoDivida);
            newValue.setNrDivida(Long.valueOf(this.ultimoNrDivida.getAndIncrement()));
            newValue.setNrCredito(item.getNrCredito());
            newValue.setNrAnoCredito(item.getNrAnoCredito());
            newValue.setNrAnoBase(item.getNrAnoBase());
            newValue.setCdControleLeiAto(item.getCdControleLeiAto());
            newValue.setNrAnoInscricao(anoInscricao);
            this.inscricaoCreditoDividaAtivaRepository.save((Object)newValue);
            LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - gerando novo registro -> ({}/{})", (Object)newValue.getNrDivida(), (Object)newValue.getNrAnoDivida());
            return newValue.getId();
        });
    }
}

