/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.deducaocredito.dividaativa;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItemPk;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.domain.simam.DeducaoCancelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoCancelamentoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoCreditoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.DeducaoCreditoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoPagamentoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.DeducaoParcelamentoDividaAtiva;
import br.com.elotech.tributos.domain.simam.DeducaoParcelamentoDividaAtivaId;
import br.com.elotech.tributos.domain.simam.TipoDeducaoDividaAtiva;
import br.com.elotech.tributos.dto.simam.DeducaoCreditoDividaAtivaConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.DeducaoCreditoDividaAtivaRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class DeducaoCreditoDividaAtivaBatchProcessor
implements ItemProcessor<DeducaoCreditoDividaAtivaConsultaDTO, TipoDeducaoDividaAtiva> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeducaoCreditoDividaAtivaBatchProcessor.class);
    private static final String DEDUCAO_CREDITO_DIVIDA_ATIVA = "SIM-AM - Dedu\u00e7\u00f5es de Cr\u00e9ditos em D\u00edvida Ativa - ";
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong ultimoNrDeducao = new AtomicLong(0L);
    private Long nrAnoDeducao;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final DeducaoCreditoDividaAtivaRepository deducaoCreditoDividaAtivaRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        log.info("{}Iniciando gera\u00e7\u00e3o de dados", (Object)DEDUCAO_CREDITO_DIVIDA_ATIVA);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        log.info("{}Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{DEDUCAO_CREDITO_DIVIDA_ATIVA, dataInicial, dataFinal, entidade});
        this.nrAnoDeducao = dataInicial.getYear();
        log.info("{}load da carga existente", (Object)DEDUCAO_CREDITO_DIVIDA_ATIVA);
        this.deducaoCreditoDividaAtivaRepository.getCargaExistenteDeducaoCreditoDividaAtiva(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.buildChave(), item.getId()));
        log.info("{}atualizando \u00faltimo NrDeducao", (Object)DEDUCAO_CREDITO_DIVIDA_ATIVA);
        this.ultimoNrDeducao.set(this.deducaoCreditoDividaAtivaRepository.findNextNrDeducaoByExercicio(Long.valueOf(dataInicial.getYear())));
    }

    public TipoDeducaoDividaAtiva process(DeducaoCreditoDividaAtivaConsultaDTO item) throws Exception {
        Long finalId = this.cargaExistente.compute(item.buildChave(this.nrAnoDeducao), (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("s05idtcededucaocreditoda");
            DeducaoCreditoDividaAtiva deducaoCreditoDividaAtiva = new DeducaoCreditoDividaAtiva();
            deducaoCreditoDividaAtiva.setId(nextVal);
            deducaoCreditoDividaAtiva.setDtDeducao(item.getDtDeducao());
            deducaoCreditoDividaAtiva.setVlDeducao(item.getValor());
            deducaoCreditoDividaAtiva.setIdTipoDeducaoCredito(TipoDeducaoEnum.fromValue((Long)item.getIdTipoDeducaoCredito()));
            deducaoCreditoDividaAtiva.setDsMotivo(item.getDsMotivo());
            deducaoCreditoDividaAtiva.setNrAnoDeducao(this.nrAnoDeducao);
            deducaoCreditoDividaAtiva.setNrDeducao(Long.valueOf(this.ultimoNrDeducao.getAndIncrement()));
            deducaoCreditoDividaAtiva.setNrDivida(item.getNrDivida());
            deducaoCreditoDividaAtiva.setNrAnoDivida(item.getNrAnoDivida());
            deducaoCreditoDividaAtiva.setCdControleLeiAto(item.getCdControleLeiAto());
            deducaoCreditoDividaAtiva.setIdTipoCredito(item.getIdTipoCredito());
            log.info("{}gerando novo registro -> {} ({}/{})", new Object[]{DEDUCAO_CREDITO_DIVIDA_ATIVA, nextVal, deducaoCreditoDividaAtiva.getNrDeducao(), deducaoCreditoDividaAtiva.getNrAnoDeducao()});
            this.deducaoCreditoDividaAtivaRepository.save((Object)deducaoCreditoDividaAtiva);
            this.entityManager.flush();
            return nextVal;
        });
        if (Objects.nonNull(item.getIdCancelamento())) {
            CancelamentoDebitoPk cancelamentoDebitoId = new CancelamentoDebitoPk();
            cancelamentoDebitoId.setId(item.getIdCancelamento());
            cancelamentoDebitoId.setEntidade(item.getEntidade());
            cancelamentoDebitoId.setExercicio(item.getExercicio());
            CancelamentoDebitoItemPk cancelamentoDebitoItemId = new CancelamentoDebitoItemPk();
            cancelamentoDebitoItemId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            cancelamentoDebitoItemId.setCancelamentoDebito((CancelamentoDebito)this.entityManager.getReference(CancelamentoDebito.class, (Object)cancelamentoDebitoId));
            DeducaoCancelamentoDividaAtivaId cancelamentoId = new DeducaoCancelamentoDividaAtivaId();
            cancelamentoId.setDeducaoCreditoDividaAtiva((DeducaoCreditoDividaAtiva)this.entityManager.getReference(DeducaoCreditoDividaAtiva.class, (Object)finalId));
            cancelamentoId.setCancelamentoDebitoItem((CancelamentoDebitoItem)this.entityManager.getReference(CancelamentoDebitoItem.class, (Object)cancelamentoDebitoItemId));
            DeducaoCancelamentoDividaAtiva cancelamento = new DeducaoCancelamentoDividaAtiva();
            cancelamento.setId(cancelamentoId);
            cancelamento.setValor(item.getValor());
            return cancelamento;
        }
        if (Objects.nonNull(item.getIdPagamentoBloqueto())) {
            PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
            pagamentoDebitoId.setIdPagamentoBoleto(item.getIdPagamentoBloqueto());
            pagamentoDebitoId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            DeducaoPagamentoDividaAtivaId pagamentoId = new DeducaoPagamentoDividaAtivaId();
            pagamentoId.setDeducaoCreditoDividaAtiva((DeducaoCreditoDividaAtiva)this.entityManager.getReference(DeducaoCreditoDividaAtiva.class, (Object)finalId));
            pagamentoId.setPagamentoDebito((PagamentoDebito)this.entityManager.getReference(PagamentoDebito.class, (Object)pagamentoDebitoId));
            DeducaoPagamentoDividaAtiva pagamento = new DeducaoPagamentoDividaAtiva();
            pagamento.setId(pagamentoId);
            pagamento.setValor(item.getValor());
            return pagamento;
        }
        if (Objects.nonNull(item.getIdParcelamento())) {
            DeducaoParcelamentoDividaAtivaId deducaoParcelamentoDividaAtivaId = new DeducaoParcelamentoDividaAtivaId();
            deducaoParcelamentoDividaAtivaId.setDeducaoCreditoDividaAtiva((DeducaoCreditoDividaAtiva)this.entityManager.getReference(DeducaoCreditoDividaAtiva.class, (Object)finalId));
            deducaoParcelamentoDividaAtivaId.setIdDebitoParcelaReceita(item.getIdDebitoParcelaReceita());
            deducaoParcelamentoDividaAtivaId.setIdParcelamento(item.getIdParcelamento());
            DeducaoParcelamentoDividaAtiva deducaoParcelamentoDividaAtiva = new DeducaoParcelamentoDividaAtiva();
            deducaoParcelamentoDividaAtiva.setId(deducaoParcelamentoDividaAtivaId);
            deducaoParcelamentoDividaAtiva.setValor(item.getValor());
            return deducaoParcelamentoDividaAtiva;
        }
        DeducaoCreditoCreditoDividaAtivaId creditoId = new DeducaoCreditoCreditoDividaAtivaId();
        creditoId.setDeducaoCreditoDividaAtiva((DeducaoCreditoDividaAtiva)this.entityManager.getReference(DeducaoCreditoDividaAtiva.class, (Object)finalId));
        creditoId.setCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)item.getIdCreditoContribuinteItem()));
        creditoId.setParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
        DeducaoCreditoCreditoDividaAtiva credito = new DeducaoCreditoCreditoDividaAtiva();
        credito.setId(creditoId);
        credito.setValor(item.getValor());
        return credito;
    }

    @OnProcessError
    public void onProcessError(Object item, Exception e) throws Exception {
        log.error("{}erro: {}\n{})", new Object[]{DEDUCAO_CREDITO_DIVIDA_ATIVA, e.getMessage(), ObjectMapperSingleton.getObjectMapper().writeValueAsString(item)});
    }

    @Generated
    public DeducaoCreditoDividaAtivaBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, DeducaoCreditoDividaAtivaRepository deducaoCreditoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.deducaoCreditoDividaAtivaRepository = deducaoCreditoDividaAtivaRepository;
    }
}

