/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.geracaodebitocalculo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.Serializable;
import java.util.Date;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class GeracaoDebitoCalculoJobListener
extends JobExecutionListenerSupport {
    private static final String JOB_TYPE = "jobType";
    private static final String ID_CALCULO = "idCalculo";
    private static final String ENTIDADE = "entidade";
    private final NotificacaoClient notificacaoClient;
    private final CalculoService calculoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;

    public GeracaoDebitoCalculoJobListener(NotificacaoClient notificacaoClient, CalculoService calculoService, ValidaDataMovimentacaoService validaDataMovimentacaoService) {
        this.notificacaoClient = notificacaoClient;
        this.calculoService = calculoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        Long entidade = jobExecution.getJobParameters().getLong(ENTIDADE);
        Calculo calculo = (Calculo)this.calculoService.findOne((Serializable)idCalculo);
        if (!SituacaoCalculo.GERANDO_DEBITO.equals((Object)calculo.getSituacao()) && !SituacaoCalculo.ERRO_GERACAO_DEBITO.equals((Object)calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel processar a gera\u00e7\u00e3o de d\u00e9bitos para c\u00e1lculo com a situa\u00e7\u00e3o \"%s\".", calculo.getSituacao().getDescricao()));
        }
        this.validaDataMovimentacaoService.validaMesEDia(entidade, calculo.getDataLancamento());
        calculo.setSituacao(SituacaoCalculo.GERANDO_DEBITO);
        calculo.setBatchJobExecutionDebito(BatchJobExecution.of((JobExecution)jobExecution));
        this.calculoService.save((EloEntity)calculo, null);
        Notificacao notificacao = Notificacao.builder().title(String.format("Iniciada a gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d.", idCalculo)).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)JobType.SIMULACAO_CALCULO.getTipo()).metadata(ID_CALCULO, (Object)idCalculo).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID_CALCULO);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoDebitoGeradoSeTodosCadastrosConsistentesComDebito(idCalculo);
            notificacao.title(String.format("Finalizada a gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d com sucesso.", idCalculo)).metadata(JOB_TYPE, (Object)JobType.SIMULACAO_CALCULO.getTipo()).metadata(ID_CALCULO, (Object)idCalculo);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.calculoService.updateSituacaoCalculo(idCalculo, SituacaoCalculo.ERRO_GERACAO_DEBITO);
            notificacao.title(String.format("Ocorreu um erro na gera\u00e7\u00e3o de d\u00e9bitos do c\u00e1lculo %d.", idCalculo)).metadata(JOB_TYPE, (Object)JobType.SIMULACAO_CALCULO.getTipo()).metadata(ID_CALCULO, (Object)idCalculo).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

