/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.geracaodebitocalculo;

import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GeracaoDebitoCalculoBatchProcessor
implements ItemProcessor<Long, CalculoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeracaoDebitoCalculoBatchProcessor.class);
    private final CalculoService calculoService;
    private final CalculoCadastroService calculoCadastroService;
    private StepExecution stepExecution;

    public GeracaoDebitoCalculoBatchProcessor(CalculoService calculoService, CalculoCadastroService calculoCadastroService) {
        this.calculoService = calculoService;
        this.calculoCadastroService = calculoCadastroService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public CalculoCadastro process(Long idCalculoCadastroConsistente) {
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}.", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Realizando a gera\u00e7\u00e3o de d\u00e9bitos do calculoCadastro com ID: {}", (Object)idCalculoCadastroConsistente);
        Long entidade = this.stepExecution.getJobParameters().getLong("entidade");
        CalculoCadastro calculoCadastro = (CalculoCadastro)this.calculoCadastroService.findOne((Serializable)idCalculoCadastroConsistente);
        calculoCadastro = this.calculoService.gerarDebitoCadastroConsistente(calculoCadastro, entidade);
        this.calculoService.salvarCamposDinamicosCalculo(calculoCadastro);
        return calculoCadastro;
    }
}

