/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.enviopeticaoprocuradoria;

import br.com.elotech.client.headers.relay.HystrixRequestVariableDefaultHeaders;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.service.documento.EnviarPeticaoService;
import br.com.elotech.tributos.service.exception.EnvioArquivoProcuradoriaException;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@StepScope
public class EnvioPeticaoProcuradoriaBatchProcessor
implements ItemProcessor<Long, Documento> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvioPeticaoProcuradoriaBatchProcessor.class);
    private StepExecution stepExecution;
    private EnviarPeticaoService enviarPeticaoService;

    public EnvioPeticaoProcuradoriaBatchProcessor(EnviarPeticaoService enviarPeticaoService) {
        this.enviarPeticaoService = enviarPeticaoService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Documento process(Long idPeticao) throws IOException {
        LOGGER.info("ExecutionId: {}, StepId: {}, ReadCount: {}", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.info("Executando gera\u00e7\u00e3o do arquivo agrupado de Peti\u00e7\u00e3o e CDAs para envio a Procuradoria. Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        HystrixRequestContext context = EnvioPeticaoProcuradoriaBatchProcessor.inicializeContextHystrix();
        try {
            Documento documento = this.enviarPeticaoService.agruparArquivoPeticaoLoteCda(idPeticao);
            return documento;
        }
        catch (EnvioArquivoProcuradoriaException envioArquivoProcuradoriaException) {
            LOGGER.info("Peti\u00e7\u00e3o {} j\u00e1 est\u00e1 marcado como enviado para Procuradoria!", (Object)idPeticao);
            Documento documento = null;
            return documento;
        }
        finally {
            LOGGER.debug("Fechando o contexto do Hystrix!");
            context.shutdown();
        }
    }

    private static HystrixRequestContext inicializeContextHystrix() {
        LOGGER.debug("Opening context Hystrix!");
        Map<String, String> headerValues = Collections.singletonMap("x-forwarded-host", Optional.ofNullable(TenantContextHolder.getTenant().getId()).orElse(""));
        HystrixRequestContext context = HystrixRequestContext.initializeContext();
        HystrixRequestVariableDefaultHeaders.getInstance().set(headerValues);
        return context;
    }
}

