/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicadolivroda;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ComunicadoLivroDaJobListener
extends JobExecutionListenerSupport {
    private static final String JOB_TYPE = "jobType";
    private final NotificacaoClient notificacaoClient;
    private final ComunicadoRepository comunicadoRepository;

    public ComunicadoLivroDaJobListener(NotificacaoClient notificacaoClient, ComunicadoRepository comunicadoRepository) {
        this.notificacaoClient = notificacaoClient;
        this.comunicadoRepository = comunicadoRepository;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        ComunicadoId comunicadoId = new ComunicadoId();
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        comunicadoId.setEntidade(jobParameters.getLong("entidade"));
        comunicadoId.setExercicio(jobParameters.getLong("exercicioComunicado"));
        comunicadoId.setIdComunicado(jobParameters.getLong("idComunicado"));
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        comunicado.setBatchJobExecutionComunicado(BatchJobExecution.of((JobExecution)jobExecution));
        this.comunicadoRepository.save((Object)comunicado);
        Notificacao notificacao = Notificacao.builder().text("Comunicado Livro de D\u00edvida Ativa - iniciado").title("Foi iniciada rotina de Comunicado Livro de D\u00edvida Ativa").time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)JobType.COMUNICADO_LIVRO_DIVIDA_ATIVA).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            ComunicadoId comunicadoId = new ComunicadoId();
            comunicadoId.setIdComunicado(jobExecution.getJobParameters().getLong("idComunicado"));
            comunicadoId.setEntidade(jobExecution.getJobParameters().getLong("entidade"));
            comunicadoId.setExercicio(jobExecution.getJobParameters().getLong("exercicio"));
            notificacao.text("Comunicado Livro de D\u00edvida Ativa - finalizado com sucesso").title("Os dados referentes ao Comunicado Livro de D\u00edvida Ativa foram gerados com sucesso.").metadata("idComunicado", (Object)comunicadoId).metadata(JOB_TYPE, (Object)JobType.COMUNICADO_LIVRO_DIVIDA_ATIVA);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de dados do Comunicado Livro de D\u00edvida Ativa").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)JobType.COMUNICADO_LIVRO_DIVIDA_ATIVA).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

