/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.validacaoendereco;

import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.dto.ComunicadoCadastroDTO;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.ComunicadoService;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ValidacaoEnderecoBatchWriter
implements ItemWriter<ComunicadoCadastroDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidacaoEnderecoBatchWriter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidacaoEnderecoBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final ComunicadoRepository comunicadoRepository;
    private final ComunicadoService comunicadoService;
    private Long entidade;
    private Long exercicio;
    private Long idComunicado;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        this.exercicio = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("exercicio"));
        this.idComunicado = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado"));
    }

    public void write(List<? extends ComunicadoCadastroDTO> items) throws Exception {
        this.comunicadoRepository.setValidacaoComunicado(this.entidade, this.exercicio, this.idComunicado, this.comunicadoRepository.areAllNotificacoesValidadas(this.entidade, this.exercicio, this.idComunicado));
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends ComunicadoCadastro> items) {
        LOGGER.info("COMUNICADOS - Valida\u00e7\u00e3o de Endere\u00e7os - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    @Generated
    public ValidacaoEnderecoBatchWriter(EntityManager entityManager, ComunicadoRepository comunicadoRepository, ComunicadoService comunicadoService) {
        this.entityManager = entityManager;
        this.comunicadoRepository = comunicadoRepository;
        this.comunicadoService = comunicadoService;
    }
}

