insert into tcedebitolanccredito(iddebitoparcelareceita, valor, anogerado, mesgerado, idtcelanccredito)
select distinct
  iddebitoparcelareceita, valor, :anogerado, :mesgerado, idtcelanccredito
from 
  ( 
select 
    dpr.iddebitoparcelareceita,
    0 as valor,
    ( 
    select 
      min(distinct tic.idtcelanccredito) 
    from 
      tribdebitoparcelareceita dpro 
    join tribreceita tro on 
      tro.entidade = :entidade 
      and tro.exercicio = :exercicio 
      and tro.receita = dpro.receita 
    join tribreceitatipo trto on 
      trto.tiporeceita = tro.tiporeceita 
    join tcedebitolanccredito ld on 
      ld.iddebitoparcelareceita = dpro.iddebitoparcelareceita 
    join tcelanccredito tic on 
      tic.idtcelanccredito = ld.idtcelanccredito 
    where 
      dpro.entidade = d.entidade 
      and dpro.exercicio = d.exercicio 
      and dpro.tipocadastro = d.tipocadastro 
      and dpro.cadastrogeral = d.cadastrogeral 
      and dpro.guiarecolhimento = d.guiarecolhimento 
      and dpro.subdivida = d.subdivida 
      and trto.classificacaoreceitatipo = trt.classificacaoreceitatipo) idTceLancCredito
  from 
    tribparcelamento p 
  join tribparcelamentodebitoorigem pd on 
    p.idparcelamento = pd.idparcelamento 
  join tribdebito d on 
    d.iddebito = pd.iddebito 
  join tribdebito dn on 
    dn.iddebito = pd.iddebitonovo 
  join tribdebitoparcelareceita dpr on 
    dpr.entidade = dn.entidade 
    and dpr.exercicio = dn.exercicio 
    and dpr.tipocadastro = dn.tipocadastro 
    and dpr.cadastrogeral = dn.cadastrogeral 
    and dpr.guiarecolhimento = dn.guiarecolhimento 
    and dpr.subdivida = dn.subdivida 
  join tribreceita tr on 
    tr.entidade = :entidade 
    and tr.exercicio = :exercicio 
    and tr.receita = dpr.receita 
  join tribreceitatipo trt on 
    trt.tiporeceita = tr.tiporeceita 
  join tribclassificacaoreceitatipo tcrt on 
    tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo 
  where 
    trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7) 
    and p.dataparcelamento between :dataInicial and :dataFinal 
union all 
  select 
     dpr.iddebitoparcelareceita,
     0 as valor,
    ( 
    select 
      min(distinct tic.idtcelanccredito) 
    from 
      tribdebitoparcelareceita dpro 
    left join tribreceita tro on 
      tro.entidade = :entidade 
      and tro.exercicio = :exercicio 
      and tro.receita = dpro.receita 
    left join tribreceitatipo trto on 
      trto.tiporeceita = tro.tiporeceita 
    left join tcedebitolanccredito ld on 
      ld.iddebitoparcelareceita = dpro.iddebitoparcelareceita 
    left join tcelanccredito tic on 
      tic.idtcelanccredito = ld.idtcelanccredito 
    where 
      dpro.entidade = d.entidade 
      and dpro.exercicio = d.exercicio 
      and dpro.tipocadastro = d.tipocadastro 
      and dpro.cadastrogeral = d.cadastrogeral 
      and dpro.guiarecolhimento = d.guiarecolhimento 
      and dpro.subdivida = d.subdivida 
      and trto.classificacaoreceitatipo = trt.classificacaoreceitatipo) idtcelanccredito
  from 
    tribestornoparcelamento ep 
  join tribestornoparcelamentodebito epd on 
    ep.idestornoparcelamento = epd.idestornoparcelamento 
  join tribdebito d on 
    d.iddebito = epd.iddebitoorigem 
  join tribdebito dn on 
    dn.iddebito = epd.iddebitodestino 
  join tribdebitoparcelareceita dpr on 
    dpr.entidade = dn.entidade 
    and dpr.exercicio = dn.exercicio 
    and dpr.tipocadastro = dn.tipocadastro 
    and dpr.cadastrogeral = dn.cadastrogeral 
    and dpr.guiarecolhimento = dn.guiarecolhimento 
    and dpr.subdivida = dn.subdivida 
  left join tribreceita tr on 
    tr.entidade = :entidade 
    and tr.exercicio = :exercicio 
    and tr.receita = dpr.receita 
  join tribreceitatipo trt on 
    trt.tiporeceita = tr.tiporeceita 
  join tribclassificacaoreceitatipo tcrt on 
    tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo 
  where 
    trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7) 
    and ep.dataestorno between :dataInicial and :dataFinal ) x 
where x.idtcelanccredito is not null 
  and not exists( 
    select 
      1 
    from 
      tceDebitoLancCredito tdlc_destino 
    where 
      tdlc_destino.iddebitoparcelareceita = x.iddebitoparcelareceita) 
