select
    tab.nrCredito,
    tab.nrAnoCredito,
    tab.cdControleLeiAto as cdControleLeiAto,
    tab.dtEstorno as dtEstorno,
    tab.dsMotivo as dsMotivo,
    tab.iddebitoparcelareceita as idDebitoParcelaReceita,
    coalesce(tab.vlEstorno, 0) as vlEstorno
from(
        select
            tlc.nrCredito,
            tlc.nrAnoCredito,
            coalesce(md.idato, cd.idato) as cdControleLeiAto,
            cd.datacancelamento as dtEstorno,
            substr(md.descricao  || ' . ' || cd.motivo, 0, 250) as dsMotivo,
            tdpr.iddebitoparcelareceita as idDebitoParcelaReceita,
            coalesce(tcdi.valorAtualizado, tcdi.valor) as vlEstorno
        from tribcancelamentodebito          cd
                 join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and tcdi.idcancelamento = cd.idcancelamento
                 left join tribmotivodesconto         md   on md.motivodesconto  = cd.motivocancelamento
                 left join tribtipodeducao            td   on td.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)
                 join tceDebitoLancCredito       tdlc on tdlc.iddebitoParcelareceita = tcdi.iddebitoparcelareceita
                 join tcelanccredito             tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
                 join tribdebitoparcelareceita   tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                 left join tribreceita                tr   on tr.entidade = :entidade and tr.exercicio = :exercicio
            and tr.receita = tdpr.receita
                 left join tribreceitatipo            trt  on trt.tiporeceita = tr.tiporeceita
        where (cd.datacancelamento between :dataInicial and :dataFinal)
          and cd.entidade = :entidade
          and td.tipotce = 8
          and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
       and not exists (
         select 1
         from tcedebitolanccreditoEst tdlc
         where tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
       )
       and not exists(select * from TRIBPARCELAMENTOCANCELAMENTO pc
                         where cd.ENTIDADE = pc.ENTIDADE
                           and cd.EXERCICIO = pc.EXERCICIOCANCELAMENTO
                           and cd.IDCANCELAMENTO = pc.IDCANCELAMENTO)
        union all
        select
            tlc.nrCredito,
            tlc.nrAnoCredito,
            tlc.cdcontroleleiato as cdControleLeiAto,
            trc.dtestorno as dtEstorno,
            substr(trc.dsmotivoestorno, 0, 250) as dsMotivo,
            cast(0 as numeric) as idDebitoParcelaReceita,
            coalesce(trc.valor,0) as vlEstorno
        from tceretencaocontabil trc
                 left outer join tceretencaolanccredito trlc on trlc.idretencaocontabil = trc.idretencaocontabil
                 left outer join tcelanccredito tlc on tlc.idtcelanccredito = trlc.idtcelanccredito
        where (trc.dtEstorno between :dataInicial and :dataFinal)
          and not exists (
               select 1 from tceretencaolanccreditoest trlce
               where trlce.idretencaocontabil = trc.idretencaocontabil
          )
    ) tab
order by tab.dtEstorno,
         tab.nrCredito,
         tab.nrAnoCredito,
         tab.cdControleLeiAto