select filtro.nrDeducao,
       filtro.nrAnoDeducao,
       filtro.idAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo,
       filtro.idCancelamento,
       filtro.entidade,
       filtro.exercicio,
       filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.iddebitoparcelareceita,
       filtro.idParcelamento,
       filtro.idDebitoReceita
from (select distinct md.idato                                                       as idAto,
                      tc.nrdeducao                                                   as nrDeducao,
                      tc.nranodeducao                                                as nrAnoDeducao,
                      tcdi.dataestorno                                               as dtEstorno,
                      tcdi.valor                                                     as vlEstorno,
                      substr(md.descricao || '.' || coalesce(cd.motivo, ''), 0, 250) as dsMotivo,
                      cd.idcancelamento                                              as idCancelamento,
                      cd.entidade                                                    as entidade,
                      cd.exercicio                                                   as exercicio,
                      cast(null as integer)                                          as idpagamentobloqueto,
                      cast(null as integer)                                          as idcreditocontribuinteitem,
                      tcdi.iddebitoparcelareceita                                    as iddebitoparcelareceita,
                      cast(null as integer)                                          as idParcelamento,
                      cast(null as integer)                                          as idDebitoReceita
      from tribcancelamentodebito cd
               join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and
                                                       tcdi.idcancelamento = cd.idcancelamento
               left join tceDeducaoCancelamentoDA tdc on tdc.entidade = tcdi.entidade and tdc.exercicio = tcdi.exercicio
          and tdc.idcancelamento = tcdi.idcancelamento and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
               left join tceDeducaoCreditoDA tc on tc.idtcededucaocreditoDA = tdc.idtcededucaocreditoDA
               left join tribmotivodesconto md on md.motivodesconto = cd.motivocancelamento
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
               left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio
          and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      where cd.entidade = :entidade
        and tcdi.dataestorno between :dataInicial and :dataFinal
        and tcdi.estornado = 'S'
        and cd.tipoDeducao <> 8
        and cd.situacaolegal in (1, 2)
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and not exists (
            select 1
            from tceDeducaoCancelamentoDAEst tdc
            where tdc.entidade = tcdi.entidade
              and tdc.exercicio = tcdi.exercicio
              and tdc.idcancelamento = tcdi.idcancelamento
              and tdc.iddebitoparcelareceita = tcdi.iddebitoparcelareceita)
      union all
      select distinct md.idato,
                      tc.nrdeducao                 as nrDeducao,
                      tc.nranodeducao              as nrAnoDeducao,
                      tep.data                     as dtEstorno,
                      tpd.valordesconto            as vlEstorno,
                      substr(md.descricao, 0, 250) as dsMotivo,
                      cast(null as integer)        as idcancelamento,
                      cast(null as integer)        as entidade,
                      cast(null as integer)        as exercicio,
                      tepi.idpagamentobloqueto     as idPagamentoBloqueto,
                      cast(null as integer)        as idcreditocontribuinteitem,
                      tepi.iddebitoparcelareceita  as idDebitoParcelaReceita,
                      cast(null as integer)        as idParcelamento,
                      cast(null as integer)        as idDebitoReceita
      from tribpagamentodebito tpd
               join tribEstornoPagamentoItem tepi on tepi.idpagamentobloqueto = tpd.idPagamentoBloqueto and
                                                     tepi.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               join tribestornopagamento tep
                    on tep.entidade = tepi.entidade and tep.exercicio = tepi.exercicio and tep.estorno = tepi.estorno
               join tcededucaopagamentoDA tdp on tpd.idpagamentobloqueto = tpd.idpagamentobloqueto and
                                                 tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               join tceDeducaoCreditoDA tc on tc.idtcededucaocreditoDA = tdp.idtcededucaocreditoDA
               left join tribmotivodesconto md on md.motivodesconto = tep.motivodesconto
      where tep.data between :dataInicial and :dataFinal
        and tep.entidade = :entidade
        and tpd.situacaolegal in (1, 2)
        and not exists (
            select 1
            from tceDeducaoPagamentoDAEst tdp
            where tdp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
              and tdp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
      union all
      select distinct md.idato,
                      tc.nrdeducao                                                               as nrDeducao,
                      tc.nranodeducao                                                            as nrAnoDeducao,
                      tcc.dataestorno                                                            as dtEstorno,
                      tcci.valordesconto                                                         as vlEstorno,
                      substr(md.descricao || '.' || coalesce(tcc.observacaoestorno, ''), 0, 250) as dsMotivo,
                      cast(null as integer)                                                      as idcancelamento,
                      cast(null as integer)                                                      as entidade,
                      cast(null as integer)                                                      as exercicio,
                      cast(null as integer)                                                      as idpagamentobloqueto,
                      tdcc.idcreditocontribuinteitem                                             as idCreditoContribuinteItem,
                      tdcc.iddebitoparcelareceita                                                as idDebitoParcelaReceita,
                      cast(null as integer)                                                      as idParcelamento,
                      cast(null as integer)                                                      as idDebitoReceita
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tceDeducaoCreditoCreditoDA tdcc
                    on tdcc.idCreditoContribuinteItem = tcci.idCreditoContribuinteItem and
                       tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
               join tceDeducaoCreditoDA tc on tc.idtcededucaocreditoDA = tdcc.idtcededucaocreditoDA
               left join tribmotivodesconto md on md.motivodesconto = tcc.motivodescontoestorno
      where tcc.dataestorno between :dataInicial and :dataFinal
        and tcc.entidade = :entidade
        and tcc.valorestornado > 0
        and tcci.valordesconto > 0
        and not exists (
            select 1
            from tceDeducaoCreditoCreditoDAEst tdcc
            where tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
                and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita)
      union all
      /*Estorno desconto de parcelamento voltando para a origem*/
      select tdcda.cdcontroleleiato                    as idAto,
             tdcda.nrdeducao                           as nrDeducao,
             tdcda.nranodeducao                        as nrAnoDeducao,
             tep.dataestorno                           as dtEstorno,
             sum(acrescimo.valor)                      as vlEstorno,
             'Estorno de parcelamento: ' || tep.motivo as dsMotivo,
             cast(null as integer)                     as idCancelamento,
             cast(null as integer)                     as entidade,
             cast(null as integer)                     as exercicio,
             cast(null as integer)                     as idPagamentoBloqueto,
             cast(null as integer)                     as idCreditoContribuinteItem,
             cast(null as integer)                     as idDebitoParcelaReceita,
             tep.idparcelamento                        as idParcelamento,
             tdr.iddebitoreceita                       as idDebitoReceita

      from tribestornoparcelamento tep
               left outer join tribparcelamento tp
                               on tp.idparcelamento = tep.idparcelamento
               left outer join tribparamparcelamento tpp
                               on tp.idparametroparcelamento = tpp.idparametroparcelamento
               left outer join tribmotivodesconto tmd
                               on tpp.motivoestorno = tmd.motivodesconto
               left outer join tribtipooperacaotce ttot
                               on tmd.idtipooperacaotce = ttot.idtipooperacaotce
               left outer join tribmotivodesconto tmdjurosfinan
                               on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
               left outer join tribtipooperacaotce ttotjurosfinan
                               on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
               join (select tpre.idparcelamentoreceitaespelho,
                            tpre.idparcelamento,
                            tpre.receitaorigem          as tributoorigem,
                            tpre.receitaorigem          as tributo,
                            tpre.valordescontoprincipal as valor,
                            tpre.iddebito,
                            tpre.iddebitonovo
                     from tribparcelamentoreceitaespelho tpre
                     where valordescontoprincipal > 0
                     union
                     select tpre.idparcelamentoreceitaespelho,
                            tpre.idparcelamento,
                            tpre.receitaorigem      as tributoorigem,
                            tpre.jurosdestino       as tributo,
                            tpre.valordescontojuros as valor,
                            tpre.iddebito,
                            tpre.iddebitonovo
                     from tribparcelamentoreceitaespelho tpre
                     where valordescontojuros > 0
                     union
                     select tpre.idparcelamentoreceitaespelho,
                            tpre.idparcelamento,
                            tpre.receitaorigem      as tributoorigem,
                            tpre.multadestino       as tributo,
                            tpre.valordescontomulta as valor,
                            tpre.iddebito,
                            tpre.iddebitonovo
                     from tribparcelamentoreceitaespelho tpre
                     where valordescontomulta > 0
                     union
                     select tpre.idparcelamentoreceitaespelho,
                            tpre.idparcelamento,
                            tpre.receitaorigem         as tributoorigem,
                            tpre.correcaodestino       as tributo,
                            tpre.valordescontocorrecao as valor,
                            tpre.iddebito,
                            tpre.iddebitonovo
                     from tribparcelamentoreceitaespelho tpre
                     where valordescontocorrecao > 0) acrescimo
                    on acrescimo.idparcelamento = tp.idparcelamento
               left outer join tribdebito td
                               on td.iddebito = acrescimo.iddebito
               left outer join tribdebitoreceita tdr
                               on td.entidade = tdr.entidade
                                   and td.exercicio = tdr.exercicio
                                   and td.tipocadastro = tdr.tipocadastro
                                   and td.cadastrogeral = tdr.cadastrogeral
                                   and td.guiarecolhimento = tdr.guiarecolhimento
                                   and td.subdivida = tdr.subdivida
                                   and acrescimo.tributoorigem = tdr.receita
               left outer join tribdebito tdd
                               on tdd.iddebito = acrescimo.iddebitonovo
               left outer join tribdebitoparcela tdp
                               on tdd.entidade = tdp.entidade
                                   and tdd.exercicio = tdp.exercicio
                                   and tdd.tipocadastro = tdp.tipocadastro
                                   and tdd.cadastrogeral = tdp.cadastrogeral
                                   and tdd.guiarecolhimento = tdp.guiarecolhimento
                                   and tdd.subdivida = tdp.subdivida
                                   and tdp.parcela = 1
               left outer join tribreceita tr
                               on td.entidade = tr.entidade
                                   and :exercicio = tr.exercicio
                                   and acrescimo.tributo = tr.receita
               left outer join tcededucaoparcelamentoda tdpda
                               on tdpda.idparcelamento = tep.idparcelamento
                                   and tdpda.iddebitoreceita = tdr.iddebitoreceita
               left outer join tcededucaocreditoda tdcda
                               on tdpda.idtcededucaocreditoda = tdcda.idtcededucaocreditoda
      where tep.dataestorno between :dataInicial and :dataFinal
        and tp.anocontrato = :exercicio
        and tdp.situacaolegal in (1, 2)
        and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
        and exists(select 1
                   from tribestornoparcelamentodebito tepd
                   where tepd.idestornoparcelamento = tep.idestornoparcelamento
                     and tepd.iddebitoorigem > tepd.iddebitodestino)
        and not exists( select 1
                       from tcededucaoparcelamentodaest tdpdae
                       where tdpdae.idparcelamento = tep.idparcelamento
                        and tdpdae.iddebitoreceita = tdr.iddebitoreceita)
      group by tdcda.nrdeducao, tdcda.nranodeducao, tdcda.cdcontroleleiato, tdcda.idtipocredito,
               tep.dataestorno,
               'Estorno de parcelamento: ' || tep.motivo,
               tep.idparcelamento,
               tdr.iddebitoreceita
      union all
      /*Estorno desconto de parcelamento nova subdivida*/
      select tdcda.cdcontroleleiato                    as idAto,
             tdcda.nrdeducao                           as nrDeducao,
             tdcda.nranodeducao                        as nrAnoDeducao,
             tep.dataestorno                           as dtEstorno,
             sum(desconto.valor)                       as vlEstorno,
             'Estorno de parcelamento: ' || tep.motivo as dsMotivo,
             cast(null as integer)                     as idCancelamento,
             cast(null as integer)                     as entidade,
             cast(null as integer)                     as exercicio,
             cast(null as integer)                     as idPagamentoBloqueto,
             cast(null as integer)                     as idCreditoContribuinteItem,
             cast(null as integer)                     as idDebitoParcelaReceita,
             tep.idparcelamento                        as idParcelamento,
             tdr.iddebitoreceita                       as idDebitoReceita
      from tribestornoparcelamento tep
               left outer join tribparcelamento tp on tp.idparcelamento = tep.idparcelamento
               left outer join (select tepre.idestornoparcelamento,
                                       tepre.idparcelamentoreceitaespelho,
                                       tepre.valordescontoprincipalestorno as valor,
                                       'P'                                 as classificacaotributo,
                                       pre.receitaorigem                   as receita
                                from tribestornoparcreceitaespelho tepre
                                         join tribparcelamentoreceitaespelho pre
                                              on tepre.idparcelamentoreceitaespelho = pre.idparcelamentoreceitaespelho
                                where tepre.valordescontoprincipalestorno > 0
                                union
                                select tepre.idestornoparcelamento,
                                       tepre.idparcelamentoreceitaespelho,
                                       tepre.valordescontojurosestorno as valor,
                                       'J'                             as classificacaotributo,
                                       pre.receitaorigem               as receita
                                from tribestornoparcreceitaespelho tepre
                                         join tribparcelamentoreceitaespelho pre
                                              on tepre.idparcelamentoreceitaespelho = pre.idparcelamentoreceitaespelho
                                where valordescontojurosestorno > 0
                                union
                                select tepre.idestornoparcelamento,
                                       tepre.idparcelamentoreceitaespelho,
                                       tepre.valordescontomultaestorno as valor,
                                       'M'                             as classificacaotributo,
                                       pre.receitaorigem               as receita
                                from tribestornoparcreceitaespelho tepre
                                         join tribparcelamentoreceitaespelho pre
                                              on tepre.idparcelamentoreceitaespelho = pre.idparcelamentoreceitaespelho
                                where valordescontomultaestorno > 0
                                union
                                select tepre.idestornoparcelamento,
                                       tepre.idparcelamentoreceitaespelho,
                                       tepre.valordescontocorrecaoestorno as valor,
                                       'C'                                as classificacaotributo,
                                       pre.receitaorigem                  as receita
                                from tribestornoparcreceitaespelho tepre
                                         join tribparcelamentoreceitaespelho pre
                                              on tepre.idparcelamentoreceitaespelho = pre.idparcelamentoreceitaespelho
                                where valordescontocorrecaoestorno > 0) desconto
                               on desconto.idestornoparcelamento = tep.idestornoparcelamento
               left outer join tribparcelamentoreceitaespelho tpre
                               on tpre.idparcelamentoreceitaespelho = desconto.idparcelamentoreceitaespelho
               left outer join tribdebito td
                               on td.iddebito = tpre.iddebitonovo
               left outer join tribdebito tdo
                               on tdo.iddebito = tpre.iddebito
               left outer join tribdebitoreceita tdr
                               on tdo.entidade = tdr.entidade
                                   and tdo.exercicio = tdr.exercicio
                                   and tdo.tipocadastro = tdr.tipocadastro
                                   and tdo.cadastrogeral = tdr.cadastrogeral
                                   and tdo.guiarecolhimento = tdr.guiarecolhimento
                                   and tdo.subdivida = tdr.subdivida
                                   and desconto.receita = tdr.receita
               left outer join tribdebitoparcela tdp
                               on td.entidade = tdp.entidade
                                   and td.exercicio = tdp.exercicio
                                   and td.tipocadastro = tdp.tipocadastro
                                   and td.cadastrogeral = tdp.cadastrogeral
                                   and td.guiarecolhimento = tdp.guiarecolhimento
                                   and td.subdivida = tdp.subdivida
                                   and tdp.parcela = 1
               left outer join tribreceita tr
                               on td.entidade = tr.entidade
                                   and :exercicio = tr.exercicio
                                   and tpre.receitaorigem = tr.receita
               left outer join tcededucaoparcelamentoda tdpda on tdpda.idparcelamento = tep.idparcelamento
          and tdpda.iddebitoreceita = tdr.iddebitoreceita
               left outer join tcededucaocreditoda tdcda on tdpda.idtcededucaocreditoda = tdcda.idtcededucaocreditoda
      where td.constituido = 'S'
        and tep.dataestorno between :dataInicial and :dataFinal
        and tp.anocontrato = :exercicio
        and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
        and exists(select 1
                   from tribestornoparcelamentodebito tepd
                   where tepd.idestornoparcelamento = tep.idestornoparcelamento
                     and tepd.iddebitoorigem < tepd.iddebitodestino)
      group by tdcda.nrdeducao, tdcda.nranodeducao, tdcda.cdcontroleleiato, tdcda.idtipocredito, tep.dataestorno,
               'Estorno de parcelamento: ' || tep.motivo, tep.idparcelamento, tdr.iddebitoreceita) filtro
order by filtro.dtEstorno,
         filtro.nrDeducao,
         filtro.nrAnoDeducao,
         filtro.idAto