select filtro.nrAtualizacao,
       filtro.nrAnoAtualizacao,
       filtro.idAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo,
       filtro.idPagamentoBloqueto,
       filtro.idParcelamento,
       filtro.idEstornoParcelamento,
       filtro.idCreditoContribuinteItem,
       filtro.idDebitoParcelaReceita
from
    (
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valorjuros as vlEstorno,
               substr(tmd.descricao || '.' || tep.motivoestorno, 0, 250) as dsMotivo,
               tepi.idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita
        FROM tribestornopagamento             tep
                 join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
        WHERE tep.entidade = :entidade
          and tep.data BETWEEN :dataInicial AND :dataFinal
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valorjuros > 0
          and tamc.idtipoatualizacaocredito = 1
          and not exists (
            select 1
            from tceAtualizaMonePagamentoDAEst t
            where t.idpagamentobloqueto = tpd.idpagamentobloqueto
              and t.iddebitoparcelareceita = tpd.iddebitoparcelareceita
        )
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valormulta as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tepi.idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita
        FROM tribestornopagamento             tep
                 join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
        WHERE tep.entidade = :entidade
          and tep.data BETWEEN :dataInicial AND :dataFinal
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valormulta > 0
          and tamc.idtipoatualizacaocredito = 2
          and not exists (
            select 1
            from tceAtualizaMonePagamentoDAEst t
            where t.idpagamentobloqueto = tpd.idpagamentobloqueto
              and t.iddebitoparcelareceita = tpd.iddebitoparcelareceita
        )
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valorcorrecao as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tepi.idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita
        FROM tribestornopagamento             tep
                 join tribestornopagamentoitem    tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito         tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMonePagamentoDA  tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA       tamc on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 left join tribmotivodesconto          tmd  on tmd.motivodesconto = tep.motivodesconto
        WHERE tep.entidade = :entidade
          and tep.data BETWEEN :dataInicial AND :dataFinal
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valorcorrecao > 0
          and tamc.idtipoatualizacaocredito = 3
          and not exists (
            select 1
            from tceAtualizaMonePagamentoDAEst t
            where t.idpagamentobloqueto = tpd.idpagamentobloqueto
              and t.iddebitoparcelareceita = tpd.iddebitoparcelareceita
        )
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valorjuros as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
        WHERE tcc.entidade = :entidade
          and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tcci.valorjuros > 0
          and tamc.idtipoatualizacaocredito = 1
          and not exists (
            select 1
            from tceAtualizaMoneCreditoDAEst t
            where t.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and t.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        )
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valormulta as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
        WHERE tcc.entidade = :entidade
          and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tcci.valormulta > 0
          and tamc.idtipoatualizacaocredito = 2
          and not exists (
            select 1
            from tceAtualizaMoneCreditoDAEst t
            where t.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and t.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        )
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valorcorrecao as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idPagamentoBloqueto,
               0 as idParcelamento,
               0 as idEstornoParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tceAtualizaMoneCreditoDA     tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 join tceAtualizaMoneCredDA        tamc  on tamc.idtceatualizamonecredDA = tamcc.idtceatualizamonecredDA
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
        WHERE tcc.entidade = :entidade
          and tcc.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tcci.valorcorrecao > 0
          and tamc.idtipoatualizacaocredito = 3
          and not exists (
            select 1
            from tceAtualizaMoneCreditoDAEst t
            where t.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and t.iddebitoparcelareceita = tcci.iddebitoparcelareceita
        )
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.dataestorno) as nrMes,
               extract(year  from tep.dataestorno) as nrAno,
               tmd.idato,
               tep.dataestorno as dtEstorno,
               sum(tdpr.valor) as vlEstorno,
               max(substr(tmd.descricao || '.'  || tep.motivo, 0, 250)) as dsMotivo,
               0 as idPagamentoBloqueto,
               tpar.idParcelamento,
               0 as idEstornoParcelamento,
               0 as idCreditoContribuinteItem,
               tppro.iddebitoparcelareceita
        from tribestornoparcelamento            tep
                 join tribparcelamento              tpar  on tpar.idparcelamento = tep.idparcelamento
                 join tribParcelamentoParcRecOrigem tppro on tppro.idparcelamento = tpar.idparcelamento
                 join tribestparcelamparcrecDestino tepd  on tepd.iddebitoparcelareceita = tppro.iddebitoparcelareceita and tepd.idestornoparcelamento = tep.idestornoparcelamento
                 join tceAtualizaMoneParcDA         tamp  on tamp.idparcelamento = tppro.idparcelamento and tamp.iddebitoparcelareceita = tppro.iddebitoparcelareceita
                 join tceAtualizaMoneCredDa         tamc  on tamc.idtceatualizamonecredDA = tamp.idtceatualizamonecredDA
                 join tribparcelamentodebitoorigem  tpdo  on tpdo.idparcelamento = tep.idparcelamento
                 join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo
                 join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio
            and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral
            and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida
                 join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio
            and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral
            and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida
            and tdpr.parcela = tdp.parcela
                 join tribreceita                   tr    on tr.entidade = :entidade and tr.exercicio = :exercicio
            and tr.receita = tdpr.receita
                 left join tribparamparcelamento         tpp   on tpp.idparametroparcelamento =  tpar.idparametroparcelamento
                 left join tribmotivodesconto            tmd   on tmd.motivodesconto = tpp.motivoestorno
        WHERE tdpr.entidade = :entidade
          and tep.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tep.estornado = 'N'
          and ((tr.classificacao = 'J' and tamc.idtipoatualizacaocredito = 1 ) or
               (tr.classificacao = 'M' and tamc.idtipoatualizacaocredito = 2 ) or
               (tr.classificacao = 'C' and tamc.idtipoatualizacaocredito = 3 ) )
          and not exists (
            select 1
            from tceAtualizaMoneParcEst t
            where t.idParcelamento = tpar.idparcelamento
              and t.iddebitoparcelareceita =  tppro.iddebitoparcelareceita
        )
        group by tamc.nrAtualizacao,
                 tamc.nrAnoAtualizacao,
                 tep.dataestorno,
                 tmd.idato,
                 tpar.idParcelamento,
                 tppro.iddebitoparcelareceita
        union all
        select
            tamcda.nratualizacao as nrAtualizacao,
            tamcda.nranoatualizacao as nrAnoAtualizacao,
            extract(month from tep.dataestorno) as nrMes,
            extract(year  from tep.dataestorno) as nrAno,
            tamcda.cdcontroleleiato,
            tep.dataestorno as dtEstorno,
            acrescimo.valor as vlEstorno,
            max(substr(tmd.descricao || '.'  || tep.motivo, 0, 250)) as dsMotivo,
            0 as idPagamentoBloqueto,
            tp.idParcelamento,
            tep.idestornoparcelamento as idEstornoParcelamento,
            0 as idCreditoContribuinteItem,
            tdr.iddebitoreceita as iddebitoparcelareceita
        from   tribestornoparcelamento tep
                   left outer join tribparcelamento tp
                                   on tp.idparcelamento = tep.idparcelamento
                   left outer join tribparamparcelamento tpp
                                   on tp.idparametroparcelamento = tpp.idparametroparcelamento
                   left outer join tribmotivodesconto tmd
                                   on tpp.motivoestorno = tmd.motivodesconto
                   left outer join tribtipooperacaotce ttot
                                   on tmd.idtipooperacaotce = ttot.idtipooperacaotce
                   left outer join tribmotivodesconto tmdjurosfinan
                                   on tpp.motivodescontofinan = tmdjurosfinan.motivodesconto
                   left outer join tribtipooperacaotce ttotjurosfinan
                                   on tmdjurosfinan.idtipooperacaotce = ttotjurosfinan.idtipooperacaotce
                   join (select tpre.idparcelamentoreceitaespelho,
                                tpre.idparcelamento,
                                tpre.receitaorigem as tributoorigem,
                                tpre.jurosdestino as tributo,
                                tpre.valorjuros   as valor,
                                tpre.iddebito,
                                tpre.iddebitonovo
                         from   tribparcelamentoreceitaespelho tpre
                         where  valorjuros > 0
                         union
                         select tpre.idparcelamentoreceitaespelho,
                                tpre.idparcelamento,
                                tpre.receitaorigem as tributoorigem,
                                tpre.multadestino as tributo,
                                tpre.valormulta   as valor,
                                tpre.iddebito,
                                tpre.iddebitonovo
                         from   tribparcelamentoreceitaespelho tpre
                         where  valormulta > 0
                         union
                         select tpre.idparcelamentoreceitaespelho,
                                tpre.idparcelamento,
                                tpre.receitaorigem as tributoorigem,
                                tpre.correcaodestino as tributo,
                                tpre.valorcorrecao   as valor,
                                tpre.iddebito,
                                tpre.iddebitonovo
                         from   tribparcelamentoreceitaespelho tpre
                         where  valorcorrecao > 0
                         union
                         select tpre.idparcelamentoreceitaespelho,
                                tpre.idparcelamento,
                                tpre.receitaorigem as tributoorigem,
                                tpre.jurosfinandestino as tributo,
                                tpre.valorjurosfinan as valor,
                                tpre.iddebito,
                                tpre.iddebitonovo
                         from   tribparcelamentoreceitaespelho tpre
                         where  valorjurosfinan > 0) acrescimo
                        on acrescimo.idparcelamento = tp.idparcelamento
                   left outer join tribdebito td
                                   on td.iddebito = acrescimo.iddebito
                   left outer join tribdebitoreceita tdr
                                   on td.entidade = tdr.entidade
                                       and td.exercicio = tdr.exercicio
                                       and td.tipocadastro = tdr.tipocadastro
                                       and td.cadastrogeral = tdr.cadastrogeral
                                       and td.guiarecolhimento = tdr.guiarecolhimento
                                       and td.subdivida = tdr.subdivida
                                       and acrescimo.tributoorigem = tdr.receita
                   left outer join tribdebito tdd
                                   on tdd.iddebito = acrescimo.iddebitonovo
                   left outer join tribdebitoparcela tdp
                                   on tdd.entidade = tdp.entidade
                                       and tdd.exercicio = tdp.exercicio
                                       and tdd.tipocadastro = tdp.tipocadastro
                                       and tdd.cadastrogeral = tdp.cadastrogeral
                                       and tdd.guiarecolhimento = tdp.guiarecolhimento
                                       and tdd.subdivida = tdp.subdivida
                                       and tdp.parcela = 1
                   left outer join tribreceita tr
                                   on td.entidade = tr.entidade
                                       and :exercicio = tr.exercicio
                                       and acrescimo.tributo = tr.receita
                   left outer join tceAtualizaMoneParcRecDA tampda
                                   on tampda.idparcelamento = tep.idparcelamento
                                       and tampda.iddebitoreceita = tdr.iddebitoreceita
                                       and tampda.tipoatualizacao  = (case WHEN tr.classificacao = 'J' OR tr.classificacao = 'F' THEN 1
                                                                           WHEN tr.classificacao = 'M' THEN 2
                                                                           ELSE 3
                                           END)
                   left outer join tceatualizamonecredda tamcda
                                   on tampda.idtceatualizamonecredda = tamcda.idtceatualizamonecredda
        where tep.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tp.anocontrato = :exercicio
          and  tdp.situacaolegal in (1,2)
          and (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
          and exists(select 1 from tribestornoparcelamentodebito tepd
                     where tepd.idestornoparcelamento = tep.idestornoparcelamento
                       and tepd.iddebitoorigem > tepd.iddebitodestino)
          and not exists (select 1 from tceAtualizaMoneParcDARecEst tampda
                          where tampda.idparcelamento = tep.idparcelamento
                            and tampda.iddebitoreceita = tdr.iddebitoreceita)
        group  by tamcda.nrAtualizacao,
                  tamcda.nrAnoAtualizacao,
                  tamcda.cdcontroleleiato ,
                  tep.dataestorno,
                  'Estorno de parcelamento: '|| tep.motivo,
                  tep.idparcelamento,
                  tdr.iddebitoreceita,
                  tamcda.idtipoatualizacaocredito,
                  tmd.idato,
                  tp.idParcelamento,
                  acrescimo.valor,
                  tep.idestornoparcelamento
    ) filtro
order by filtro.dtEstorno,
         filtro.nrAtualizacao,
         filtro.nrAnoAtualizacao,
         filtro.idAto
