select filtro.nrAtualizacao,
       filtro.nrAnoAtualizacao,
       filtro.idAto,
       filtro.dtEstorno,
       filtro.vlEstorno,
       filtro.dsMotivo,
       filtro.idPagamentoBloqueto,
       filtro.idParcelamento,
       filtro.idCreditoContribuinteItem,
       filtro.idDebitoParcelaReceita
from(
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valorjuros as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tpd.idpagamentobloqueto,
               0 as idParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita
        from tribestornopagamento              tep
                 join tribestornopagamentoitem     tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito          tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tribdebitoparcelareceita     tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tribreceita                  tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 left join tceAtualizaMonePagamento     tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 left join tceAtualizaMoneCred          tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
                 left join tribmotivodesconto           tmd  on tmd.motivodesconto = tep.motivodesconto
        WHERE tep.entidade = :entidade
          and (tep.data BETWEEN :dataInicial AND :dataFinal)
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tpd.situacaolegal = 0
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valorjuros > 0
          and tamc.idtipoatualizacaocredito = 1
          and not exists (
            select 1
            from tceAtualizaMonePagamentoEst tamp
            where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
              and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita )
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valormulta as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tpd.idpagamentobloqueto,
               0 as idParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita
        from tribestornopagamento              tep
                 join tribestornopagamentoitem     tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito          tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tribdebitoparcelareceita     tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tribreceita                  tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 left join tceAtualizaMonePagamento     tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 left join tceAtualizaMoneCred          tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
                 left join tribmotivodesconto           tmd  on tmd.motivodesconto = tep.motivodesconto
        WHERE tep.entidade = :entidade
          and (tep.data BETWEEN :dataInicial AND :dataFinal)
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tpd.situacaolegal = 0
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valormulta > 0
          and tamc.idtipoatualizacaocredito = 2
          and not exists (
            select 1
            from tceAtualizaMonePagamentoEst tamp
            where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
              and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tep.data) as nrMes,
               extract(year  from tep.data) as nrAno,
               tmd.idato,
               tep.data as dtEstorno,
               tpd.valorcorrecao as vlEstorno,
               substr(tmd.descricao || '.'  || tep.motivoestorno, 0, 250) as dsMotivo,
               tpd.idpagamentobloqueto,
               0 as idParcelamento,
               0 as idCreditoContribuinteItem,
               tepi.iddebitoparcelareceita
        from tribestornopagamento              tep
                 join tribestornopagamentoitem     tepi on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
                 join tribpagamentodebito          tpd  on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto and tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 join tribdebitoparcelareceita     tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tribreceita                  tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 left join tceAtualizaMonePagamento     tamp on tamp.idpagamentobloqueto = tepi.idpagamentobloqueto and tamp.iddebitoparcelareceita = tepi.iddebitoparcelareceita
                 left join tceAtualizaMoneCred          tamc on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
                 left join tribmotivodesconto           tmd  on tmd.motivodesconto = tep.motivodesconto
        WHERE tep.entidade = :entidade
          and (tep.data BETWEEN :dataInicial AND :dataFinal)
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tpd.situacaolegal = 0
          and tep.geracreditocontribuinte = 'N'
          and tpd.estorno = 'S'
          and tpd.valorcorrecao > 0
          and tamc.idtipoatualizacaocredito = 3
          and not exists (
            select 1
            from tceAtualizaMonePagamentoEst tamp
            where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
              and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valorjuros as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idpagamentobloqueto,
               0 as idParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tribdebitoparcelareceita     tdpr  on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 join tribdebitoparcela            tdp   on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
            and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
            and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                 left join tribreceita                  tr    on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt   on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt  on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 left join tceAtualizaMoneCredito       tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceAtualizaMoneCred          tamc  on tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
        WHERE tcc.entidade = :entidade
          and (tcc.dataestorno BETWEEN :dataInicial AND :dataFinal)
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tdp.situacaolegal = 0
          and tcci.valorjuros > 0
          and tamc.idtipoatualizacaocredito = 1
          and not exists (
            select 1
            from tceAtualizaMoneCreditoEst tamc
            where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valormulta as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idpagamentobloqueto,
               0 as idParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tribdebitoparcelareceita     tdpr  on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 join tribdebitoparcela            tdp   on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
            and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
            and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                 left join tribreceita                  tr    on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt   on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt  on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 left join tceAtualizaMoneCredito       tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceAtualizaMoneCred          tamc  on tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
        WHERE tcc.entidade = :entidade
          and (tcc.dataestorno BETWEEN :dataInicial AND :dataFinal)
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tdp.situacaolegal = 0
          and tcci.valormulta > 0
          and tamc.idtipoatualizacaocredito = 2
          and not exists (
            select 1
            from tceAtualizaMoneCreditoEst tamc
            where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
        union all
        SELECT tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tcc.dataestorno) as nrMes,
               extract(year  from tcc.dataestorno) as nrAno,
               tmd.idato,
               tcc.dataestorno as dtEstorno,
               tcci.valorcorrecao as vlEstorno,
               substr(tmd.descricao  || '.'  || tcc.observacaoestorno, 0, 250) as dsMotivo,
               0 as idpagamentobloqueto,
               0 as idParcelamento,
               tcci.idCreditoContribuinteItem,
               tcci.iddebitoparcelareceita
        FROM tribcreditocontribuinte           tcc
                 join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
                 join tribdebitoparcelareceita     tdpr  on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 join tribdebitoparcela            tdp   on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
            and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
            and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                 left join tribreceita                  tr    on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt   on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt  on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 left join tceAtualizaMoneCredito       tamcc on tamcc.idcreditocontribuinteitem = tcci.idCreditoContribuinteItem and tamcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceAtualizaMoneCred          tamc  on tamc.idtceatualizamonecred = tamcc.idtceatualizamonecred
                 left join tribmotivodesconto           tmd   on tmd.motivodesconto = tcc.motivodescontoestorno
        WHERE tcc.entidade = :entidade
          and (tcc.dataestorno BETWEEN :dataInicial AND :dataFinal)
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tdp.situacaolegal = 0
          and tcci.valorcorrecao > 0
          and tamc.idtipoatualizacaocredito = 3
          and not exists (
            select 1
            from tceAtualizaMoneCreditoEst tamc
            where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
              and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tdp.dataestorno) as nrMes,
               extract(year  from tdp.dataestorno) as nrAno,
               tmde.idato,
               tdp.dataestorno as dtEstorno,
               tdpd.valorjuros as vlEstorno,
               substr(tmde.descricao || '.'  || tdp.motivoestorno, 0, 250) as dsMotivo,
               0 as idpagamentobloqueto,
               0 as idParcelamento,
               0 as idCreditoContribuinteItem,
               tdpr.iddebitoparcelareceita
        from tribDacaoEmpagamento                tdp
                 join tribDacaoEmPagamentoDebito     tdpd on tdpd.iddacaopagamento = tdp.iddacaopagamento
                 left join tceAtualizaMoneDacao           tamd on tamd.iddebitoparcelareceita = tdpd.iddebitoparcelareceita
                 left join tceAtualizaMoneCred            tamc on tamc.idtceatualizamonecred = tamd.idtceatualizamonecred and tamc.idtipoatualizacaocredito  = 1
                 left join tribmotivodesconto             tmde on tmde.motivodesconto = tdp.motivodesconto
                 join tribdebitoparcelareceita       tdpr on tdpr.iddebitoparcelareceita = tdpd.iddebitoparcelareceita
                 join tribdebitoparcela              tdpa on tdpa.entidade = tdpr.entidade and tdpa.exercicio = tdpr.exercicio
            and tdpa.tipocadastro = tdpr.tipocadastro and tdpa.cadastrogeral = tdpr.cadastrogeral
            and tdpa.guiarecolhimento = tdpr.guiarecolhimento and tdpa.subdivida = tdpr.subdivida
                 left join tribreceita                    tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and  tr.receita = tdpr.receita
                 join tribreceitatipo                trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo   tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
        where tdp.entidade = :entidade
          and tdp.dataestorno between :dataInicial and :dataFinal
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tdpa.situacaolegal = 0
          and tdpd.valorjuros > 0
          and tdp.estornado = 'S'
          and not exists (select 1
                          from tceAtualizaMoneDacaoEst t
                          where t.iddebitoparcelareceita = tdpr.iddebitoparcelareceita)
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tdp.dataestorno) as nrMes,
               extract(year  from tdp.dataestorno) as nrAno,
               tmde.idato,
               tdp.dataestorno as dtEstorno,
               tdpd.valormulta as vlEstorno,
               substr(tmde.descricao || '.'  || tdp.motivoestorno, 0, 250) as dsMotivo,
               0 as idpagamentobloqueto,
               0 as idParcelamento,
               0 as idCreditoContribuinteItem,
               tdpr.iddebitoparcelareceita
        from tribDacaoEmpagamento                tdp
                 join tribDacaoEmPagamentoDebito     tdpd on tdpd.iddacaopagamento = tdp.iddacaopagamento
                 left join tceAtualizaMoneDacao           tamd on tamd.iddebitoparcelareceita = tdpd.iddebitoparcelareceita
                 left join tceAtualizaMoneCred            tamc on tamc.idtceatualizamonecred = tamd.idtceatualizamonecred and tamc.idtipoatualizacaocredito  = 1
                 left join tribmotivodesconto             tmde on tmde.motivodesconto = tdp.motivodesconto
                 join tribdebitoparcelareceita       tdpr on tdpr.iddebitoparcelareceita = tdpd.iddebitoparcelareceita
                 join tribdebitoparcela              tdpa on tdpa.entidade = tdpr.entidade and tdpa.exercicio = tdpr.exercicio
            and tdpa.tipocadastro = tdpr.tipocadastro and tdpa.cadastrogeral = tdpr.cadastrogeral
            and tdpa.guiarecolhimento = tdpr.guiarecolhimento and tdpa.subdivida = tdpr.subdivida
                 left join tribreceita                    tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and  tr.receita = tdpr.receita
                 join tribreceitatipo                trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo   tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
        where tdp.entidade = :entidade
          and tdp.dataestorno between :dataInicial and :dataFinal
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tdpa.situacaolegal = 0
          and tdpd.valormulta > 0
          and tdp.estornado = 'S'
          and not exists (select 1
                          from tceAtualizaMoneDacaoEst t
                          where t.iddebitoparcelareceita = tdpr.iddebitoparcelareceita)
        union all
        select tamc.nrAtualizacao,
               tamc.nrAnoAtualizacao,
               extract(month from tdp.dataestorno) as nrMes,
               extract(year  from tdp.dataestorno) as nrAno,
               tmde.idato,
               tdp.dataestorno as dtEstorno,
               tdpd.valorcorrecao as vlEstorno,
               substr(tmde.descricao || '.'  || tdp.motivoestorno, 0, 250) as dsMotivo,
               0 as idpagamentobloqueto,
               0 as idParcelamento,
               0 as idCreditoContribuinteItem,
               tdpr.iddebitoparcelareceita
        from tribDacaoEmpagamento                tdp
                 join tribDacaoEmPagamentoDebito     tdpd on tdpd.iddacaopagamento = tdp.iddacaopagamento
                 left join tceAtualizaMoneDacao           tamd on tamd.iddebitoparcelareceita = tdpd.iddebitoparcelareceita
                 left join tceAtualizaMoneCred            tamc on tamc.idtceatualizamonecred = tamd.idtceatualizamonecred and tamc.idtipoatualizacaocredito  = 1
                 left join tribmotivodesconto             tmde on tmde.motivodesconto = tdp.motivodesconto
                 join tribdebitoparcelareceita       tdpr on tdpr.iddebitoparcelareceita = tdpd.iddebitoparcelareceita
                 join tribdebitoparcela              tdpa on tdpa.entidade = tdpr.entidade and tdpa.exercicio = tdpr.exercicio
            and tdpa.tipocadastro = tdpr.tipocadastro and tdpa.cadastrogeral = tdpr.cadastrogeral
            and tdpa.guiarecolhimento = tdpr.guiarecolhimento and tdpa.subdivida = tdpr.subdivida
                 left join tribreceita                    tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and  tr.receita = tdpr.receita
                 join tribreceitatipo                trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo   tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
        where tdp.entidade = :entidade
          and tdp.dataestorno between :dataInicial and :dataFinal
          and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and tdpa.situacaolegal = 0
          and tdpd.valorcorrecao > 0
          and tdp.estornado = 'S'
          and not exists (select 1
                          from tceAtualizaMoneDacaoEst t
                          where t.iddebitoparcelareceita = tdpr.iddebitoparcelareceita)
        union all
        select max(tamc.nrAtualizacao),
               max(tamc.nrAnoAtualizacao),
               extract(month from tep.dataestorno) as nrMes,
               extract(year  from tep.dataestorno) as nrAno,
               tmd.idato,
               tep.dataestorno as dtEstorno,
               sum(tdpr.valor) as vlEstorno,
               max(substr(tmd.descricao || '.'  || tep.motivo, 0, 250)) as dsMotivo,
               0 as idpagamentobloqueto,
               tppro.idParcelamento,
               0 as idCreditoContribuinteItem,
               tppro.iddebitoparcelareceita
        from tribestornoparcelamento            tep
                 join tribparcelamento              tpar  on tpar.idparcelamento = tep.idparcelamento
                 join tribParcelamentoParcRecOrigem tppro on tppro.idparcelamento = tpar.idparcelamento
                 join tribestparcelamparcrecDestino tepd  on tepd.iddebitoparcelareceita = tppro.iddebitoparcelareceita and tepd.idestornoparcelamento = tep.idestornoparcelamento
                 left join tceAtualizaMoneParc           tamp  on tamp.idparcelamento = tppro.idparcelamento and tamp.iddebitoparcelareceita = tppro.iddebitoparcelareceita
                 left join tceAtualizaMoneCred           tamc  on tamc.idtceatualizamonecred = tamp.idtceatualizamonecred
                 join tribparcelamentodebitoorigem  tpdo  on tpdo.idparcelamento = tep.idparcelamento
                 join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo
                 join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio
            and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral
            and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida
                 join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio
            and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral
            and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida
            and tdpr.parcela = tdp.parcela
                 join tribreceita                        tr    on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 left join tribparamparcelamento         tpp   on tpp.idparametroparcelamento =  tpar.idparametroparcelamento
                 left join tribmotivodesconto            tmd   on tmd.motivodesconto = tpp.motivoestorno
        WHERE tdpr.entidade = :entidade
          and tep.dataestorno BETWEEN :dataInicial AND :dataFinal
          and tep.estornado = 'N'
          and ((tr.classificacao = 'J' and tamc.idtipoatualizacaocredito = 1 ) or
               (tr.classificacao = 'M' and tamc.idtipoatualizacaocredito = 2 ) or
               (tr.classificacao = 'C' and tamc.idtipoatualizacaocredito = 3 ) )
          and not exists (
            select 1
            from tceAtualizaMoneParcEst t
            where t.idParcelamento = tpar.idparcelamento
              and t.iddebitoparcelareceita =  tppro.iddebitoparcelareceita)
        group by tep.dataestorno,
                 tmd.idato,
                 tppro.idParcelamento,
                 tppro.iddebitoparcelareceita
    ) filtro
order by filtro.dtEstorno,
         filtro.nrAtualizacao,
         filtro.nrAnoAtualizacao,
         filtro.idAto