select distinct
          filtro.idTipoDeducaoCredito,
          filtro.dtDeducao,
          filtro.valor,
          filtro.dsMotivo,
          filtro.entidade,
          filtro.exercicio,
          filtro.idCancelamento,
          filtro.idpagamentobloqueto,
          filtro.iddebitoparcelareceita,
          filtro.idcreditocontribuinteitem,
          filtro.idAto as cdControleLeiAto,
          filtro.idTipoCredito,
          filtro.idParcelamento,
          filtro.idDebitoReceita,
          filtro.nrdivida,
          filtro.nranodivida
   from
   (
--      /*cancelamento*/
      select ttd.tipotce as idTipoDeducaoCredito,
             cd.datacancelamento as dtDeducao,
             tcdi.valor as valor,
             substr(md.descricao || '. ' || coalesce(cd.motivo, ''), 0, 250) as dsMotivo,
             tcdi.entidade,
             tcdi.exercicio,
             tcdi.idcancelamento,
             cast(null as integer) as idpagamentobloqueto,
             tcdi.iddebitoparcelareceita,
             cast(null as integer) as idcreditocontribuinteitem,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             md.idato,
             cast(null as integer) as idParcelamento,
             cast(null as integer) as idDebitoReceita,
             tic.nrdivida,
             tic.nranodivida
      from tribcancelamentodebito            cd
           join tribcancelamentodebitoitem   tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and tcdi.idcancelamento = cd.idcancelamento
      left join tribmotivodesconto           md   on md.motivodesconto = cd.motivocancelamento
      left join tribtipodeducao              ttd   on ttd.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)
           join tribdebitoparcelareceita     tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
      left join tribreceita                  tr   on tr.entidade = :entidade
                                                 and tr.exercicio = :exercicio
                                                 and tr.receita = tdpr.receita
           join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
           join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
           left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
           left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
      left outer join tribdebito td
           on tdpr.entidade = td.entidade
               and tdpr.exercicio = td.exercicio
               and tdpr.tipocadastro = td.tipocadastro
               and tdpr.cadastrogeral = td.cadastrogeral
               and tdpr.guiarecolhimento = td.guiarecolhimento
               and tdpr.subdivida = td.subdivida
      where (cd.datacancelamento between :dataInicial and :dataFinal)
        and cd.entidade = :entidade
        and cd.tipoDeducao <> 8
        and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
        and tcdi.situacaolegal in (1,2)
        and tcdi.valor > 0
        and not exists (select 1 from tribestornoparcelamentodebito tepd
                                          left outer join tribestornoparcelamento tep
                                                          on tepd.idestornoparcelamento = tep.idestornoparcelamento
                        where (tepd.iddebitoorigem = td.iddebito and cd.datacancelamento = tep.dataestorno)
                           or (tepd.iddebitodestino = td.iddebito and tep.estornado = 'S' and cd.datacancelamento = tep.datareabilitacao))
        and not exists (
            select 1
            from tceDeducaoCancelamentoDA tdcda
            where tdcda.entidade = tcdi.entidade
              and tdcda.exercicio = tcdi.exercicio
              and tdcda.idcancelamento = tcdi.idcancelamento
              and tdcda.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
            )
      union all
--      /*pagamento*/
      select ttd.tipotce as idTipoDeducaoCredito,
             tp.datalancamento as dtDeducao,
             tpd.valordesconto as valor,
             substr(tmd.descricao  || '. ' ||  coalesce(tbad.observacao, ''), 0, 250) as dsMotivo,
             tp.entidade,
             tp.exerciciopagamento as exercicio,
             cast(null as integer) as idcancelamento,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             cast(null as integer) as idcreditocontribuinteitem,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tmd.idato,
             cast(null as integer) as idParcelamento,
             cast(null as integer) as idDebitoReceita,
             tic.nrdivida,
             tic.nranodivida
      from tribpagamentodebito tpd
           join tribdebitoparcelareceita     tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
           join tribdebitoparcela            tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
                                                 and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
                                                 and tdp.subdivida  = tdpr.subdivida and tdp.parcela = tdpr.parcela
           join tribpagamentobloqueto        tpb  on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
           join tribpagamento                tp   on tp.entidade = tpb.entidade and tp.exerciciopagamento = tpb.exerciciopagamento and tp.pagamento = tpb.pagamento
      left join tribbaixaautomaticadetalhe   tbad on tbad.entidade = tp.entidade and tbad.exerciciopagamento = tp.exerciciopagamento and tbad.pagamento = tp.pagamento
      left join tribmotivodesconto           tmd  on tmd.motivodesconto = tpb.motivodesconto
      left join tribtipodeducao              ttd  on ttd.tipodeducao  = tmd.tipodeducao
      left join tribreceita                  tr   on tr.entidade =  :entidade
                                                 and tr.exercicio = :exercicio
                                                 and tr.receita = tdpr.receita
           join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
           join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria                cb   on cb.entidade  = tp.entidade  and cb.contabancaria = tp.contabancaria
      left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
      left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
      where tp.datalancamento between :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tp.entidade = :entidade
        and tpd.valordesconto > 0
        and tdp.situacaolegal in (1,2)
        and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
        and not exists (
            select 1
            from tceDeducaoPagamentoDA tdpda
            where tdpda.iddebitoparcelareceita = tpd.iddebitoparcelareceita
              and tdpda.idPagamentoBloqueto = tpd.idPagamentoBloqueto
          )
      union all
--      /*Credito*/
      select ttd.tipotce as idTipoDeducaoCredito,
             tcc.data as dtDeducao,
             tcci.valordesconto as valor,
             substr(tmd.descricao, 0, 250) as dsMotivo,
             tcc.entidade,
             tcc.exercicio,
             cast(null as integer) as idcancelamento,
             cast(null as integer) as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             tcci.idcreditocontribuinteitem,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tmd.idato,
             cast(null as integer) as idParcelamento,
             cast(null as integer) as idDebitoReceita,
             tic.nrdivida,
             tic.nranodivida
      from tribcreditocontribuinte           tcc
           join tribCreditoContribuinteItem  tcci  on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
           join tribdebitoparcelareceita     tdpr  on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
           join tribdebitoparcela            tdp   on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
                                                  and tdp.cadastrogeral  = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
                                                  and tdp.subdivida  = tdpr.subdivida and tdp.parcela = tdpr.parcela
           join tribbloqueto                 tb    on tb.entidade = tcc.entidade and tb.exerciciobloqueto = tcc.exerciciobloqueto and tb.bloqueto = tcc.bloqueto
      left join tribGuiaRecolhimentoFormaPag tgrfp on tgrfp.entidade = :entidade
                                                  and tgrfp.guiarecolhimento = tdpr.guiarecolhimento and tgrfp.formapagamento = tb.formapagamento
      left join tribreceita                  tr    on tr.entidade = :entidade
                                                   and tr.exercicio = :exercicio
                                                   and tr.receita = tdpr.receita
           join tribreceitatipo              trt   on trt.tiporeceita = tr.tiporeceita
           join tribclassificacaoreceitatipo tcrt  on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join tribMotivoDesconto           tmd   on tmd.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
      left join tribTipoDeducao              ttd   on ttd.tipodeducao = tmd.tipodeducao
      left join contabancaria                cb   on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
      left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
      WHERE tcc.entidade = :entidade
        AND tcc.data BETWEEN :dataInicial AND :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcci.valordesconto > 0
        and tdp.situacaolegal in (1,2)
        and tcrt.classificacaoreceitatipo in (1,2,3,4,5,7)
        and not exists (
            select 1
            from tceDeducaoCreditoCreditoDA tdcc
            where tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
              and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita
          )
      union all
      /*Dedução parcelamento DA*/
      select distinct
          ttd.tipotce as idTipoDeducaoCredito,
          tp.dataparcelamento as dtDeducao,
          coalesce(pre.valordescontoprincipal, 0) + coalesce(pre.valordescontojuros, 0) +
          coalesce(pre.valordescontomulta, 0) + coalesce(pre.valordescontocorrecao, 0) as valor,
          substr(tmd.descricao, 0, 250) as dsMotivo,
          td.entidade,
          td.exercicio,
          cast(null as integer) as idcancelamento,
          cast(null as integer) as idpagamentobloqueto,
          cast(null as integer) as iddebitoparcelareceita,
          cast(null as integer) as idcreditocontribuinteitem,
          trt.classificacaoreceitatipo as idtipocredito,
          tmd.idato,
          tp.idparcelamento,
          tdr.iddebitoreceita,
          filtro.nrdivida,
          filtro.nranodivida
      from tribparcelamento                    tp
               join tribparcelamentodebitoorigem   tpdo on tpdo.idparcelamento = tp.idparcelamento
               join tribdebito                     td   on td.iddebito = tpdo.iddebito
               join tribparcelamentoreceitaespelho pre  on pre.idparcelamento = tpdo.idparcelamento
          and pre.iddebito = tpdo.iddebito
               left join tribreceita                     tr  on tr.entidade = :entidade
          and tr.exercicio = :exercicio
          and tr.receita = pre.receitaorigem
               join tribreceitatipo                 trt on trt.tiporeceita = tr.tiporeceita
               join tribParamParcelamento           tpp on tpp.idparametroparcelamento = tp.idparametroparcelamento
               left join tribmotivodesconto              tmd on tmd.motivodesconto =  tpp.motivodesconto
               left join tribtipodeducao                 ttd on ttd.tipodeducao  = tmd.tipodeducao
               left join (select tic.nrDivida, tic.nranodivida, tdp.situacaolegal, parcorigem.idparcelamento,
                                 tdpr.entidade, tdpr.exercicio, tdpr.tipocadastro, tdpr.cadastrogeral, tdpr.guiarecolhimento, tdpr.subdivida, tdpr.receita
                          from tribdebitoparcelareceita tdpr
                                   join tribparcelamentoparcrecorigem parcorigem on parcorigem.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                                   left join tcedebitoinsccreditoda dda on dda.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                                   left join tceinsccreditoDA tic on tic.idtceinsccreditoda = dda.idtceinsccreditoda
                                   join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade
                                            and tdp.exercicio = tdpr.exercicio
                                            and tdp.tipocadastro = tdpr.tipocadastro
                                            and tdp.cadastrogeral = tdpr.cadastrogeral
                                            and tdp.guiarecolhimento = tdpr.guiarecolhimento
                                            and tdp.subdivida = tdpr.subdivida
                                            and tdp.parcela = tdpr.parcela
                          ) filtro on filtro.entidade = td.entidade
                             and filtro.exercicio = td.exercicio
                             and filtro.tipocadastro = td.tipocadastro
                             and filtro.cadastrogeral = td.cadastrogeral
                             and filtro.guiarecolhimento = td.guiarecolhimento
                             and filtro.subdivida = td.subdivida
                             and filtro.receita = pre.receitaorigem
                             and filtro.idparcelamento = tp.idparcelamento
               left join tribdebitoreceita tdr on filtro.entidade = tdr.entidade
                                                  and filtro.exercicio = tdr.exercicio
                                                  and filtro.tipocadastro = tdr.tipocadastro
                                                  and filtro.cadastrogeral = tdr.cadastrogeral
                                                  and filtro.guiarecolhimento = tdr.guiarecolhimento
                                                  and filtro.subdivida = tdr.subdivida
                                                  and filtro.receita = tdr.receita
      where (tp.dataparcelamento between :dataInicial and :dataFinal)
        and tp.entidade = :entidade
        and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
        and filtro.situacaolegal in (1,2)
        and coalesce(pre.valordescontoprincipal, 0) + coalesce(pre.valordescontojuros, 0) + coalesce(pre.valordescontomulta, 0) + coalesce(pre.valordescontocorrecao, 0) > 0
        and not exists (
          select 1
          from tceDeducaoParcelamentoDA t
          where t.idParcelamento = tp.idParcelamento
            and t.idDebitoReceita = tdr.idDebitoReceita
      )
   ) filtro

order by filtro.nrdivida , filtro.nranodivida, filtro.idTipoDeducaoCredito, filtro.idAto, filtro.dtDeducao;