select filtro.idTipoAtualizacaoCredito,
       filtro.dtAtualizacao,
       filtro.nrcredito,
       filtro.nranocredito,
       filtro.idpagamentobloqueto,
       filtro.iddebitoparcelareceita,
       filtro.iddebitoreceita,
       filtro.idCreditoContribuinteItem,
       filtro.idparcelamento,
       filtro.vlAtualizacao,
       tg.fundamentolegal  as cdControleLeiAto
from (select 1                 as idTipoAtualizacaoCredito,
             tpd.valorjuros    as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                 as iddebitoreceita,
             0                 as idCreditoContribuinteItem,
             0                 as idparcelamento,
             tp.datalancamento as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0 and
                       tpd.situacaolegal = 0 and tpd.valorpago > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.entidade = tp.entidade and
                                           tr.exercicio = tp.exerciciopagamento
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal = 0
        and not exists(
              select 1
              from tceAtualizaMonePagamento tamp
              where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
                and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          )
      union all
      select 2                 as idTipoAtualizacaoCredito,
             tpd.valormulta    as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                 as iddebitoreceita,
             0                 as idCreditoContribuinteItem,
             0                 as idparcelamento,
             tp.datalancamento as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0 and
                       tpd.situacaolegal = 0 and tpd.valorpago > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.entidade = tp.entidade and
                                           tr.exercicio = tp.exerciciopagamento
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal = 0
        and not exists(
              select 1
              from tceAtualizaMonePagamento tamp
              where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
                and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          )
      union all
      select 3                 as idTipoAtualizacaoCredito,
             tpd.valorcorrecao as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             0                 as iddebitoreceita,
             0                 as idCreditoContribuinteItem,
             0                 as idparcelamento,
             tp.datalancamento as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento
      from tribpagamento tp
               join tribpagamentobloqueto tpb
                    on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and
                       tpb.pagamento = tp.pagamento
               join tribpagamentodebito tpd
                    on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0 and
                       tpd.situacaolegal = 0 and tpd.valorpago > 0
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tribreceita tr on tr.receita = tdpr.receita and tr.entidade = tp.entidade and
                                           tr.exercicio = tp.exerciciopagamento
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal = 0
        and not exists(
              select 1
              from tceAtualizaMonePagamento tamp
              where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto
                and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
          )
      union all
      select 1               as idTipoAtualizacaoCredito,
             tcci.valorjuros as vlAtualizacao,
             0               as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             0               as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             0               as idparcelamento,
             tcc.data        as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr
                         on tr.entidade = tcc.entidade and tr.exercicio = tcc.exercicio and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorjuros > 0
        and tcci.valorprincipal > 0
        and tdp.situacaolegal = 0
        and not exists(
              select 1
              from tceatualizamonecredito tamc
              where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
          )
      union all
      select 2               as idTipoAtualizacaoCredito,
             tcci.valormulta as vlAtualizacao,
             0               as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             0               as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             0               as idparcelamento,
             tcc.data        as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr
                         on tr.entidade = tcc.entidade and tr.exercicio = tcc.exercicio and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valormulta > 0
        and tcci.valorprincipal > 0
        and tdp.situacaolegal = 0
        and not exists(
              select 1
              from tceatualizamonecredito tamc
              where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
          )
      union all
      select 3                  as idTipoAtualizacaoCredito,
             tcci.valorcorrecao as vlAtualizacao,
             0                  as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             0                  as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             0                  as idparcelamento,
             tcc.data           as dtAtualizacao,
             tlc.nrcredito,
             tlc.nranocredito,
             tdpr.guiarecolhimento
      from tribcreditocontribuinte tcc
               join tribcreditocontribuinteitem tcci
                    on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                       tcci.creditocontribuinte = tcc.creditocontribuinte
               join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
               left join tribreceita tr
                         on tr.entidade = tcc.entidade and tr.exercicio = tcc.exercicio and tr.receita = tdpr.receita
               join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
               left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
               left join tcelanccredito tlc on tlc.idtcelanccredito = tdlc.idtcelanccredito
               left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorcorrecao > 0
        and tcci.valorprincipal > 0
        and tdp.situacaolegal = 0
        and not exists(
              select 1
              from tceatualizamonecredito tamc
              where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
          )
      union all
      select distinct CASE
                          WHEN tr.classificacao = 'J' OR tr.classificacao = 'F'
                              THEN 1
                          WHEN tr.classificacao = 'M' THEN 2
                          ELSE 3
                          END                      AS idtipoatualizacaocredito,
                      acrescimo.valor              as vlAtualizacao,
                      0                            as idpagamentobloqueto,
                      0                            as iddebitoparcelareceita,
                      tdr.iddebitoreceita          as iddebitoreceita,
                      0                            as idcreditocontribuinteitem,
                      tp.idparcelamento,
                      tp.dataparcelamento          as dtAtualizacao,
                      filtro.nrcredito              as nrCredito,
                      filtro.nranocredito           as nrAnoCredito,
                      tdr.guiarecolhimento
      from tribparcelamento tp
               left outer join (select tpre.idparcelamentoreceitaespelho,
                                       tpre.idparcelamento,
                                       tpre.jurosdestino  as tributo,
                                       tpre.receitaorigem as tributoorigem,
                                       tpre.valorjuros    as valor,
                                       tpre.iddebitonovo,
                                       tpre.iddebito
                                from tribparcelamentoreceitaespelho tpre
                                where valorjuros > 0
                                union
                                select tpre.idparcelamentoreceitaespelho,
                                       tpre.idparcelamento,
                                       tpre.multadestino  as tributo,
                                       tpre.receitaorigem as tributoorigem,
                                       tpre.valormulta    as valor,
                                       tpre.iddebitonovo,
                                       tpre.iddebito
                                from tribparcelamentoreceitaespelho tpre
                                where valormulta > 0
                                union
                                select tpre.idparcelamentoreceitaespelho,
                                       tpre.idparcelamento,
                                       tpre.correcaodestino as tributo,
                                       tpre.receitaorigem   as tributoorigem,
                                       tpre.valorcorrecao   as valor,
                                       tpre.iddebitonovo,
                                       tpre.iddebito
                                from tribparcelamentoreceitaespelho tpre
                                where valorcorrecao > 0
                                union
                                select tpre.idparcelamentoreceitaespelho,
                                       tpre.idparcelamento,
                                       tpre.jurosfinandestino as tributo,
                                       tpre.receitaorigem     as tributoorigem,
                                       tpre.valorjurosfinan   as valor,
                                       tpre.iddebitonovo,
                                       tpre.iddebito
                                from tribparcelamentoreceitaespelho tpre
                                where valorjurosfinan > 0) acrescimo
                               on acrescimo.idparcelamento = tp.idparcelamento
               left join tribreceita tr
                         on tr.entidade = :entidade and
                            tr.exercicio = :exercicio and
                            tr.receita = acrescimo.tributo
               left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
               left join tribdebito td on acrescimo.iddebitonovo = td.iddebito
               left join tribdebito tdo on acrescimo.iddebito = tdo.iddebito
               left outer join tribdebitoreceita tdr
                               on tdo.entidade = tdr.entidade and
                                  tdo.exercicio = tdr.exercicio and
                                  tdo.tipocadastro = tdr.tipocadastro and
                                  tdo.cadastrogeral = tdr.cadastrogeral and
                                  tdo.guiarecolhimento =
                                  tdr.guiarecolhimento and
                                  tdo.subdivida = tdr.subdivida and
                                  acrescimo.tributoorigem = tdr.receita
               left join (select distinct tic.nrcredito,
                                          tic.nranocredito,
                                          tdp.situacaolegal,
                                          parcorigem.idparcelamento,
                                          tdpr.entidade,
                                          tdpr.exercicio,
                                          tdpr.tipocadastro,
                                          tdpr.cadastrogeral,
                                          tdpr.guiarecolhimento,
                                          tdpr.subdivida,
                                          trto.classificacaoreceitatipo
                          from tribdebitoparcelareceita tdpr
                                   join tribreceita tro
                                        on tro.entidade = :entidade
                                            and tro.exercicio = :exercicio
                                            and tro.receita = tdpr.receita
                                   join tribreceitatipo trto
                                        on trto.tiporeceita = tro.tiporeceita
                                   join tribparcelamentoparcrecorigem parcorigem
                                        on parcorigem.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                                   left join tcedebitolanccredito dda
                                             on dda.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                                   left join tcelanccredito tic
                                             on tic.idtcelanccredito = dda.idtcelanccredito
                                   join tribdebitoparcela tdp
                                        on tdp.entidade = tdpr.entidade
                                            and tdp.exercicio = tdpr.exercicio
                                            and tdp.tipocadastro = tdpr.tipocadastro
                                            and tdp.cadastrogeral = tdpr.cadastrogeral
                                            and tdp.guiarecolhimento = tdpr.guiarecolhimento
                                            and tdp.subdivida = tdpr.subdivida
                                            and tdp.parcela = tdpr.parcela) filtro
                         on filtro.entidade = tdo.entidade
                             and filtro.exercicio = tdo.exercicio
                             and filtro.tipocadastro = tdo.tipocadastro
                             and filtro.cadastrogeral = tdo.cadastrogeral
                             and filtro.guiarecolhimento = tdo.guiarecolhimento
                             and filtro.subdivida = tdo.subdivida
                             and filtro.classificacaoreceitatipo = trt.classificacaoreceitatipo
                             and filtro.idparcelamento = tp.idparcelamento
               left join tceatualizamoneparcrec tampcd
                         on tampcd.idparcelamento = tp.idparcelamento and
                            tampcd.iddebitoreceita = tdr.iddebitoreceita
                             and tampcd.tipoatualizacao = (CASE
                                                               WHEN tr.classificacao = 'J' OR tr.classificacao = 'F'
                                                                   THEN 1
                                                               WHEN tr.classificacao = 'M'
                                                                   THEN 2
                                                               ELSE 3
                                 END)
      where (tp.dataparcelamento between :dataInicial and :dataFinal)
        and trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and filtro.situacaolegal = 0
        and tampcd.idtceatualizamonecred is null) filtro
         left join tribguiarecolhimento     tg on tg.entidade = :entidade
    and tg.exercicio = :exercicio
    and tg.guiarecolhimento = filtro.guiarecolhimento
order by filtro.dtAtualizacao,
         filtro.nrcredito,
         filtro.nranocredito,
         filtro.idpagamentobloqueto,
         filtro.iddebitoparcelareceita,
         filtro.idTipoAtualizacaoCredito;