-- 1  UPDATE LANÇAMENTO DE CRÉDITO
UPDATE tcelanccredito  tlc
SET vllancamento = (
        SELECT COALESCE(SUM(COALESCE(tdlc.valor,0)),0)
        FROM  tcedebitolanccredito tdlc
        WHERE tdlc.idtcelanccredito = tlc.idtcelanccredito
     ) +
     (
        SELECT COALESCE(SUM(COALESCE(rc.valor,0)),0)
        FROM  tceretencaolanccredito rl
        join tceretencaocontabil rc
          on rl.idretencaocontabil = rc.idretencaocontabil
        WHERE rl.idtcelanccredito = tlc.idtcelanccredito
     )
WHERE tlc.dtlancamento BETWEEN :dataInicial AND :dataFinal;


-- 2  UPDATE ESTORNO LANÇAMENTO DE CRÉDITO
UPDATE tcelanccreditoest tlce
SET vlestorno = (
        SELECT COALESCE(SUM(COALESCE(tdlce.valor,0)),0)
        FROM tcedebitolanccreditoest tdlce
        WHERE tdlce.idtcelanccreditoest = tlce.idtcelanccreditoest
     )::NUMERIC(15,2)
WHERE tlce.dtestorno BETWEEN :dataInicial AND :dataFinal;


-- 3  UPDATE ATUALIZAÇÃO MONETÁRIA DE CRÉDITO
UPDATE tceatualizamonecred tamc
SET vlatualizacao = (
        ( SELECT COALESCE(SUM(COALESCE(amc.valor,0)),0) AS valor
          FROM tceatualizamonecredito amc
          WHERE amc.idtceatualizamonecred = tamc.idtceatualizamonecred)
        +
        ( SELECT COALESCE(SUM(COALESCE(ampg.valor,0)),0) AS valor
          FROM tceatualizamonepagamento ampg
          where ampg.idtceatualizamonecred = tamc.idtceatualizamonecred)
        +
        ( SELECT COALESCE(SUM(COALESCE(ampc.valor,0)),0) AS valor
          FROM TCEATUALIZAMONEPARCREC ampc
          WHERE ampc.idtceatualizamonecred = tamc.idtceatualizamonecred)
     )::NUMERIC(15,2)
WHERE tamc.dtatualizacao BETWEEN :dataInicial AND :dataFinal;


-- 4  UPDATE ESTORNO ATUALIZAÇÃO MONETÁRIA DE CRÉDITO
UPDATE tceatualizamonecredest tamce
SET vlestorno = (
         ( SELECT COALESCE(SUM(COALESCE(amce.valor,0)),0) AS valor
           FROM tceatualizamonecreditoest amce
           WHERE amce.idtceatualizamonecredest = tamce.idtceatualizamonecredest)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampge.valor,0)),0) AS valor
           FROM tceatualizamonepagamentoest ampge
           where ampge.idtceatualizamonecredest = tamce.idtceatualizamonecredest)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampce.valor,0)),0) AS valor
           FROM tceatualizamoneparcest ampce
           WHERE ampce.idtceatualizamonecredest = tamce.idtceatualizamonecredest)
     )::NUMERIC(15,2)
WHERE tamce.dtestorno BETWEEN :dataInicial AND :dataFinal;


-- 5  UPDATE DEDUÇÃO DE CRÉDITOS
UPDATE tcededucaocredito tdc
SET vldeducao = (
         ( SELECT COALESCE(SUM(COALESCE(dc.valor,0)),0) AS valor
           FROM tcededucaocancelamento dc
           WHERE dc.idtcededucaocredito = tdc.idtcededucaocredito)
         +
         ( SELECT COALESCE(SUM(COALESCE(dpg.valor,0)),0) AS valor
           FROM tcededucaopagamento dpg
           where dpg.idtcededucaocredito = tdc.idtcededucaocredito)
         +
         ( SELECT COALESCE(SUM(COALESCE(di.valor,0)),0) AS valor
           FROM tcededucaoisencao di
           WHERE di.idtcededucaocredito = tdc.idtcededucaocredito)
         +
         (SELECT COALESCE(SUM(COALESCE(dcc.valor, 0)), 0) AS valor
          FROM tcededucaocreditocredito dcc
          WHERE dcc.idtcededucaocredito = tdc.idtcededucaocredito)
         +
         ( SELECT COALESCE(SUM(COALESCE(dpc.valor,0)),0) AS valor
           FROM tceDeducaoParcelamento dpc
           WHERE dpc.idtcededucaocredito = tdc.idtcededucaocredito)
     )::NUMERIC(15,2)
WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal;


-- 6  UPDATE ESTORNO DEDUÇÃO DE CRÉDITOS
 UPDATE tcededucaocreditoest tdce
 SET vlestorno = (
         ( SELECT COALESCE(SUM(COALESCE(dce.valor,0)),0) AS valor
           FROM tcededucaocancelamentoest dce
           WHERE dce.idtcededucaocreditoest = tdce.idtcededucaocreditoest)
         +
         ( SELECT COALESCE(SUM(COALESCE(dpge.valor,0)),0) AS valor
           FROM tcededucaopagamentoest dpge
           where dpge.idtcededucaocreditoest = tdce.idtcededucaocreditoest)
         +
         (SELECT COALESCE(SUM(COALESCE(dcce.valor, 0)), 0) AS valor
          FROM tcededucaocreditocreditoest dcce
          WHERE dcce.idtcededucaocreditoest = tdce.idtcededucaocreditoest
         )/*+
         ( SELECT COALESCE(SUM(COALESCE(dpc.valor,0)),0) AS valor
           FROM tceDeducaoParcelamentoest dpc
           WHERE dpc.idtcededucaocreditoest = tdce.idtcededucaocreditoest)*/
     )::NUMERIC(15,2)
 WHERE tdce.dtestorno BETWEEN :dataInicial AND :dataFinal;


-- 7  UPDATE INSCRIÇÃO DE CRÉDITOS E DÍVIDA ATIVA
UPDATE tceinsccreditoda  ticda
SET vlinscricao = (
        SELECT COALESCE(SUM(COALESCE(tdicda.valor,0)),0)
        FROM  tcedebitoinsccreditoda tdicda
        WHERE tdicda.idtceinsccreditoda = ticda.idtceinsccreditoda
     )::NUMERIC(15,2)
WHERE ticda.dtinscricao BETWEEN :dataInicial AND :dataFinal;


-- 8  UPDATE ESTORNO DA INSCRIÇÃO DE CRÉDITOS EM DÍVIDA ATIVA
UPDATE tceinsccreditodaest  ticdae
SET vlestorno = (
        SELECT COALESCE(SUM(COALESCE(tdicdae.valor,0)),0)
        FROM  tcedebitoinsccreditodaest tdicdae
        WHERE tdicdae.idtceinsccreditodaest = ticdae.idtceinsccreditodaest
     )::NUMERIC(15,2)
WHERE ticdae.dtestorno BETWEEN :dataInicial AND :dataFinal;


-- 9  UPDATE ATUALIZAÇÃO MONETÁRIA DE CRÉDITOS EM DÍVIDA ATIVA
 UPDATE tceatualizamonecredda tamceda
 SET vlatualizacao = (
         ( SELECT COALESCE(SUM(COALESCE(amc.valor,0)),0) AS valor
           FROM  tceatualizamonecreditoda amc
           WHERE amc.idtceatualizamonecredda = tamceda.idtceatualizamonecredda)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampg.valor,0)),0) AS valor
           FROM tceatualizamonepagamentoda ampg
           where ampg.idtceatualizamonecredda = tamceda.idtceatualizamonecredda)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampc.valor,0)),0) AS valor
           FROM tceatualizamoneparcrecda ampc
           WHERE ampc.idtceatualizamonecredda = tamceda.idtceatualizamonecredda)
      )::NUMERIC(15,2)
 WHERE tamceda.dtatualizacao BETWEEN :dataInicial AND :dataFinal;


-- 10  UPDATE ESTORNO ATUALIZAÇÃO MONETÁRIA DE CREDITOS EM DÍVIDA ATIVA
 UPDATE tceatualizamonecreddaest tamce
 SET vlestorno = (
         (SELECT COALESCE(SUM(COALESCE(amce.valor,0)),0) AS valor
          FROM tceatualizamonecreditodaest amce
          WHERE amce.idtceatualizamonecreddaest = tamce.idtceatualizamonecreddaest)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampge.valor,0)),0) AS valor
           FROM tceatualizamonepagamentodaest ampge
           where ampge.idtceatualizamonecreddaest = tamce.idtceatualizamonecreddaest)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampce.valor,0)),0) AS valor
           FROM tceatualizamoneparcdaest ampce
           WHERE ampce.idtceatualizamonecreddaest = tamce.idtceatualizamonecreddaest)
         +
         ( SELECT COALESCE(SUM(COALESCE(ampce.valor,0)),0) AS valor
           FROM tceatualizamoneparcdarecest ampce
           WHERE ampce.idtceatualizamonecreddaest = tamce.idtceatualizamonecreddaest)
      )::NUMERIC(15,2)
 WHERE tamce.dtestorno BETWEEN :dataInicial AND :dataFinal;


-- 11  UPDATE DEDUÇÃO DOS CRÉDITOS EM DÍVIDA ATIVA
 UPDATE tcededucaocreditoda tdc
 SET vldeducao = (
         ( SELECT COALESCE(SUM(COALESCE(dc.valor,0)),0) AS valor
           FROM tcededucaocancelamentoda dc
           WHERE dc.idtcededucaocreditoda = tdc.idtcededucaocreditoda)
         +
         ( SELECT COALESCE(SUM(COALESCE(dpg.valor,0)),0) AS valor
           FROM tcededucaopagamentoda dpg
           where dpg.idtcededucaocreditoda = tdc.idtcededucaocreditoda)
         +
         (SELECT COALESCE(SUM(COALESCE(dcc.valor, 0)), 0) AS valor
          FROM tcededucaocreditocreditoda dcc
          WHERE dcc.idtcededucaocreditoda = tdc.idtcededucaocreditoda)
         +
         ( SELECT COALESCE(SUM(COALESCE(dpc.valor,0)),0) AS valor
           FROM tceDeducaoParcelamentoda dpc
           WHERE dpc.idtcededucaocreditoda = tdc.idtcededucaocreditoda)
      )::NUMERIC(15,2)
 WHERE tdc.dtdeducao BETWEEN :dataInicial AND :dataFinal;


-- 12  UPDATE ESTORNO DE DEDUÇÃO DE CRÉDITOS EM DÍVIDA ATIVA
 UPDATE tcededucaocreditodaest tdc
 SET vlestorno = (
         ( SELECT COALESCE(SUM(COALESCE(dc.valor,0)),0) AS valor
           FROM tcededucaocancelamentodaest dc
           WHERE dc.idtcededucaocreditodaest = tdc.idtcededucaocreditodaest)
         +
         ( SELECT COALESCE(SUM(COALESCE(dpg.valor,0)),0) AS valor
           FROM tcededucaopagamentodaest dpg
           where dpg.idtcededucaocreditodaest = tdc.idtcededucaocreditodaest)
         +
         ( SELECT COALESCE(SUM(COALESCE(dcc.valor, 0)), 0) AS valor
           FROM tcededucaocreditocreditodaest dcc
           WHERE dcc.idtcededucaocreditodaest = tdc.idtcededucaocreditodaest)
        +
         ( SELECT COALESCE(SUM(COALESCE(dpc.valor,0)),0) AS valor
           FROM tcededucaoparcelamentodaest dpc
           WHERE dpc.idtcededucaocreditodaest = tdc.idtcededucaocreditodaest)
      )::NUMERIC(15,2)
 WHERE tdc.dtestorno BETWEEN :dataInicial AND :dataFinal;


-- 13  UPDATE ARRECADAÇÃO POR TIPO DE CRÉDITO
UPDATE tcearrecadacaotipocredito tatc
SET vlarrecadacao = (
        (SELECT COALESCE(SUM(COALESCE(tacp.valor, 0)), 0) AS valor
         FROM tceArrTipoCreditoPagamento tacp
         WHERE tacp.idtcearrtipocredito = tatc.idtcearrtipocredito) +
        (SELECT COALESCE(SUM(COALESCE(tacc.valor, 0)), 0) AS valor
         FROM tceArrTipoCreditoCredito tacc
         where tacc.idtcearrtipocredito = tatc.idtcearrtipocredito)  +
        (SELECT COALESCE(SUM(COALESCE(trc.valor, 0)), 0) AS valor
         FROM tcearrtipocreditoretencao tar
         join tceretencaocontabil trc
           on tar.idretencaocontabil = trc.idretencaocontabil
         where tar.idtcearrtipocredito = tatc.idtcearrtipocredito)
    )::NUMERIC(15, 2)
WHERE tatc.nrmes = extract(month from (:dataInicial)::date)
  and tatc.nrano = extract(year from (:dataInicial)::date);


-- 14  UPDATE ESTORNO DE ARRECADAÇÃO POR TIPO DE CRÉDITO
UPDATE tcearrecadacaotipocreditoest tatc
SET vlestorno = (
        (SELECT COALESCE(SUM(COALESCE(tacp.valor, 0)), 0) AS valor
         FROM tcearrtipocreditopagamentoest tacp
         WHERE tacp.idtcearrtipocreditoest = tatc.idtcearrtipocreditoest)
        +
        (SELECT COALESCE(SUM(COALESCE(tacc.valor, 0)), 0) AS valor
         FROM tcearrtipocreditocreditoest tacc
         where tacc.idtcearrtipocreditoest = tatc.idtcearrtipocreditoest)
    )::NUMERIC(15, 2)
WHERE tatc.nrmes = extract(month from (:dataInicial)::date)
  and tatc.nrano = extract(year from (:dataInicial)::date);