select tp.entidade,
       tep.datareabilitacao    as datamovimentacao,
       tr.receita              as tributo,
       tr.descricao            as descricaotributo,
       tr.tiporeceita          as tipoTributo,
       desconto.classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.datareabilitacao )
         then tdp.situacaolegal
         else 0
       end                     situacaolegal,
       ttot.codigotce          as tipooperacaodeducao,
       'DESCONTO_PARCELAMENTO' as tipomovimento,
       td.iddebito,
       sum(desconto.valor)     as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join tribmotivodesconto tmd
                    on tpp.motivodesconto = tmd.motivodesconto
       left outer join tribtipooperacaotce ttot
                    on tmd.idtipooperacaotce = ttot.idtipooperacaotce
       left outer join (select tepre.idestornoparcelamento,
                               tepre.idparcelamentoreceitaespelho,
                               tepre.valordescontoprincipalestorno  as valor,
                               'P'                                 as classificacaotributo
                        from   tribestornoparcreceitaespelho tepre
                        where  valordescontoprincipalestorno > 0
                        union
                        select tepre.idestornoparcelamento,
                               tepre.idparcelamentoreceitaespelho,
                               tepre.valordescontojurosestorno  as valor,
                               'J'                              as classificacaotributo
                        from   tribestornoparcreceitaespelho tepre
                        where  valordescontojurosestorno > 0
                        union
                        select tepre.idestornoparcelamento,
                               tepre.idparcelamentoreceitaespelho,
                               tepre.valordescontomultaestorno as valor,
                               'M'                     as classificacaotributo
                        from   tribestornoparcreceitaespelho tepre
                        where  valordescontomultaestorno > 0
                        union
                        select tepre.idestornoparcelamento,
                               tepre.idparcelamentoreceitaespelho,
                               tepre.valordescontocorrecaoestorno as valor,
                               'C'                        as classificacaotributo
                        from   tribestornoparcreceitaespelho tepre
                        where  valordescontocorrecaoestorno > 0) desconto
                    on desconto.idestornoparcelamento = tep.idestornoparcelamento
       left outer join tribparcelamentoreceitaespelho tpre
                    on tpre.idparcelamentoreceitaespelho = desconto.idparcelamentoreceitaespelho
       left outer join tribdebito td
                    on td.iddebito = tpre.iddebitonovo
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and tpre.receitaorigem = tr.receita
where  td.constituido = 'S'
  and  tep.datareabilitacao in (:datasMovimento)
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem < tepd.iddebitodestino)
  and tep.dataestorno <> tep.datareabilitacao
group  by tp.entidade,
          tep.datareabilitacao,
          tr.receita,
          tr.descricao,
          desconto.classificacaotributo,
          case
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.datareabilitacao )
            then tdp.situacaolegal
            else 0
          END,
          ttot.codigotce,
          td.iddebito,
          tr.tiporeceita