/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.PixPagoService;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class IntegracaoPixPagoContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoPixPagoContext.class);
    private final List<PixPagoService> services;
    private final ConvenioService convenioService;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;

    public IntegracaoPixPagoContext(List<PixPagoService> services, ConvenioService convenioService, PlatformTransactionManager transactionManager, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository) {
        this.services = services;
        this.convenioService = convenioService;
        this.transactionManager = transactionManager;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
    }

    public ImportacaoPixPagoResultadoDTO importar(ImportacaoPixPagoDTO params) {
        Convenio convenio = (Convenio)this.convenioService.findById((Serializable)params.getConvenio()).orElseThrow(() -> new EloValidationException(String.format("Conv\u00eanio %d n\u00e3o encontrado.", params.getConvenio())));
        PixPagoService service = this.services.stream().filter(s -> s.accept(convenio)).findFirst().orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o para buscar pix pagos para o conv\u00eanio %d n\u00e3o implementada.", params.getConvenio())));
        return service.importarPixPago(convenio, params.getDataReferencia());
    }

    public List<BaixaAutomaticaDetalhe> processarPixPagosWebHook(JsonNode pixPagos, Long idConvenio) {
        Optional convenio = this.convenioService.findById((Serializable)idConvenio);
        IntegracaoPixPagoLog log = this.buildLog(idConvenio, LocalDate.now());
        if (convenio.isEmpty()) {
            log.setErro(String.format("Conv\u00eanio com id %d n\u00e3o encontrado", idConvenio));
            this.saveLog(log);
            throw new EloValidationException(String.format("Conv\u00eanio com id %d n\u00e3o encontrado", idConvenio));
        }
        PixPagoService service = this.services.stream().filter(s -> s.accept((Convenio)convenio.get())).findFirst().orElseThrow(() -> new EloValidationException(String.format("Integra\u00e7\u00e3o para receber pix pagos para o conv\u00eanio %d n\u00e3o implementada.", ((Convenio)convenio.get()).getId())));
        return service.processarPixPagosWebHook(pixPagos, (Convenio)convenio.get(), log);
    }

    private IntegracaoPixPagoLog buildLog(Long idConvenio, LocalDate dataReferencia) {
        IntegracaoPixPagoLog log = new IntegracaoPixPagoLog();
        log.setConvenio(idConvenio);
        log.setDataIntegracao(LocalDateTime.now());
        log.setDataReferencia(dataReferencia);
        log.setUsuario(SecurityUtils.getUserName());
        return log;
    }

    private IntegracaoPixPagoLog saveLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        return (IntegracaoPixPagoLog)new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public void togglePixBoletoPagoWebhook(Long idConvenio) {
        Convenio convenio = (Convenio)this.convenioService.findById((Serializable)idConvenio).orElseThrow(() -> new EloValidationException("Convenio n\u00e3o encontrado."));
        this.validaSeUsaPixOuNao(convenio);
        this.getPixPagoService(convenio).togglePixBoletoPagoWebhook(convenio);
        convenio.setWebhookPixAtivo(Boolean.valueOf(convenio.getWebhookPixAtivo() == false));
        this.convenioService.save((EloEntity)convenio, null);
    }

    private void validaSeUsaPixOuNao(Convenio convenio) {
        if (Boolean.FALSE.equals(convenio.getUtilizaPix())) {
            throw new EloValidationException("Conv\u00eanio n\u00e3o parametrizado para utilizar PIX. Por favor, salvar o registro antes.");
        }
    }

    private PixPagoService getPixPagoService(Convenio convenio) {
        return this.services.stream().filter(s -> s.accept(convenio)).findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi implementado Webhook para o banco %s.", convenio.getBanco().getDescricao())));
    }
}

