/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bradesco;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bradesco.EmissaoBoletoBradescoDTO;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.FormaPagamentoRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.dentrassi.crypto.pem.PemKeyStoreProvider;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoBradescoService
implements IntegracaoBoletoRegistrado {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoBradescoService.class);
    private static final String STATUS_SUCESSO = "0";
    private final RestTemplate restTemplate;
    private final ParametroGeralService parametroGeralService;
    private final ObjectMapper mapper;
    private final ParametroPixRepository parametroPixRepository;
    private final EntidadeService entidadeService;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final BancoRepository bancoRepository;
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final FormaPagamentoRepository formaPagamentoRepository;
    private final EntidadeRepository entidadeRepository;
    private String request = null;
    private static Map<String, String> converterValues = new HashMap();

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_BRADESCO)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o Bradesco!"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        CodigoBarrasDTO codigoBarrasDTO;
        String stackTraceIntegracao = null;
        JsonNode responseFinal = null;
        ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
        byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoBradesco).orElse(null);
        String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoBradesco).orElse(null);
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)boleto.getEntidade());
        try {
            EmissaoBoletoBradescoDTO dto = EmissaoBoletoBradescoDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240, (Entidade)entidade);
            KeyStore keyStore = this.loadKeystore(certificado, senhaCertificado);
            CMSSignedDataGenerator signatureGenerator = this.setUpSigner(keyStore, senhaCertificado);
            log.debug("JSON  Boleto registrado Bradesco  ID - {} {}", (Object)boleto.getId(), (Object)this.mapper.writeValueAsString((Object)dto));
            byte[] signedBytes = this.signPkcs7(this.mapper.writeValueAsBytes((Object)dto), signatureGenerator);
            String signedbase64 = new String(Base64.getEncoder().encode(signedBytes));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)signedbase64, (MultiValueMap)headers);
            this.request = String.format("POST TO %s: %s", this.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_URLAPI), this.mapper.writeValueAsString((Object)requestEntity));
            JsonNode response = (JsonNode)this.restTemplate.exchange(this.getParametro(ParametroGeralEnum.BOLETO_BRADESCO_URLAPI), HttpMethod.POST, requestEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("Body") || !response.get("Body").has("registrarTituloResponse") || !response.get("Body").get("registrarTituloResponse").has("return")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "Erro de comunica\u00e7\u00e3o com o Bradesco");
            }
            responseFinal = (JsonNode)this.mapper.readValue(response.get("Body").get("registrarTituloResponse").get("return").asText(), JsonNode.class);
            if (!STATUS_SUCESSO.equals(responseFinal.get("cdErro").asText())) {
                throw new RestException(HttpStatus.BAD_REQUEST, responseFinal.toString());
            }
            CodigoBarrasDTO codigoBarrasDTO2 = new CodigoBarrasDTO();
            String linhaDigitavel = StringUtils.deleteWhitespace((String)responseFinal.get("linhaDigitavel").asText().replace(".", ""));
            String codBarrasNumerico = this.converteCodigoBarrasBradesco(responseFinal.get("cdBarras").asText());
            codigoBarrasDTO2.setCodigoBarras(StringUtils.left((String)codBarrasNumerico, (int)100));
            codigoBarrasDTO2.setLinhaDigitavel(linhaDigitavel);
            codigoBarrasDTO2.setCampo1(StringUtils.substring((String)linhaDigitavel, (int)0, (int)10));
            codigoBarrasDTO2.setCampo2(StringUtils.substring((String)linhaDigitavel, (int)10, (int)21));
            codigoBarrasDTO2.setCampo3(StringUtils.substring((String)linhaDigitavel, (int)21, (int)32));
            codigoBarrasDTO2.setCampo4(StringUtils.substring((String)linhaDigitavel, (int)32, (int)33));
            codigoBarrasDTO2.setCampo5(StringUtils.substring((String)linhaDigitavel, (int)33, (int)47));
            codigoBarrasDTO2.setNossoNumero(boleto.getNossoNumero());
            codigoBarrasDTO2.setDvNossoNumero(boleto.getDvNossoNumero());
            codigoBarrasDTO2.generateCodigoBarrasFormatadoIntervalo2Of5();
            codigoBarrasDTO = codigoBarrasDTO2;
        }
        catch (RestException e) {
            try {
                JsonNode responseError = this.converterErroResposta(e.getMessage());
                String mensagem = e.getMessage();
                String codigo = null;
                if (Objects.nonNull(responseError) && responseError.has("msgErro") && StringUtils.isNotEmpty((String)responseError.get("msgErro").asText())) {
                    mensagem = responseError.get("msgErro").asText();
                    codigo = responseError.get("cdErro").asText();
                }
                stackTraceIntegracao = ExceptionUtils.getStackTrace((Throwable)e);
                throw new BoletoException("Erro ao enviar o boleto registrado para o Bradesco: " + codigo + " - " + mensagem);
                catch (ParametroNaoEncontradoException e2) {
                    stackTraceIntegracao = ExceptionUtils.getStackTrace((Throwable)e2);
                    throw e2;
                }
                catch (Exception e3) {
                    stackTraceIntegracao = ExceptionUtils.getStackTrace((Throwable)e3);
                    throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.saveErroBoletoOnline(boleto, stackTraceIntegracao, responseFinal);
                throw throwable;
            }
        }
        this.saveErroBoletoOnline(boleto, stackTraceIntegracao, responseFinal);
        return codigoBarrasDTO;
    }

    private void saveErroBoletoOnline(Bloqueto boleto, String stackTrace, JsonNode response) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            ErroBoletoRegistroOnline erroBoletoRegistroOnline = new ErroBoletoRegistroOnline();
            erroBoletoRegistroOnline.setRequest((byte[])Optional.ofNullable(this.request).map(String::getBytes).orElse(null));
            erroBoletoRegistroOnline.setResponse((byte[])Optional.ofNullable(response).map(JsonNode::toString).map(String::getBytes).orElse(null));
            erroBoletoRegistroOnline.setDataHoraIntegracao(LocalDateTime.now());
            erroBoletoRegistroOnline.setIdBoleto(boleto.getId());
            erroBoletoRegistroOnline.setDetalhes(stackTrace);
            return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroBoletoRegistroOnline);
        });
    }

    private JsonNode converterErroResposta(String json) {
        try {
            return (JsonNode)this.mapper.readValue(json, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            ObjectNode jsonNodes = JsonNodeFactory.instance.objectNode();
            jsonNodes.put("msgErro", "Erro ao converter a exce\u00e7\u00e3o no objeto da integra\u00e7\u00e3o do boleto bradesco.");
            jsonNodes.put("cdErro", "");
            return jsonNodes;
        }
    }

    private byte[] signPkcs7(byte[] content, CMSSignedDataGenerator generator) throws Exception {
        CMSProcessableByteArray cmsdata = new CMSProcessableByteArray(content);
        CMSSignedData signedData = generator.generate((CMSTypedData)cmsdata, true);
        return signedData.getEncoded();
    }

    private KeyStore loadKeystore(byte[] certificado, String senha) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PEM", (Provider)new PemKeyStoreProvider());
        ByteArrayInputStream is = new ByteArrayInputStream(certificado);
        keyStore.load(is, senha.toCharArray());
        return keyStore;
    }

    private CMSSignedDataGenerator setUpSigner(KeyStore keystore, String senhaCertificado) throws Exception {
        int length;
        Security.addProvider((Provider)new BouncyCastleProvider());
        String SIGNATUREALGO = "Sha256WithRSA";
        Enumeration<String> aliases = keystore.aliases();
        String aliaz = "";
        while (aliases.hasMoreElements() && !keystore.isKeyEntry(aliaz = aliases.nextElement())) {
        }
        Certificate[] certChain = keystore.getCertificateChain(aliaz);
        ArrayList<Certificate> certList = new ArrayList<Certificate>();
        int n = length = certChain == null ? 0 : certChain.length;
        for (int i = 0; i < length; ++i) {
            certList.add(certChain[i]);
        }
        JcaCertStore certstore = new JcaCertStore(certList);
        Certificate cert = keystore.getCertificate(aliaz);
        ContentSigner signer = new JcaContentSignerBuilder("Sha256WithRSA").setProvider("BC").build((PrivateKey)keystore.getKey(aliaz, senhaCertificado.toCharArray()));
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(signer, (X509Certificate)cert));
        generator.addCertificates((Store)certstore);
        return generator;
    }

    private String getParametro(ParametroGeralEnum parametro) {
        String paramValueAsString = this.parametroGeralService.getParamValueAsString(parametro, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (StringUtils.isEmpty((String)paramValueAsString)) {
            throw new ParametroNaoEncontradoException(parametro.getDescricao());
        }
        return paramValueAsString;
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_BRADESCO_CNAB240_COM_REGISTRO;
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (Objects.isNull(boleto.getExercicioBloqueto())) {
            throw new EloValidationException("\u00c9 necess\u00e1rio o exerc\u00edcio do bloqueto para gerar o nosso n\u00famero.");
        }
        String nossoNumero = this.gerarNossoNumero(boleto);
        String dv = this.gerarDVNossoNumero(boleto.getModeloBloqueto().getConvenio().getCarteira(), nossoNumero);
        boleto.setNossoNumero(nossoNumero + dv);
        boleto.setDvNossoNumero(dv);
    }

    private String gerarNossoNumero(Bloqueto boleto) {
        Long idBoleto = Optional.ofNullable(boleto.getId()).orElseThrow(() -> new EloValidationException("Boleto n\u00e3o encontrado"));
        Long exercicioBoleto = Optional.ofNullable(boleto.getExercicioBloqueto()).orElseThrow(() -> new EloValidationException("Exercicio do Boleto n\u00e3o encontrado"));
        String anoIdentificador = exercicioBoleto.toString().substring(2, 4).concat(StringUtils.leftPad((String)idBoleto.toString(), (int)8, (String)STATUS_SUCESSO));
        return boleto.getEntidade().toString().concat(anoIdentificador);
    }

    private String gerarDVNossoNumero(String carteira, String nossoNumero) {
        String result;
        String vsNossoNumero = StringUtils.leftPad((String)carteira, (int)2, (String)STATUS_SUCESSO).concat(nossoNumero);
        Integer valorMultiplicador = 2;
        Integer viSoma = 0;
        for (int i = 0; i < vsNossoNumero.length(); ++i) {
            viSoma = viSoma + Character.getNumericValue(vsNossoNumero.charAt(i)) * valorMultiplicador;
            if (valorMultiplicador.equals(2)) {
                valorMultiplicador = 7;
                continue;
            }
            Integer n = valorMultiplicador;
            Integer n2 = valorMultiplicador = Integer.valueOf(valorMultiplicador - 1);
        }
        Integer viResto = viSoma % 11;
        switch (viResto) {
            case 0: {
                result = STATUS_SUCESSO;
                break;
            }
            case 1: {
                result = "P";
                break;
            }
            default: {
                result = String.valueOf(11 - viResto);
            }
        }
        return result;
    }

    private String converteCodigoBarrasBradesco(String codigo) {
        String codigoFormat = codigo.replaceAll("[<>]*", "");
        return Stream.of(codigoFormat.split("(?<=\\G.{5})")).map(slice -> {
            String valor = (String)converterValues.get(slice);
            if (Objects.isNull(valor)) {
                throw new EloValidationException(String.format("O campo '%s' n\u00e3o p\u00f4de ser convertido para c\u00f3digo de barras, valor equivalente n\u00e3o encontrado", slice));
            }
            return valor;
        }).collect(Collectors.joining());
    }

    @Generated
    public IntegracaoBoletoBradescoService(RestTemplate restTemplate, ParametroGeralService parametroGeralService, ObjectMapper mapper, ParametroPixRepository parametroPixRepository, EntidadeService entidadeService, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ParametroCNAB240Repository parametroCNAB240Repository, BancoRepository bancoRepository, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, FormaPagamentoRepository formaPagamentoRepository, EntidadeRepository entidadeRepository) {
        this.restTemplate = restTemplate;
        this.parametroGeralService = parametroGeralService;
        this.mapper = mapper;
        this.parametroPixRepository = parametroPixRepository;
        this.entidadeService = entidadeService;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.bancoRepository = bancoRepository;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.formaPagamentoRepository = formaPagamentoRepository;
        this.entidadeRepository = entidadeRepository;
    }

    static {
        converterValues.put("nnWWn", "00");
        converterValues.put("NnwwN", "01");
        converterValues.put("nNwwN", "02");
        converterValues.put("NNwwn", "03");
        converterValues.put("nnWwN", "04");
        converterValues.put("NnWwn", "05");
        converterValues.put("nNWwn", "06");
        converterValues.put("nnwWN", "07");
        converterValues.put("NnwWn", "08");
        converterValues.put("nNwWn", "09");
        converterValues.put("wnNNw", "10");
        converterValues.put("WnnnW", "11");
        converterValues.put("wNnnW", "12");
        converterValues.put("WNnnw", "13");
        converterValues.put("wnNnW", "14");
        converterValues.put("WnNnw", "15");
        converterValues.put("wNNnw", "16");
        converterValues.put("wnnNW", "17");
        converterValues.put("WnnNw", "18");
        converterValues.put("wNnNw", "19");
        converterValues.put("nwNNw", "20");
        converterValues.put("NwnnW", "21");
        converterValues.put("nWnnW", "22");
        converterValues.put("NWnnw", "23");
        converterValues.put("nwNnW", "24");
        converterValues.put("NwNnw", "25");
        converterValues.put("nWNnw", "26");
        converterValues.put("nwnNW", "27");
        converterValues.put("NwnNw", "28");
        converterValues.put("nWnNw", "29");
        converterValues.put("wwNNn", "30");
        converterValues.put("WwnnN", "31");
        converterValues.put("wWnnN", "32");
        converterValues.put("WWnnn", "33");
        converterValues.put("wwNnN", "34");
        converterValues.put("WwNnn", "35");
        converterValues.put("wWNnn", "36");
        converterValues.put("wwnNN", "37");
        converterValues.put("WwnNn", "38");
        converterValues.put("wWnNn", "39");
        converterValues.put("nnWNw", "40");
        converterValues.put("NnwnW", "41");
        converterValues.put("nNwnW", "42");
        converterValues.put("NNwnw", "43");
        converterValues.put("nnWnW", "44");
        converterValues.put("NnWnw", "45");
        converterValues.put("nNWnw", "46");
        converterValues.put("nnwNW", "47");
        converterValues.put("NnwNw", "48");
        converterValues.put("nNwNw", "49");
        converterValues.put("wnWNn", "50");
        converterValues.put("WnwnN", "51");
        converterValues.put("wNwnN", "52");
        converterValues.put("WNwnn", "53");
        converterValues.put("wnWnN", "54");
        converterValues.put("WnWnn", "55");
        converterValues.put("wNWnn", "56");
        converterValues.put("wnwNN", "57");
        converterValues.put("WnwNn", "58");
        converterValues.put("wNwNn", "59");
        converterValues.put("nwWNn", "60");
        converterValues.put("NwwnN", "61");
        converterValues.put("nWwnN", "62");
        converterValues.put("NWwnn", "63");
        converterValues.put("nwWnN", "64");
        converterValues.put("NwWnn", "65");
        converterValues.put("nWWnn", "66");
        converterValues.put("nwwNN", "67");
        converterValues.put("NwwNn", "68");
        converterValues.put("nWwNn", "69");
        converterValues.put("nnNWw", "70");
        converterValues.put("NnnwW", "71");
        converterValues.put("nNnwW", "72");
        converterValues.put("NNnww", "73");
        converterValues.put("nnNwW", "74");
        converterValues.put("NnNww", "75");
        converterValues.put("nNNww", "76");
        converterValues.put("nnnWW", "77");
        converterValues.put("NnnWw", "78");
        converterValues.put("nNnWw", "79");
        converterValues.put("wnNWn", "80");
        converterValues.put("WnnwN", "81");
        converterValues.put("wNnwN", "82");
        converterValues.put("WNnwn", "83");
        converterValues.put("wnNwN", "84");
        converterValues.put("WnNwn", "85");
        converterValues.put("wNNwn", "86");
        converterValues.put("wnnWN", "87");
        converterValues.put("WnnWn", "88");
        converterValues.put("wNnWn", "89");
        converterValues.put("nwNWn", "90");
        converterValues.put("NwnwN", "91");
        converterValues.put("nWnwN", "92");
        converterValues.put("NWnwn", "93");
        converterValues.put("nwNwN", "94");
        converterValues.put("NwNwn", "95");
        converterValues.put("nWNwn", "96");
        converterValues.put("nwnWN", "97");
        converterValues.put("NwnWn", "98");
        converterValues.put("nWnWn", "99");
        converterValues.put("WWWWW", "99");
    }
}

