/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.AgrupamentoTributosDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.stereotype.Service;

@Service
public class PagamentoNegociadoRateioService {
    public DebitoPagamentoNegociadoDTO criaDebitoAbatido(DebitoPagamentoNegociadoDTO debito) {
        DebitoPagamentoNegociadoDTO debitoAbatido = this.criaDebitoComTributoProporcionalCalculado(debito, debito.getValorAbatido());
        this.validarRateio(debito.getValorAbatido(), debitoAbatido.getTotalNovoDebito(), "Erro no rateio do d\u00e9bito abatido");
        return debitoAbatido;
    }

    public DebitoPagamentoNegociadoDTO criaDebitoRestante(DebitoPagamentoNegociadoDTO debito) {
        DebitoPagamentoNegociadoDTO debitoRestante = this.criaDebitoComTributoProporcionalCalculado(debito, debito.getValorRestante());
        this.validarRateio(debito.getValorRestante(), debitoRestante.getTotalNovoDebito(), "Erro no rateio do d\u00e9bito restante");
        return debitoRestante;
    }

    private DebitoPagamentoNegociadoDTO criaDebitoComTributoProporcionalCalculado(DebitoPagamentoNegociadoDTO debitoATratar, BigDecimal valorADividir) {
        DebitoPagamentoNegociadoDTO tributoAgrupadoRecalculado = debitoATratar.clone();
        AtomicReference<BigDecimal> valorRateado = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (tributoAgrupadoRecalculado.getTributosAgrupados().isEmpty()) {
            valorRateado.set(valorADividir);
            tributoAgrupadoRecalculado.setValorNovoDebito(valorADividir);
        } else {
            tributoAgrupadoRecalculado.getTributosAgrupados().forEach(tributo -> {
                BigDecimal valorNovoDebito = tributo.getValorPrincipal().multiply(valorADividir).divide(debitoATratar.getValorPrincipal(), 2, RoundingMode.HALF_EVEN);
                valorRateado.set(((BigDecimal)valorRateado.get()).add(valorNovoDebito));
                tributo.setValorNovoDebito(valorNovoDebito);
            });
            BigDecimal diferencaRateio = valorADividir.subtract(valorRateado.get());
            if (diferencaRateio.compareTo(BigDecimal.ZERO) != 0) {
                tributoAgrupadoRecalculado.getTributosAgrupados().stream().max(Comparator.comparing(AgrupamentoTributosDTO::getValorNovoDebito)).ifPresent(tributo -> tributo.setValorNovoDebito(tributo.getValorNovoDebito().add(diferencaRateio)));
            }
        }
        return tributoAgrupadoRecalculado;
    }

    private void validarRateio(BigDecimal valorReferencia, BigDecimal valorRateado, String mensagem) {
        if (valorReferencia.compareTo(valorRateado) != 0) {
            throw new EloValidationException(String.format("%s. Esperava %s e dividiu %s", mensagem, valorReferencia, valorRateado));
        }
    }
}

