/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroExistenteSequenciadoresDTO;
import br.com.elotech.tributos.dto.dividaativa.TotalizadorLivroDTO;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaEnglobadoService;
import br.com.elotech.tributos.service.LivroService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Service;

@Service
public class GeraLivroDividaAtivaBatchService {
    private final LivroService livroService;
    private final GeraLivroRepository geraLivroRepository;
    private final EntityManager entityManager;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final GeraLivroDividaAtivaEnglobadoService geraLivroDividaAtivaEnglobadoService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DividaService dividaService;

    public GeraLivroDividaAtivaBatchService(LivroService livroService, GeraLivroRepository geraLivroRepository, EntityManager entityManager, CalculoAcrescimoService calculoAcrescimoService, GeraLivroDividaAtivaEnglobadoService geraLivroDividaAtivaEnglobadoService, DebitoObservacaoService debitoObservacaoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, SituacaoParcelaService situacaoParcelaService, DividaService dividaService) {
        this.livroService = livroService;
        this.geraLivroRepository = geraLivroRepository;
        this.entityManager = entityManager;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.geraLivroDividaAtivaEnglobadoService = geraLivroDividaAtivaEnglobadoService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.dividaService = dividaService;
    }

    public Livro createLivroFromFiltro(FiltroGeraLivroDTO filtro, Boolean englobaDebitos) {
        LocalDate dataReferencia = LocalDate.now();
        Livro livro = this.getLivro(filtro, englobaDebitos, dataReferencia);
        return (Livro)this.livroService.save((EloEntity)livro, null);
    }

    public void calculaAcrescimo(List<GeraLivroDebitoParcelaTributoDTO> parcelaTributos, Boolean englobaDebitos, LocalDate dataReferencia, FormaPagamento formaPagamentoPadrao, ListasNecessariasCalculaAcrescimoDTO lncaDTO) {
        parcelaTributos.forEach(parcelaTributo -> {
            Divida divida = (Divida)this.entityManager.getReference(Divida.class, (Object)parcelaTributo.getIdDivida());
            AcrescimoDTO acrescimos = AcrescimoDTO.of((GeraLivroDebitoParcelaTributoDTO)parcelaTributo, (Divida)divida, (Long)formaPagamentoPadrao.getId());
            acrescimos.setDataReferencia(dataReferencia);
            acrescimos.setCalculaValorDesconto(Boolean.FALSE);
            if (englobaDebitos.booleanValue() && !this.isDividaIssHomologado(parcelaTributo)) {
                acrescimos.setDataVencimento(parcelaTributo.getMinDataVencimentoParcela());
            }
            this.calculoAcrescimoService.calculaAcrescimos(acrescimos, Optional.ofNullable(lncaDTO));
            parcelaTributo.setTipoDivida(divida.getTipoDivida().getCodigo());
            parcelaTributo.setValor(acrescimos.getValor());
            parcelaTributo.setValorJuros(acrescimos.getValorJuros());
            parcelaTributo.setValorMulta(acrescimos.getValorMulta());
            parcelaTributo.setValorCorrecao(acrescimos.getValorCorrecao());
        });
    }

    public void alterarSituacaoParcela(Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>> parcelasPorLivroRegistroToUpdate) {
        parcelasPorLivroRegistroToUpdate.forEach((livroRegistro, listaDebitoParcelaTributoPorDebito) -> {
            Map<Long, List<GeraLivroDebitoParcelaTributoDTO>> parcelasToUpdate = listaDebitoParcelaTributoPorDebito.stream().collect(Collectors.groupingBy(GeraLivroDebitoParcelaTributoDTO::getParcela));
            HashMap<DebitoIdDTO, String> observacoes = new HashMap<DebitoIdDTO, String>();
            HashSet parcelasEnglobadas = new HashSet();
            parcelasToUpdate.forEach((parcelaToUpdate, listaDebitoParcelaTributoPorParcela) -> listaDebitoParcelaTributoPorParcela.stream().findFirst().ifPresent(parcela -> {
                Boolean englobouParcelas = Objects.nonNull(parcela.getNovaSubDivida()) && !parcela.getSubDivida().equals(parcela.getNovaSubDivida());
                this.geraLivroRepository.updateDebitoParcela(DebitoParcelaId.builder().entidade(parcela.getEntidade()).exercicio(parcela.getExercicio()).tipoCadastro(parcela.getTipoCadastro()).cadastroGeral(parcela.getCadastroGeral()).divida(parcela.getDivida()).subDivida(parcela.getSubDivida()).parcela(parcela.getParcela()).build(), livroRegistro, SituacaoLegal.DIVIDA_ATIVA.getValue(), this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.BAIXA_INSCRICAO_DIVIDA_ATIVA, this.situacaoParcelaService.findSituacaoParcelaById(parcela.getSituacaoDebito())).getId(), englobouParcelas);
                DebitoIdDTO debitoId = DebitoIdDTO.of((Long)parcela.getIdDebito(), (Long)parcela.getEntidade(), (Long)parcela.getExercicio(), (Long)parcela.getTipoCadastro(), (Long)parcela.getCadastroGeral(), (Long)parcela.getDivida(), (Long)parcela.getSubDivida());
                String observacao = String.format("Inscrito em D\u00edvida em: %s, pelo usu\u00e1rio: %s", DateUtils.formatDateBr((LocalDate)LocalDate.now()), SecurityUtils.getUserAise());
                DebitoParcelaId parcelaDebitoEnglobado = DebitoParcelaId.builder().entidade(parcela.getEntidade()).exercicio(parcela.getExercicio()).tipoCadastro(parcela.getTipoCadastro()).cadastroGeral(parcela.getCadastroGeral()).divida(parcela.getDivida()).subDivida(parcela.getNovaSubDivida()).parcela(Long.valueOf(1L)).build();
                if (englobouParcelas.booleanValue() && !parcelasEnglobadas.contains(parcelaDebitoEnglobado)) {
                    parcelasEnglobadas.add(parcelaDebitoEnglobado);
                    observacao = String.format("Inscrito em D\u00edvida em: %s, pelo usu\u00e1rio: %s, nova subdivida %d", DateUtils.formatDateBr((LocalDate)LocalDate.now()), SecurityUtils.getUserAise(), parcela.getNovaSubDivida());
                }
                observacoes.putIfAbsent(debitoId, observacao);
            }));
            observacoes.forEach((arg_0, arg_1) -> ((DebitoObservacaoService)this.debitoObservacaoService).save(arg_0, arg_1));
        });
    }

    public void atualizarValorPai(Livro livro) {
        TotalizadorLivroDTO totalizadores = this.geraLivroRepository.getTotalizadores(livro.getId());
        livro.setValorTotalOriginal(totalizadores.getValorOriginal());
        livro.setValorTotalJuros(totalizadores.getValorJuros());
        livro.setValorTotalMulta(totalizadores.getValorMulta());
        livro.setValorTotalCorrecao(totalizadores.getValorCorrecao());
        livro.setValorTotal(totalizadores.getValorTotal());
        this.livroService.save((EloEntity)livro, null);
    }

    private Livro getLivro(FiltroGeraLivroDTO filtro, Boolean englobaDebitos, LocalDate dataReferencia) {
        if (filtro.getNovoLivro().booleanValue()) {
            Long parametroNumeroRegistroFolha = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.NUMERO_REGISTRO_FOLHA).map(ParametroEntidadeExercicio::getValor).map(Long::valueOf).orElseThrow(() -> new EloValidationException("\u00c9 necess\u00e1rio configurar o n\u00famero de registros por folha."));
            String usuario = UsuarioUtils.getUsuarioAise();
            Livro livro = Livro.of((LivroId)LivroId.of((Long)filtro.getEntidade(), (Long)filtro.getExercicio(), null));
            livro.setDataInclusao(dataReferencia);
            livro.setDataVencimentoInicial(filtro.getDataVencimentoInicial());
            livro.setDataVencimentoFinal(filtro.getDataVencimentoFinal());
            livro.setFiltroExercicioDebito(filtro.getExercicioDebito());
            livro.setFiltroCadastroGeral(filtro.getCadastroGeral());
            livro.setFiltroDivida(filtro.getDivida());
            livro.setNumeroRegistroFolha(parametroNumeroRegistroFolha);
            livro.setUsuario(usuario);
            livro.setEnglobaParcelas(englobaDebitos);
            return livro;
        }
        return (Livro)this.livroService.findOne((Serializable)LivroId.of((Long)filtro.getLivro().getEntidade(), (Long)filtro.getLivro().getExercicio(), (Long)filtro.getLivro().getLivro()));
    }

    public List<LivroRegistro> getRegistrosByInscricaoPorDebito(Livro livro, List<GeraLivroDebitoParcelaTributoDTO> parcelaTributos, Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>> parcelasToUpdate, LivroExistenteSequenciadoresDTO sequenciadores, FormaPagamento formaPagamentoPadrao, Boolean englobaDebitos, LocalDate dataInscricao) {
        ArrayList<LivroRegistro> livroRegistros = new ArrayList<LivroRegistro>();
        AtomicLong sequencia = new AtomicLong(sequenciadores.getLastSequencia());
        AtomicLong numeroFolha = new AtomicLong(sequenciadores.getLastNumeroFolha());
        AtomicLong sequenciaFolha = new AtomicLong(sequenciadores.getLastSequenciaFolha());
        Map<Long, List<GeraLivroDebitoParcelaTributoDTO>> debitos = parcelaTributos.stream().collect(Collectors.groupingBy(GeraLivroDebitoParcelaTributoDTO::getIdDebito));
        debitos.forEach((idDebito, listaDebitoParcelaTributoDoDebito) -> {
            LivroRegistro livroRegistro = this.geraLivroRegistro(livro, numeroFolha, sequenciaFolha, sequencia, listaDebitoParcelaTributoDoDebito, formaPagamentoPadrao, englobaDebitos, dataInscricao);
            parcelasToUpdate.put(livroRegistro, (List<GeraLivroDebitoParcelaTributoDTO>)listaDebitoParcelaTributoDoDebito);
            livroRegistros.add(livroRegistro);
        });
        return livroRegistros;
    }

    public List<LivroRegistro> getRegistrosByInscricaoPorParcela(Livro livro, List<GeraLivroDebitoParcelaTributoDTO> parcelaTributos, Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>> parcelasToUpdate, LivroExistenteSequenciadoresDTO sequenciadores, LocalDate dataInscricao) {
        ArrayList<LivroRegistro> livroRegistros = new ArrayList<LivroRegistro>();
        AtomicLong sequencia = new AtomicLong(sequenciadores.getLastSequencia());
        AtomicLong numeroFolha = new AtomicLong(sequenciadores.getLastNumeroFolha());
        AtomicLong sequenciaFolha = new AtomicLong(sequenciadores.getLastSequenciaFolha());
        Map<Long, Map<Long, List<GeraLivroDebitoParcelaTributoDTO>>> parcelasMap = parcelaTributos.stream().collect(Collectors.groupingBy(GeraLivroDebitoParcelaTributoDTO::getIdDebito, Collectors.groupingBy(GeraLivroDebitoParcelaTributoDTO::getParcela)));
        parcelasMap.forEach((idDebito, parcelas) -> parcelas.forEach((parcela, listaDebitoParcelaTributo) -> {
            LivroRegistro livroRegistro = this.geraLivroRegistro(livro, numeroFolha, sequenciaFolha, sequencia, listaDebitoParcelaTributo, null, Boolean.valueOf(false), dataInscricao);
            parcelasToUpdate.put(livroRegistro, (List<GeraLivroDebitoParcelaTributoDTO>)listaDebitoParcelaTributo);
            livroRegistros.add(livroRegistro);
        }));
        return livroRegistros;
    }

    private boolean isDividaIssHomologado(GeraLivroDebitoParcelaTributoDTO parcelaTributo) {
        return "H".equals(parcelaTributo.getTipoDivida());
    }

    private LivroRegistro geraLivroRegistro(Livro livro, AtomicLong numeroFolha, AtomicLong sequenciaFolha, AtomicLong sequencia, List<GeraLivroDebitoParcelaTributoDTO> listaDebitoParcelaTributo, FormaPagamento formaPagamento, Boolean englobaDebitos, LocalDate dataInscricao) {
        LivroRegistro livroRegistro = LivroRegistro.of((Livro)livro, (Long)sequencia.incrementAndGet());
        if (sequenciaFolha.get() >= livro.getNumeroRegistroFolha()) {
            numeroFolha.incrementAndGet();
            sequenciaFolha.set(0L);
        }
        livroRegistro.setNumeroFolha(Long.valueOf(numeroFolha.get()));
        livroRegistro.setSequenciaFolha(Long.valueOf(sequenciaFolha.incrementAndGet()));
        livroRegistro.setNumeroInscricao(Long.valueOf(sequencia.get()));
        listaDebitoParcelaTributo.stream().findFirst().ifPresent(livroParcelaTributo -> {
            Pessoa pessoa = (Pessoa)this.entityManager.getReference(Pessoa.class, (Object)livroParcelaTributo.getPessoa());
            livroRegistro.setPessoa(pessoa);
            livroRegistro.setNomeContribuinte(livroParcelaTributo.getPessoaNome());
            livroRegistro.setTipoCadastro(livroParcelaTributo.getTipoCadastro());
            livroRegistro.setCadastroGeralId(livroParcelaTributo.getCadastroGeral());
            livroRegistro.setDataInscricao(dataInscricao);
            Divida divida = this.dividaService.findByEntidadeAndExercicioAndDivida(livroParcelaTributo.getEntidade(), livroParcelaTributo.getExercicio(), livroParcelaTributo.getDivida()).orElse(null);
            if (Objects.nonNull(divida)) {
                livroRegistro.setFundamentoLegal(divida.getFundamentoLegal());
            }
        });
        boolean tipoDividaIssHomologado = listaDebitoParcelaTributo.stream().anyMatch(arg_0 -> this.isDividaIssHomologado(arg_0));
        if (englobaDebitos.booleanValue() && !tipoDividaIssHomologado) {
            listaDebitoParcelaTributo = this.geraLivroDividaAtivaEnglobadoService.geraDebitoEnglobadoAndRateia(livroRegistro, listaDebitoParcelaTributo, formaPagamento);
        }
        listaDebitoParcelaTributo.forEach(livroParcelaTributo -> {
            DebitoParcelaTributo debitoParcelaTributo = (DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)livroParcelaTributo.getIdDebitoParcelaTributo());
            livroRegistro.getParcelaTributos().add(LivroParcelaTributo.of((LivroRegistro)livroRegistro, (DebitoParcelaTributo)debitoParcelaTributo, (GeraLivroDebitoParcelaTributoDTO)livroParcelaTributo));
        });
        livroRegistro.setValorOriginal(livroRegistro.getValorOriginalFromParcelas());
        livroRegistro.setValorPrincipal(livroRegistro.getValorPrincipalFromParcelas());
        livroRegistro.setValorJuros(livroRegistro.getValorJurosFromParcelas());
        livroRegistro.setValorMulta(livroRegistro.getValorMultaFromParcelas());
        livroRegistro.setValorCorrecao(livroRegistro.getValorCorrecaoFromParcelas());
        return livroRegistro;
    }
}

