/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoHistoricoSituacao;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.GrupoDocumento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.atendimento.TipoAtendimento;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeTributosDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.DocumentoHistoricoSituacaoRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CertidaoDividaAtivaHistoricoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.DocumentoNotFoundException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.specs.DocumentoSpecifications;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.validation.Valid;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class DocumentoService
extends CrudService<Documento, Long> {
    private final DocumentoRepository documentoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final AisePdfService aisePdfService;
    private final DocumentoHistoricoSituacaoRepository documentoHistoricoSituacaoRepository;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final EntityManager em;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final PessoaService pessoaService;
    private final GeraDocumentoService geraDocumentoService;
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final ContextService contextService;
    private final CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService;

    public DocumentoService(DocumentoRepository documentoRepository, CadastroGeralRepository cadastroGeralRepository, AisePdfService aisePdfService, CadastroImobiliarioService cadastroImobiliarioService, DocumentoHistoricoSituacaoRepository documentoHistoricoSituacaoRepository, EntityManager em, SequenceGeneratorRepository sequenceGeneratorRepository, PessoaService pessoaService, GeraDocumentoService geraDocumentoService, DocumentoFinalidadeService documentoFinalidadeService, ContextService contextService, CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService) {
        this.documentoRepository = documentoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.aisePdfService = aisePdfService;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.documentoHistoricoSituacaoRepository = documentoHistoricoSituacaoRepository;
        this.em = em;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.pessoaService = pessoaService;
        this.geraDocumentoService = geraDocumentoService;
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.contextService = contextService;
        this.certidaoDividaAtivaHistoricoService = certidaoDividaAtivaHistoricoService;
    }

    protected void beforeInsert(Documento documento) {
        Assert.notNull((Object)documento.getEntidade(), (String)"A propriedade 'entidade' n\u00e3o foi associada");
        Assert.notNull((Object)documento.getExercicio(), (String)"A propriedade 'exercicio' n\u00e3o foi associada");
        Assert.notNull((Object)documento.getDocumentoTipo(), (String)"A propriedade 'documentoTipo' n\u00e3o foi associada");
        super.beforeInsert((EloEntity)documento);
        documento.setDocumento(this.geraCodigoDocumento(documento));
        documento.setCodigoValidacao(DigestUtils.md5Hex((String)UUID.randomUUID().toString()).toUpperCase());
        if (Objects.isNull(documento.getDocumento())) {
            documento.setDocumento(this.geraCodigoDocumento(documento));
        }
        AtomicLong sequencia = new AtomicLong(1L);
        documento.getDocumentoItemDividaAtivas().forEach(item -> {
            if (Objects.isNull(item.getId())) {
                item.setId(DocumentoItemDividaAtivaId.of((Long)documento.getEntidade(), (Long)documento.getExercicio(), (Long)documento.getDocumento(), (Long)documento.getTipoDocumento(), (Long)sequencia.getAndIncrement()));
                item.setDocumento(documento);
            }
        });
    }

    public Documento getDocumentoByCodigoValidacao(String codigoValidacao) {
        return this.documentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    public Page<DocumentoDTO> getDocumentos(Optional<String> search, Pageable pageable) {
        Page result = search.isPresent() ? this.documentoRepository.findAll((Specification)new RsqlSpecification(this.em, search.get(), Optional.empty()), pageable) : this.documentoRepository.findAll(pageable);
        return result.map(DocumentoDTO::from);
    }

    public DocumentoMobileDTO getDocumentoMobileDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, tipoDocumento, exercicio);
        DocumentoMobileDTO dto = new DocumentoMobileDTO(documentoEntity, urlImpressao);
        if (Optional.ofNullable(documentoEntity.getCadastroGeral()).isPresent() && documentoEntity.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
            Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(documentoEntity.getCadastroGeral().getTipoCadastro(), documentoEntity.getCadastroGeral().getCadastroGeral())).ifPresent(arg_0 -> ((DocumentoMobileDTO)dto).setCadastroImobiliarioEntity(arg_0));
        }
        return dto.from();
    }

    public DocumentoDTO getDocumentoDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, tipoDocumento, exercicio);
        return DocumentoDTO.from((Documento)documentoEntity, (String)urlImpressao);
    }

    public List<DocumentoProjection> getListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroGeral cadastroGeralEntity = (CadastroGeral)this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeralAndExclusaoLogicaFalse(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        return this.documentoRepository.findByCadastroGeral(cadastroGeralEntity, LocalDate.now());
    }

    public Page<DocumentoDTO> findAllDocumentoByCpfCnpj(String cpfCnpj, LocalDate dataValidade, Optional<String> search, Pageable pageable) {
        Specification specification = DocumentoSpecifications.byImprimeWebAndCpfCnpjAndDataValidade((String)cpfCnpj, (LocalDate)dataValidade);
        if (search.isPresent()) {
            specification = specification.and(RsqlUtils.createSpecFrom((EntityManager)this.em, Documento.class, (String)search.get(), Optional.empty()));
        }
        return this.documentoRepository.findAll(specification, pageable).map(DocumentoDTO::from).map(dto -> {
            dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
            return dto;
        });
    }

    public DocumentoDTO findDocumentoById(Long id) {
        return this.documentoRepository.findById((Object)id).map(DocumentoDTO::from).orElseThrow(() -> new DocumentoNotFoundException(id));
    }

    public Documento cancelarDocumento(Long id, CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        Documento documento = (Documento)this.documentoRepository.findById((Object)id).orElseThrow(() -> new DocumentoNotFoundException(id));
        if (documento.getCadastroGeral().getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro %d-%d est\u00e1 em exclus\u00e3o l\u00f3gica.", documento.getCadastroGeral().getTipoCadastro().getValue(), documento.getCadastroGeral().getCadastroGeral()));
        }
        DocumentoHistoricoSituacao documentoHistoricoSituacao = new DocumentoHistoricoSituacao();
        documentoHistoricoSituacao.setDocumento(documento);
        documentoHistoricoSituacao.setData(LocalDate.now());
        documentoHistoricoSituacao.setObservacao(cancelamentoDocumentoDTO.getObservacao());
        documentoHistoricoSituacao.setSituacaoAnterior(documento.getSituacao());
        documentoHistoricoSituacao.setUsuario(documento.getUsuario());
        this.documentoHistoricoSituacaoRepository.save((Object)documentoHistoricoSituacao);
        documento.setCancelado(Boolean.TRUE);
        documento.setDataCancelamento(LocalDate.now());
        documento.setUsuarioCancelamento(SecurityUtils.getUserAise());
        documento.setSituacao(cancelamentoDocumentoDTO.getSituacao());
        documento.setObservacaoCancelamento(cancelamentoDocumentoDTO.getObservacao());
        return (Documento)this.documentoRepository.save((Object)documento);
    }

    private Long geraCodigoDocumento(Documento documento) {
        Long menorGrupoDocumentoId = documento.getDocumentoTipo().getGruposDocumento().stream().map(GrupoDocumento::getId).min(Long::compareTo).orElseThrow(() -> new EloValidationException("Tipo de Documento n\u00e3o possui Grupo cadastrado."));
        if (documento.getDocumentoTipo().getGruposDocumento().stream().anyMatch(GrupoDocumento::getSequenciaPorExercicio)) {
            return this.sequenceGeneratorRepository.getNextVal(String.format("S05documentoGrupo_%d_%d_%d", documento.getEntidade(), documento.getExercicio(), menorGrupoDocumentoId));
        }
        return this.sequenceGeneratorRepository.getNextVal(String.format("S05documentoGrupo_%d_%d", documento.getEntidade(), menorGrupoDocumentoId));
    }

    public DocumentoGenericoDTO getInitialValues(@Valid AtendimentoDTO atendimento, TipoDocumentoEnum tipoDocumentoEnum) {
        DocumentoGenericoDTO valoresIniciais = new DocumentoGenericoDTO();
        valoresIniciais.setCodigoPessoa(Optional.ofNullable(atendimento.getContribuinte()).map(AtendimentoPessoaDTO::getCodigoPessoa).orElse(atendimento.getCadastroGeral().getCodigoPessoa()));
        valoresIniciais.setIdCadastro(atendimento.getCadastroGeral().getIdCadastro());
        if (TipoAtendimento.PRESENCIAL.equals((Object)atendimento.getTipoAtendimento()) || TipoAtendimento.TELEFONE.equals((Object)atendimento.getTipoAtendimento())) {
            valoresIniciais.setPessoaNome(atendimento.getNomeRequerente());
            valoresIniciais.setPessoaCpfCnpj(atendimento.getCpfCnpjRequerente());
            valoresIniciais.setTipoPessoa(this.getTipoPessoaByCpfCnpj(atendimento.getCpfCnpjRequerente()));
        } else {
            Optional.ofNullable(this.pessoaService.findOne(valoresIniciais.getCodigoPessoa())).ifPresent(pessoa -> {
                valoresIniciais.setPessoaNome(pessoa.getNome());
                valoresIniciais.setPessoaCpfCnpj(pessoa.getCnpjCpf());
                valoresIniciais.setTipoPessoa(pessoa.getTipoPessoa());
            });
        }
        valoresIniciais.setFinalidadesDisponiveis(this.getFinalidadesAtivasOrdenadas(tipoDocumentoEnum));
        valoresIniciais.setFinalidade((Long)valoresIniciais.getFinalidadesDisponiveis().stream().map(DocumentoFinalidadeDTO::getId).findFirst().orElse(null));
        return valoresIniciais;
    }

    private List<DocumentoFinalidadeDTO> getFinalidadesAtivasOrdenadas(TipoDocumentoEnum tipoDocumentoEnum) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return this.documentoFinalidadeService.getListDTO(entidade, exercicio, tipoDocumentoEnum.getValue()).stream().map(DocumentoFinalidadeTributosDTO::from).collect(Collectors.toList());
    }

    private TipoPessoa getTipoPessoaByCpfCnpj(String cpfCnpj) {
        if (cpfCnpj.trim().length() > 11) {
            return TipoPessoa.JURIDICA;
        }
        return TipoPessoa.FISICA;
    }

    public DocumentoDTO gerar(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = this.getGeracaoDocumentoDTO(documentoGenericoDTO, tipoDocumento);
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(geracaoDocumentoDTO);
        documento.setSubTipo(documentoGenericoDTO.getSubTipo());
        return DocumentoDTO.from((Documento)((Documento)this.save((EloEntity)documento, null)));
    }

    private GeracaoDocumentoDTO getGeracaoDocumentoDTO(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        if (documentoGenericoDTO.getPorCadastro().booleanValue()) {
            if (Objects.isNull(documentoGenericoDTO.getIdCadastro())) {
                throw new EloValidationException("Cadastro Geral \u00e9 obrigat\u00f3rio");
            }
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoGenericoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoGenericoDTO.getIdCadastro())));
            return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (CadastroGeral)cadastroGeral, (TipoDocumentoEnum)tipoDocumento);
        }
        if (Objects.isNull(documentoGenericoDTO.getCodigoPessoa())) {
            throw new EloValidationException("C\u00f3digo da pessoa \u00e9 obrigat\u00f3rio");
        }
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(documentoGenericoDTO.getCodigoPessoa()).orElseThrow(() -> new EloValidationException(String.format("Pessoa %d n\u00e3o encontrada", documentoGenericoDTO.getCodigoPessoa())));
        return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (Pessoa)pessoa, (TipoDocumentoEnum)tipoDocumento);
    }

    public Boolean existsDocumentoCDA(Long numero, Long exercicio) {
        return this.documentoRepository.existsDocumentoCDAByNumeroAndExercicio(numero, exercicio);
    }

    public Documento findDocumentoByEntidadeAndExercicioAndTipoDocumentoAndDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        return this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
    }

    public void removeDividaAtivaPeticao(Long id) {
        this.documentoRepository.removeDividaAtivaPeticao(id);
    }
}

