/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.report.RelatorioTributos;
import br.com.elotech.tributos.report.loader.CabecalhoParamLoader;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@Service
public class AvulsoCompletoRelatorioService {
    private static final String AVULSO = "sql/avulso.sql";
    public static final String DATASET_CABECALHO = "Cabecalho";
    public static final String DATASET_AVULSO = "Avulso";
    private final DataSource dataSource;
    private final CabecalhoParamLoader cabecalhoParamLoader;
    public static final String PARAM_FILTRO_RELATORIO = "PFiltroRelatorio";
    private final ReportFileResolverFactory reportFileResolverFactory;

    public AvulsoCompletoRelatorioService(DataSource dataSource, CabecalhoParamLoader cabecalhoParamLoader, ReportFileResolverFactory reportFileResolverFactory) {
        this.dataSource = dataSource;
        this.cabecalhoParamLoader = cabecalhoParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    public byte[] createAvulsoCompletoPdfReport(CadastroGeralParams params) {
        ReportDatasource reportDatasource = ReportDatasource.builder().add(DATASET_CABECALHO, (ReportDataLoader)this.cabecalhoParamLoader.datasetLoader(this.dataSource)).add(DATASET_AVULSO, (ReportDataLoader)DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)AVULSO), (Map)params.toMapParams(), (DataSource)this.dataSource)).params((ParamLoader)this.cabecalhoParamLoader).param(Param.of((String)PARAM_FILTRO_RELATORIO, (Object)params.getFiltroRelatorio())).build();
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioTributos.CADASTRO_AVULSO_COMPLETO.getDefaultRpt())).setReportDatasource(reportDatasource).build().exportToPdf();
    }
}

