/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.dto.TipoRequerimentoComTaxasDTO;
import br.com.elotech.tributos.dto.requerimento.TipoRequerimentoDTO;
import br.com.elotech.tributos.dto.requerimento.TipoRequerimentoListagemDTO;
import br.com.elotech.tributos.service.TipoRequerimentoService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-requerimentos"})
public class TipoRequerimentoResource
extends CrudResource<TipoRequerimento, Long> {
    public TipoRequerimentoService getService() {
        return (TipoRequerimentoService)super.getService();
    }

    @GetMapping(value={"/com-taxas/assunto/{idAssunto}"})
    public ResponseEntity<TipoRequerimentoComTaxasDTO> findTipoRequerimentoComTaxas(@PathVariable(value="idAssunto") Long assunto) {
        return ResponseEntity.ok((Object)this.getService().findTipoRequerimentoComTaxas(assunto));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<TipoRequerimentoListagemDTO>> search(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.getService().findByRsql(search, pageable);
        return ResponseEntity.ok((Object)result.map(TipoRequerimentoListagemDTO::from));
    }

    @GetMapping(value={"/resumo/{id}"})
    public ResponseEntity<TipoRequerimentoDTO> findById(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().getResumo(id));
    }
}

