/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.CadastroMobiliarioServicoDTO;
import br.com.elotech.tributos.service.MobiliarioServicoService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/api/cadastro-mobiliario/{idCadastroMobiliario}/servicos"})
public class MobiliarioServicoResource {
    private final MobiliarioServicoService mobiliarioServicoService;

    public MobiliarioServicoResource(MobiliarioServicoService mobiliarioServicoService) {
        this.mobiliarioServicoService = mobiliarioServicoService;
    }

    @GetMapping(params={"exercicio"})
    public ResponseEntity<List<CadastroMobiliarioServicoDTO>> getByCadastroMobiliarioIdAndExercicio(@PathVariable Long idCadastroMobiliario, @RequestParam(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.mobiliarioServicoService.getByCadastroMobiliarioIdAndExercicio(idCadastroMobiliario, exercicio));
    }

    @PostMapping
    public ResponseEntity<CadastroMobiliarioServicoDTO> create(@PathVariable Long idCadastroMobiliario, @Valid @RequestBody CadastroMobiliarioServicoDTO cadastroMobiliarioServicoDTO) {
        return ResponseEntity.ok((Object)this.mobiliarioServicoService.save(idCadastroMobiliario, cadastroMobiliarioServicoDTO));
    }

    @PutMapping(value={"/{idCadastroMobiliarioServico}"})
    public ResponseEntity<CadastroMobiliarioServicoDTO> update(@PathVariable Long idCadastroMobiliario, @Valid @RequestBody CadastroMobiliarioServicoDTO cadastroMobiliarioServicoDTO) {
        return ResponseEntity.ok((Object)this.mobiliarioServicoService.update(idCadastroMobiliario, cadastroMobiliarioServicoDTO));
    }

    @DeleteMapping(value={"/{idCadastroMobiliarioServico}"})
    public ResponseEntity<Void> delete(@PathVariable Long idCadastroMobiliarioServico) {
        this.mobiliarioServicoService.delete(idCadastroMobiliarioServico);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{idCadastroMobiliarioServico}/principal"})
    public ResponseEntity<Void> tornarPrincipal(@PathVariable Long idCadastroMobiliarioServico) {
        this.mobiliarioServicoService.tornarPrincipal(idCadastroMobiliarioServico);
        return ResponseEntity.ok().build();
    }
}

