/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.WebhookBancario;
import br.com.elotech.tributos.dto.ConvenioDTO;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.WebhookService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/convenios"})
public class ConvenioResource
extends CrudResource<Convenio, Long> {
    private final ConvenioService convenioService;
    private final WebhookService webhookService;

    public ConvenioResource(ConvenioService convenioService, WebhookService webhookService) {
        this.convenioService = convenioService;
        this.webhookService = webhookService;
    }

    @GetMapping(value={"/autocomplete-simplificado"})
    public ResponseEntity<Page<ConvenioDTO>> findConveniosByEntidadeAndDescricao(@RequestParam Long entidade, @RequestParam String descricao, Pageable pageable) {
        List allRecords = this.convenioService.findByEntidadeAndDescricao(entidade, descricao);
        List lista = allRecords.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(lista, pageable, (long)allRecords.size()));
    }

    @PutMapping(value={"/{idConvenio}/webhook/toggle"})
    public ResponseEntity ativarWebhook(@PathVariable(value="idConvenio") Long idConvenio, @Valid @RequestParam(value="funcao") WebhookBancario funcao) {
        this.webhookService.toggleWebhook(idConvenio, funcao);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }
}

