/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoCarneCustomRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String GET_DEBITOS_CARNE = "br/com/elotech/tributos/repository/get-debitos-carne.sql";
    private static final String GET_FORMAS_PAGAMENTO = "br/com/elotech/tributos/repository/get-formas-pagamento.sql";

    public DebitoCarneCustomRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoCarneDTO> getDebitosCarne(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)GET_DEBITOS_CARNE);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoCarneDTO.class));
    }

    public List<DebitoParcelaTributoCotaUnicaDTO> findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(Long idDebito) {
        String sql = FileUtils.readResourceAsString((String)GET_FORMAS_PAGAMENTO);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idDebito", (Object)idDebito);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaTributoCotaUnicaDTO.class));
    }
}

