/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.CodigoBarras;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.InstrucaoBoleto;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.cnab240.CNAB240Aceite;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoDesconto;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoMulta;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBBeneficiario;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBDescontoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBJurosDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBMultaDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.EmissaoBoletoBBPagadorDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmissaoBoletoBBDTO {
    private static Long VALOR = 1L;
    private static Long PORCENTAGEM = 2L;
    private static Long MODALIDADE_SIMPLES = 1L;
    private static String ZEROS = "000";
    private Long numeroConvenio;
    private Long numeroCarteira;
    private Long numeroVariacaoCarteira;
    private Long codigoModalidade;
    private String dataEmissao;
    private String dataVencimento;
    private BigDecimal valorOriginal;
    private BigDecimal valorAbatimento;
    private Long quantidadeDiasProtesto;
    private Long quantidadeDiasNegativacao;
    private Long orgaoNegativado;
    private String indicadorAceiteTituloVencido;
    private Long numeroDiasLimiteRecebimento;
    private String codigoAceite;
    private Long codigoTipoTitulo;
    private String descricaoTipoTitulo;
    private String indicadorPermissaoRecebimentoParcial;
    private String numeroTituloBeneficiario;
    private String campoUtilizacaoBeneficiario;
    private String numeroTituloCliente;
    private String mensagemBloquetoOcorrencia;
    private String indicadorPix;
    private EmissaoBoletoBBDescontoDTO desconto;
    private EmissaoBoletoBBDescontoDTO segundoDesconto;
    private EmissaoBoletoBBDescontoDTO terceiroDesconto;
    private EmissaoBoletoBBJurosDTO jurosMora;
    private EmissaoBoletoBBMultaDTO multa;
    private EmissaoBoletoBBPagadorDTO pagador;
    private EmissaoBoletoBBBeneficiario beneficiario;

    public static EmissaoBoletoBBDTO from(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240BB) {
        Convenio convenio = boleto.getModeloBloqueto().getConvenio();
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa endereco = pessoa.getEnderecoPrincipal();
        EmissaoBoletoBBDTO dto = new EmissaoBoletoBBDTO();
        dto.setNumeroConvenio((Long)Optional.ofNullable(convenio.getNumeroConvenio()).map(Long::valueOf).orElse(null));
        dto.setNumeroCarteira((Long)Optional.ofNullable(convenio.getCarteira()).map(Long::valueOf).orElse(null));
        dto.setNumeroVariacaoCarteira((Long)Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getCodigoBarras).map(CodigoBarras::getCarteiraVariacao).map(Long::valueOf).orElse(null));
        dto.setCodigoModalidade(MODALIDADE_SIMPLES);
        dto.setDataEmissao(boleto.getDataEmissao());
        dto.setDataVencimento(boleto.getDataVencimento());
        dto.setValorOriginal(boleto.getValorBloqueto());
        dto.setValorAbatimento(parametrosCNAB240BB.getValorAbatimento());
        dto.setQuantidadeDiasProtesto(parametrosCNAB240BB.getDiasProtesto());
        dto.setIndicadorAceiteTituloVencido(SimNao.SIM.getSigla());
        dto.setNumeroDiasLimiteRecebimento(Optional.ofNullable(parametrosCNAB240BB.getDiasBaixaDevolucao()).orElse(0L));
        if (boleto.permitePagamentoAposVencimento()) {
            dto.setIndicadorAceiteTituloVencido(SimNao.NAO.getSigla());
            dto.setNumeroDiasLimiteRecebimento(Long.valueOf(0L));
        }
        dto.setCodigoAceite((String)Optional.ofNullable(parametrosCNAB240BB.getAceite()).map(CNAB240Aceite::getId).orElse(null));
        dto.setCodigoTipoTitulo((Long)Optional.ofNullable(parametrosCNAB240BB.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getCodigo).orElse(null));
        dto.setDescricaoTipoTitulo((String)Optional.ofNullable(parametrosCNAB240BB.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getDescricao).orElse(null));
        dto.setIndicadorPermissaoRecebimentoParcial(SimNao.NAO.getSigla());
        dto.setNumeroTituloBeneficiario(boleto.getExercicioBloqueto().toString().substring(2, 2) + boleto.getId());
        dto.setCampoUtilizacaoBeneficiario(null);
        dto.setNumeroTituloCliente((String)Optional.ofNullable(boleto.getNossoNumero()).map(nossoNumero -> nossoNumero.startsWith(ZEROS) ? nossoNumero : ZEROS.concat((String)nossoNumero)).orElse(null));
        dto.setMensagemBloquetoOcorrencia((String)Optional.ofNullable(boleto.getModeloBloqueto().getInstrucaoBoleto()).map(InstrucaoBoleto::getDescricao).map(descricao -> StringUtils.substring((String)descricao, (int)0, (int)30)).orElse(null));
        dto.setIndicadorPix(Optional.ofNullable(convenio.getUtilizaPix()).map(SimNao::fromBoolean).orElse(SimNao.NAO.getSigla()));
        dto.setDesconto(EmissaoBoletoBBDTO.criarDescontoDTO((Long)Optional.ofNullable(parametrosCNAB240BB.getCodigoDesconto()).map(CNAB240CodigoDesconto::getCodigo).orElse(null), (BigDecimal)parametrosCNAB240BB.getValorPercentualDesconto(), (LocalDate)boleto.getDataVencimento()));
        if (Optional.ofNullable(dto.getDesconto()).map(EmissaoBoletoBBDescontoDTO::getTipo).orElse(0L) > 0L) {
            dto.setSegundoDesconto(EmissaoBoletoBBDTO.criarDescontoDTO((Long)Optional.ofNullable(parametrosCNAB240BB.getCodigoDesconto2()).map(CNAB240CodigoDesconto::getCodigo).orElse(null), (BigDecimal)parametrosCNAB240BB.getValorPercentualDesconto2(), null));
            dto.setTerceiroDesconto(EmissaoBoletoBBDTO.criarDescontoDTO((Long)Optional.ofNullable(parametrosCNAB240BB.getCodigoDesconto3()).map(CNAB240CodigoDesconto::getCodigo).orElse(null), (BigDecimal)parametrosCNAB240BB.getValorPercentualDesconto3(), null));
        }
        EmissaoBoletoBBJurosDTO jurosMora = new EmissaoBoletoBBJurosDTO();
        jurosMora.setTipo(Optional.ofNullable(parametrosCNAB240BB.getCodigoJuros()).map(CNAB240CodigoJuros::getId).orElse(0L));
        if (jurosMora.getTipo() > 0L) {
            if (VALOR.equals(jurosMora.getTipo())) {
                jurosMora.setValor(parametrosCNAB240BB.getValorJurosDiaTaxa());
            }
            if (PORCENTAGEM.equals(jurosMora.getTipo())) {
                jurosMora.setPorcentagem(parametrosCNAB240BB.getValorJurosDiaTaxa());
            }
        }
        dto.setJurosMora(jurosMora);
        EmissaoBoletoBBMultaDTO multa = new EmissaoBoletoBBMultaDTO();
        multa.setTipo(Optional.ofNullable(parametrosCNAB240BB.getCodigoMulta()).map(CNAB240CodigoMulta::getId).orElse(0L));
        if (multa.getTipo() > 0L) {
            multa.setData(boleto.getDataVencimento().plusDays(1L));
            if (VALOR.equals(multa.getTipo())) {
                multa.setValor(parametrosCNAB240BB.getValorPercentualMulta());
            }
            if (PORCENTAGEM.equals(multa.getTipo())) {
                multa.setPorcentagem(parametrosCNAB240BB.getValorPercentualMulta());
            }
        }
        dto.setMulta(multa);
        EmissaoBoletoBBPagadorDTO pagador = new EmissaoBoletoBBPagadorDTO();
        pagador.setTipoInscricao(pessoa.getTipoPessoa());
        pagador.setNumeroInscricao(pessoa.getCnpjCpfSemMascara());
        pagador.setNome(pessoa.getNome());
        if (Objects.nonNull(endereco)) {
            pagador.setEndereco(StringUtils.substring((String)StringUtils.normalizeSpace((String)String.format("%s %s %s %s", Optional.ofNullable(endereco.getLogradouro()).map(Logradouro::getTipoLogradouroDescricao).orElse(""), Optional.ofNullable(endereco.getLogradouro()).map(Logradouro::getDescricao).orElse(""), Optional.ofNullable(endereco.getNumero()).orElse(""), Optional.ofNullable(endereco.getComplemento()).orElse(""))), (int)0, (int)40));
            pagador.setCep((String)Optional.ofNullable(endereco.getCep()).map(cep -> org.apache.commons.lang3.StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(null));
            pagador.setBairro(Optional.ofNullable(endereco.getBairro()).map(Bairro::getDescricao).orElse(""));
            pagador.setCidade((String)Optional.ofNullable(endereco.getCidade()).map(Cidade::getDescricao).orElse(null));
            pagador.setUf(Optional.ofNullable(endereco.getUnidadeFederacao()).map(UnidadeFederacao::getUnidadeFederacao).orElse(Optional.ofNullable(endereco.getCidade()).map(Cidade::getUnidadeFederacao).orElse(null)));
        }
        dto.setPagador(pagador);
        EmissaoBoletoBBBeneficiario beneficiario = new EmissaoBoletoBBBeneficiario();
        beneficiario.setTipoInscricao(EmissaoBoletoBBBeneficiario.TIPO_INSCRICAO_CNPJ);
        beneficiario.setNumeroInscricao(parametrosCNAB240BB.getEntidade().getCnpj());
        beneficiario.setNome(parametrosCNAB240BB.getEntidade().getNome());
        dto.setBeneficiario(beneficiario);
        return dto;
    }

    private static EmissaoBoletoBBDescontoDTO criarDescontoDTO(Long tipoDesconto, BigDecimal valorDesconto, LocalDate dataExpiracao) {
        if (Objects.isNull(tipoDesconto)) {
            return null;
        }
        EmissaoBoletoBBDescontoDTO desconto = new EmissaoBoletoBBDescontoDTO();
        desconto.setTipo(tipoDesconto);
        if (tipoDesconto > 0L) {
            desconto.setDataExpiracao(dataExpiracao);
        }
        if (VALOR.equals(tipoDesconto)) {
            desconto.setValor(valorDesconto);
        }
        if (PORCENTAGEM.equals(tipoDesconto)) {
            desconto.setPorcentagem(valorDesconto);
        }
        return desconto;
    }

    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
    }

    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
    }

    @Generated
    public EmissaoBoletoBBDTO() {
    }

    @Generated
    public Long getNumeroConvenio() {
        return this.numeroConvenio;
    }

    @Generated
    public Long getNumeroCarteira() {
        return this.numeroCarteira;
    }

    @Generated
    public Long getNumeroVariacaoCarteira() {
        return this.numeroVariacaoCarteira;
    }

    @Generated
    public Long getCodigoModalidade() {
        return this.codigoModalidade;
    }

    @Generated
    public String getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public String getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    @Generated
    public BigDecimal getValorAbatimento() {
        return this.valorAbatimento;
    }

    @Generated
    public Long getQuantidadeDiasProtesto() {
        return this.quantidadeDiasProtesto;
    }

    @Generated
    public Long getQuantidadeDiasNegativacao() {
        return this.quantidadeDiasNegativacao;
    }

    @Generated
    public Long getOrgaoNegativado() {
        return this.orgaoNegativado;
    }

    @Generated
    public String getIndicadorAceiteTituloVencido() {
        return this.indicadorAceiteTituloVencido;
    }

    @Generated
    public Long getNumeroDiasLimiteRecebimento() {
        return this.numeroDiasLimiteRecebimento;
    }

    @Generated
    public String getCodigoAceite() {
        return this.codigoAceite;
    }

    @Generated
    public Long getCodigoTipoTitulo() {
        return this.codigoTipoTitulo;
    }

    @Generated
    public String getDescricaoTipoTitulo() {
        return this.descricaoTipoTitulo;
    }

    @Generated
    public String getIndicadorPermissaoRecebimentoParcial() {
        return this.indicadorPermissaoRecebimentoParcial;
    }

    @Generated
    public String getNumeroTituloBeneficiario() {
        return this.numeroTituloBeneficiario;
    }

    @Generated
    public String getCampoUtilizacaoBeneficiario() {
        return this.campoUtilizacaoBeneficiario;
    }

    @Generated
    public String getNumeroTituloCliente() {
        return this.numeroTituloCliente;
    }

    @Generated
    public String getMensagemBloquetoOcorrencia() {
        return this.mensagemBloquetoOcorrencia;
    }

    @Generated
    public String getIndicadorPix() {
        return this.indicadorPix;
    }

    @Generated
    public EmissaoBoletoBBDescontoDTO getDesconto() {
        return this.desconto;
    }

    @Generated
    public EmissaoBoletoBBDescontoDTO getSegundoDesconto() {
        return this.segundoDesconto;
    }

    @Generated
    public EmissaoBoletoBBDescontoDTO getTerceiroDesconto() {
        return this.terceiroDesconto;
    }

    @Generated
    public EmissaoBoletoBBJurosDTO getJurosMora() {
        return this.jurosMora;
    }

    @Generated
    public EmissaoBoletoBBMultaDTO getMulta() {
        return this.multa;
    }

    @Generated
    public EmissaoBoletoBBPagadorDTO getPagador() {
        return this.pagador;
    }

    @Generated
    public EmissaoBoletoBBBeneficiario getBeneficiario() {
        return this.beneficiario;
    }

    @Generated
    public void setNumeroConvenio(Long numeroConvenio) {
        this.numeroConvenio = numeroConvenio;
    }

    @Generated
    public void setNumeroCarteira(Long numeroCarteira) {
        this.numeroCarteira = numeroCarteira;
    }

    @Generated
    public void setNumeroVariacaoCarteira(Long numeroVariacaoCarteira) {
        this.numeroVariacaoCarteira = numeroVariacaoCarteira;
    }

    @Generated
    public void setCodigoModalidade(Long codigoModalidade) {
        this.codigoModalidade = codigoModalidade;
    }

    @Generated
    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    @Generated
    public void setValorAbatimento(BigDecimal valorAbatimento) {
        this.valorAbatimento = valorAbatimento;
    }

    @Generated
    public void setQuantidadeDiasProtesto(Long quantidadeDiasProtesto) {
        this.quantidadeDiasProtesto = quantidadeDiasProtesto;
    }

    @Generated
    public void setQuantidadeDiasNegativacao(Long quantidadeDiasNegativacao) {
        this.quantidadeDiasNegativacao = quantidadeDiasNegativacao;
    }

    @Generated
    public void setOrgaoNegativado(Long orgaoNegativado) {
        this.orgaoNegativado = orgaoNegativado;
    }

    @Generated
    public void setIndicadorAceiteTituloVencido(String indicadorAceiteTituloVencido) {
        this.indicadorAceiteTituloVencido = indicadorAceiteTituloVencido;
    }

    @Generated
    public void setNumeroDiasLimiteRecebimento(Long numeroDiasLimiteRecebimento) {
        this.numeroDiasLimiteRecebimento = numeroDiasLimiteRecebimento;
    }

    @Generated
    public void setCodigoAceite(String codigoAceite) {
        this.codigoAceite = codigoAceite;
    }

    @Generated
    public void setCodigoTipoTitulo(Long codigoTipoTitulo) {
        this.codigoTipoTitulo = codigoTipoTitulo;
    }

    @Generated
    public void setDescricaoTipoTitulo(String descricaoTipoTitulo) {
        this.descricaoTipoTitulo = descricaoTipoTitulo;
    }

    @Generated
    public void setIndicadorPermissaoRecebimentoParcial(String indicadorPermissaoRecebimentoParcial) {
        this.indicadorPermissaoRecebimentoParcial = indicadorPermissaoRecebimentoParcial;
    }

    @Generated
    public void setNumeroTituloBeneficiario(String numeroTituloBeneficiario) {
        this.numeroTituloBeneficiario = numeroTituloBeneficiario;
    }

    @Generated
    public void setCampoUtilizacaoBeneficiario(String campoUtilizacaoBeneficiario) {
        this.campoUtilizacaoBeneficiario = campoUtilizacaoBeneficiario;
    }

    @Generated
    public void setNumeroTituloCliente(String numeroTituloCliente) {
        this.numeroTituloCliente = numeroTituloCliente;
    }

    @Generated
    public void setMensagemBloquetoOcorrencia(String mensagemBloquetoOcorrencia) {
        this.mensagemBloquetoOcorrencia = mensagemBloquetoOcorrencia;
    }

    @Generated
    public void setIndicadorPix(String indicadorPix) {
        this.indicadorPix = indicadorPix;
    }

    @Generated
    public void setDesconto(EmissaoBoletoBBDescontoDTO desconto) {
        this.desconto = desconto;
    }

    @Generated
    public void setSegundoDesconto(EmissaoBoletoBBDescontoDTO segundoDesconto) {
        this.segundoDesconto = segundoDesconto;
    }

    @Generated
    public void setTerceiroDesconto(EmissaoBoletoBBDescontoDTO terceiroDesconto) {
        this.terceiroDesconto = terceiroDesconto;
    }

    @Generated
    public void setJurosMora(EmissaoBoletoBBJurosDTO jurosMora) {
        this.jurosMora = jurosMora;
    }

    @Generated
    public void setMulta(EmissaoBoletoBBMultaDTO multa) {
        this.multa = multa;
    }

    @Generated
    public void setPagador(EmissaoBoletoBBPagadorDTO pagador) {
        this.pagador = pagador;
    }

    @Generated
    public void setBeneficiario(EmissaoBoletoBBBeneficiario beneficiario) {
        this.beneficiario = beneficiario;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoBBDTO)) {
            return false;
        }
        EmissaoBoletoBBDTO other = (EmissaoBoletoBBDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numeroConvenio = this.getNumeroConvenio();
        Long other$numeroConvenio = other.getNumeroConvenio();
        if (this$numeroConvenio == null ? other$numeroConvenio != null : !((Object)this$numeroConvenio).equals(other$numeroConvenio)) {
            return false;
        }
        Long this$numeroCarteira = this.getNumeroCarteira();
        Long other$numeroCarteira = other.getNumeroCarteira();
        if (this$numeroCarteira == null ? other$numeroCarteira != null : !((Object)this$numeroCarteira).equals(other$numeroCarteira)) {
            return false;
        }
        Long this$numeroVariacaoCarteira = this.getNumeroVariacaoCarteira();
        Long other$numeroVariacaoCarteira = other.getNumeroVariacaoCarteira();
        if (this$numeroVariacaoCarteira == null ? other$numeroVariacaoCarteira != null : !((Object)this$numeroVariacaoCarteira).equals(other$numeroVariacaoCarteira)) {
            return false;
        }
        Long this$codigoModalidade = this.getCodigoModalidade();
        Long other$codigoModalidade = other.getCodigoModalidade();
        if (this$codigoModalidade == null ? other$codigoModalidade != null : !((Object)this$codigoModalidade).equals(other$codigoModalidade)) {
            return false;
        }
        String this$dataEmissao = this.getDataEmissao();
        String other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !this$dataEmissao.equals(other$dataEmissao)) {
            return false;
        }
        String this$dataVencimento = this.getDataVencimento();
        String other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !this$dataVencimento.equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valorOriginal = this.getValorOriginal();
        BigDecimal other$valorOriginal = other.getValorOriginal();
        if (this$valorOriginal == null ? other$valorOriginal != null : !((Object)this$valorOriginal).equals(other$valorOriginal)) {
            return false;
        }
        BigDecimal this$valorAbatimento = this.getValorAbatimento();
        BigDecimal other$valorAbatimento = other.getValorAbatimento();
        if (this$valorAbatimento == null ? other$valorAbatimento != null : !((Object)this$valorAbatimento).equals(other$valorAbatimento)) {
            return false;
        }
        Long this$quantidadeDiasProtesto = this.getQuantidadeDiasProtesto();
        Long other$quantidadeDiasProtesto = other.getQuantidadeDiasProtesto();
        if (this$quantidadeDiasProtesto == null ? other$quantidadeDiasProtesto != null : !((Object)this$quantidadeDiasProtesto).equals(other$quantidadeDiasProtesto)) {
            return false;
        }
        Long this$quantidadeDiasNegativacao = this.getQuantidadeDiasNegativacao();
        Long other$quantidadeDiasNegativacao = other.getQuantidadeDiasNegativacao();
        if (this$quantidadeDiasNegativacao == null ? other$quantidadeDiasNegativacao != null : !((Object)this$quantidadeDiasNegativacao).equals(other$quantidadeDiasNegativacao)) {
            return false;
        }
        Long this$orgaoNegativado = this.getOrgaoNegativado();
        Long other$orgaoNegativado = other.getOrgaoNegativado();
        if (this$orgaoNegativado == null ? other$orgaoNegativado != null : !((Object)this$orgaoNegativado).equals(other$orgaoNegativado)) {
            return false;
        }
        String this$indicadorAceiteTituloVencido = this.getIndicadorAceiteTituloVencido();
        String other$indicadorAceiteTituloVencido = other.getIndicadorAceiteTituloVencido();
        if (this$indicadorAceiteTituloVencido == null ? other$indicadorAceiteTituloVencido != null : !this$indicadorAceiteTituloVencido.equals(other$indicadorAceiteTituloVencido)) {
            return false;
        }
        Long this$numeroDiasLimiteRecebimento = this.getNumeroDiasLimiteRecebimento();
        Long other$numeroDiasLimiteRecebimento = other.getNumeroDiasLimiteRecebimento();
        if (this$numeroDiasLimiteRecebimento == null ? other$numeroDiasLimiteRecebimento != null : !((Object)this$numeroDiasLimiteRecebimento).equals(other$numeroDiasLimiteRecebimento)) {
            return false;
        }
        String this$codigoAceite = this.getCodigoAceite();
        String other$codigoAceite = other.getCodigoAceite();
        if (this$codigoAceite == null ? other$codigoAceite != null : !this$codigoAceite.equals(other$codigoAceite)) {
            return false;
        }
        Long this$codigoTipoTitulo = this.getCodigoTipoTitulo();
        Long other$codigoTipoTitulo = other.getCodigoTipoTitulo();
        if (this$codigoTipoTitulo == null ? other$codigoTipoTitulo != null : !((Object)this$codigoTipoTitulo).equals(other$codigoTipoTitulo)) {
            return false;
        }
        String this$descricaoTipoTitulo = this.getDescricaoTipoTitulo();
        String other$descricaoTipoTitulo = other.getDescricaoTipoTitulo();
        if (this$descricaoTipoTitulo == null ? other$descricaoTipoTitulo != null : !this$descricaoTipoTitulo.equals(other$descricaoTipoTitulo)) {
            return false;
        }
        String this$indicadorPermissaoRecebimentoParcial = this.getIndicadorPermissaoRecebimentoParcial();
        String other$indicadorPermissaoRecebimentoParcial = other.getIndicadorPermissaoRecebimentoParcial();
        if (this$indicadorPermissaoRecebimentoParcial == null ? other$indicadorPermissaoRecebimentoParcial != null : !this$indicadorPermissaoRecebimentoParcial.equals(other$indicadorPermissaoRecebimentoParcial)) {
            return false;
        }
        String this$numeroTituloBeneficiario = this.getNumeroTituloBeneficiario();
        String other$numeroTituloBeneficiario = other.getNumeroTituloBeneficiario();
        if (this$numeroTituloBeneficiario == null ? other$numeroTituloBeneficiario != null : !this$numeroTituloBeneficiario.equals(other$numeroTituloBeneficiario)) {
            return false;
        }
        String this$campoUtilizacaoBeneficiario = this.getCampoUtilizacaoBeneficiario();
        String other$campoUtilizacaoBeneficiario = other.getCampoUtilizacaoBeneficiario();
        if (this$campoUtilizacaoBeneficiario == null ? other$campoUtilizacaoBeneficiario != null : !this$campoUtilizacaoBeneficiario.equals(other$campoUtilizacaoBeneficiario)) {
            return false;
        }
        String this$numeroTituloCliente = this.getNumeroTituloCliente();
        String other$numeroTituloCliente = other.getNumeroTituloCliente();
        if (this$numeroTituloCliente == null ? other$numeroTituloCliente != null : !this$numeroTituloCliente.equals(other$numeroTituloCliente)) {
            return false;
        }
        String this$mensagemBloquetoOcorrencia = this.getMensagemBloquetoOcorrencia();
        String other$mensagemBloquetoOcorrencia = other.getMensagemBloquetoOcorrencia();
        if (this$mensagemBloquetoOcorrencia == null ? other$mensagemBloquetoOcorrencia != null : !this$mensagemBloquetoOcorrencia.equals(other$mensagemBloquetoOcorrencia)) {
            return false;
        }
        String this$indicadorPix = this.getIndicadorPix();
        String other$indicadorPix = other.getIndicadorPix();
        if (this$indicadorPix == null ? other$indicadorPix != null : !this$indicadorPix.equals(other$indicadorPix)) {
            return false;
        }
        EmissaoBoletoBBDescontoDTO this$desconto = this.getDesconto();
        EmissaoBoletoBBDescontoDTO other$desconto = other.getDesconto();
        if (this$desconto == null ? other$desconto != null : !this$desconto.equals(other$desconto)) {
            return false;
        }
        EmissaoBoletoBBDescontoDTO this$segundoDesconto = this.getSegundoDesconto();
        EmissaoBoletoBBDescontoDTO other$segundoDesconto = other.getSegundoDesconto();
        if (this$segundoDesconto == null ? other$segundoDesconto != null : !this$segundoDesconto.equals(other$segundoDesconto)) {
            return false;
        }
        EmissaoBoletoBBDescontoDTO this$terceiroDesconto = this.getTerceiroDesconto();
        EmissaoBoletoBBDescontoDTO other$terceiroDesconto = other.getTerceiroDesconto();
        if (this$terceiroDesconto == null ? other$terceiroDesconto != null : !this$terceiroDesconto.equals(other$terceiroDesconto)) {
            return false;
        }
        EmissaoBoletoBBJurosDTO this$jurosMora = this.getJurosMora();
        EmissaoBoletoBBJurosDTO other$jurosMora = other.getJurosMora();
        if (this$jurosMora == null ? other$jurosMora != null : !this$jurosMora.equals(other$jurosMora)) {
            return false;
        }
        EmissaoBoletoBBMultaDTO this$multa = this.getMulta();
        EmissaoBoletoBBMultaDTO other$multa = other.getMulta();
        if (this$multa == null ? other$multa != null : !this$multa.equals(other$multa)) {
            return false;
        }
        EmissaoBoletoBBPagadorDTO this$pagador = this.getPagador();
        EmissaoBoletoBBPagadorDTO other$pagador = other.getPagador();
        if (this$pagador == null ? other$pagador != null : !this$pagador.equals(other$pagador)) {
            return false;
        }
        EmissaoBoletoBBBeneficiario this$beneficiario = this.getBeneficiario();
        EmissaoBoletoBBBeneficiario other$beneficiario = other.getBeneficiario();
        return !(this$beneficiario == null ? other$beneficiario != null : !this$beneficiario.equals(other$beneficiario));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoBBDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numeroConvenio = this.getNumeroConvenio();
        result = result * 59 + ($numeroConvenio == null ? 43 : ((Object)$numeroConvenio).hashCode());
        Long $numeroCarteira = this.getNumeroCarteira();
        result = result * 59 + ($numeroCarteira == null ? 43 : ((Object)$numeroCarteira).hashCode());
        Long $numeroVariacaoCarteira = this.getNumeroVariacaoCarteira();
        result = result * 59 + ($numeroVariacaoCarteira == null ? 43 : ((Object)$numeroVariacaoCarteira).hashCode());
        Long $codigoModalidade = this.getCodigoModalidade();
        result = result * 59 + ($codigoModalidade == null ? 43 : ((Object)$codigoModalidade).hashCode());
        String $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : $dataEmissao.hashCode());
        String $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : $dataVencimento.hashCode());
        BigDecimal $valorOriginal = this.getValorOriginal();
        result = result * 59 + ($valorOriginal == null ? 43 : ((Object)$valorOriginal).hashCode());
        BigDecimal $valorAbatimento = this.getValorAbatimento();
        result = result * 59 + ($valorAbatimento == null ? 43 : ((Object)$valorAbatimento).hashCode());
        Long $quantidadeDiasProtesto = this.getQuantidadeDiasProtesto();
        result = result * 59 + ($quantidadeDiasProtesto == null ? 43 : ((Object)$quantidadeDiasProtesto).hashCode());
        Long $quantidadeDiasNegativacao = this.getQuantidadeDiasNegativacao();
        result = result * 59 + ($quantidadeDiasNegativacao == null ? 43 : ((Object)$quantidadeDiasNegativacao).hashCode());
        Long $orgaoNegativado = this.getOrgaoNegativado();
        result = result * 59 + ($orgaoNegativado == null ? 43 : ((Object)$orgaoNegativado).hashCode());
        String $indicadorAceiteTituloVencido = this.getIndicadorAceiteTituloVencido();
        result = result * 59 + ($indicadorAceiteTituloVencido == null ? 43 : $indicadorAceiteTituloVencido.hashCode());
        Long $numeroDiasLimiteRecebimento = this.getNumeroDiasLimiteRecebimento();
        result = result * 59 + ($numeroDiasLimiteRecebimento == null ? 43 : ((Object)$numeroDiasLimiteRecebimento).hashCode());
        String $codigoAceite = this.getCodigoAceite();
        result = result * 59 + ($codigoAceite == null ? 43 : $codigoAceite.hashCode());
        Long $codigoTipoTitulo = this.getCodigoTipoTitulo();
        result = result * 59 + ($codigoTipoTitulo == null ? 43 : ((Object)$codigoTipoTitulo).hashCode());
        String $descricaoTipoTitulo = this.getDescricaoTipoTitulo();
        result = result * 59 + ($descricaoTipoTitulo == null ? 43 : $descricaoTipoTitulo.hashCode());
        String $indicadorPermissaoRecebimentoParcial = this.getIndicadorPermissaoRecebimentoParcial();
        result = result * 59 + ($indicadorPermissaoRecebimentoParcial == null ? 43 : $indicadorPermissaoRecebimentoParcial.hashCode());
        String $numeroTituloBeneficiario = this.getNumeroTituloBeneficiario();
        result = result * 59 + ($numeroTituloBeneficiario == null ? 43 : $numeroTituloBeneficiario.hashCode());
        String $campoUtilizacaoBeneficiario = this.getCampoUtilizacaoBeneficiario();
        result = result * 59 + ($campoUtilizacaoBeneficiario == null ? 43 : $campoUtilizacaoBeneficiario.hashCode());
        String $numeroTituloCliente = this.getNumeroTituloCliente();
        result = result * 59 + ($numeroTituloCliente == null ? 43 : $numeroTituloCliente.hashCode());
        String $mensagemBloquetoOcorrencia = this.getMensagemBloquetoOcorrencia();
        result = result * 59 + ($mensagemBloquetoOcorrencia == null ? 43 : $mensagemBloquetoOcorrencia.hashCode());
        String $indicadorPix = this.getIndicadorPix();
        result = result * 59 + ($indicadorPix == null ? 43 : $indicadorPix.hashCode());
        EmissaoBoletoBBDescontoDTO $desconto = this.getDesconto();
        result = result * 59 + ($desconto == null ? 43 : $desconto.hashCode());
        EmissaoBoletoBBDescontoDTO $segundoDesconto = this.getSegundoDesconto();
        result = result * 59 + ($segundoDesconto == null ? 43 : $segundoDesconto.hashCode());
        EmissaoBoletoBBDescontoDTO $terceiroDesconto = this.getTerceiroDesconto();
        result = result * 59 + ($terceiroDesconto == null ? 43 : $terceiroDesconto.hashCode());
        EmissaoBoletoBBJurosDTO $jurosMora = this.getJurosMora();
        result = result * 59 + ($jurosMora == null ? 43 : $jurosMora.hashCode());
        EmissaoBoletoBBMultaDTO $multa = this.getMulta();
        result = result * 59 + ($multa == null ? 43 : $multa.hashCode());
        EmissaoBoletoBBPagadorDTO $pagador = this.getPagador();
        result = result * 59 + ($pagador == null ? 43 : $pagador.hashCode());
        EmissaoBoletoBBBeneficiario $beneficiario = this.getBeneficiario();
        result = result * 59 + ($beneficiario == null ? 43 : $beneficiario.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoBBDTO(numeroConvenio=" + this.getNumeroConvenio() + ", numeroCarteira=" + this.getNumeroCarteira() + ", numeroVariacaoCarteira=" + this.getNumeroVariacaoCarteira() + ", codigoModalidade=" + this.getCodigoModalidade() + ", dataEmissao=" + this.getDataEmissao() + ", dataVencimento=" + this.getDataVencimento() + ", valorOriginal=" + this.getValorOriginal() + ", valorAbatimento=" + this.getValorAbatimento() + ", quantidadeDiasProtesto=" + this.getQuantidadeDiasProtesto() + ", quantidadeDiasNegativacao=" + this.getQuantidadeDiasNegativacao() + ", orgaoNegativado=" + this.getOrgaoNegativado() + ", indicadorAceiteTituloVencido=" + this.getIndicadorAceiteTituloVencido() + ", numeroDiasLimiteRecebimento=" + this.getNumeroDiasLimiteRecebimento() + ", codigoAceite=" + this.getCodigoAceite() + ", codigoTipoTitulo=" + this.getCodigoTipoTitulo() + ", descricaoTipoTitulo=" + this.getDescricaoTipoTitulo() + ", indicadorPermissaoRecebimentoParcial=" + this.getIndicadorPermissaoRecebimentoParcial() + ", numeroTituloBeneficiario=" + this.getNumeroTituloBeneficiario() + ", campoUtilizacaoBeneficiario=" + this.getCampoUtilizacaoBeneficiario() + ", numeroTituloCliente=" + this.getNumeroTituloCliente() + ", mensagemBloquetoOcorrencia=" + this.getMensagemBloquetoOcorrencia() + ", indicadorPix=" + this.getIndicadorPix() + ", desconto=" + this.getDesconto() + ", segundoDesconto=" + this.getSegundoDesconto() + ", terceiroDesconto=" + this.getTerceiroDesconto() + ", jurosMora=" + this.getJurosMora() + ", multa=" + this.getMulta() + ", pagador=" + this.getPagador() + ", beneficiario=" + this.getBeneficiario() + ")";
    }
}

