/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.dividaativa;

import br.com.elotech.tributos.domain.Livro;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class LivroDTO {
    private Long entidade;
    private Long exercicio;
    private Long livro;
    private LocalDate dataInclusao;
    private String usuario;
    private Boolean englobaParcelas = Boolean.FALSE;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private BigDecimal valorTotalOriginal = BigDecimal.ZERO;
    private BigDecimal valorTotalJuros = BigDecimal.ZERO;
    private BigDecimal valorTotalMulta = BigDecimal.ZERO;
    private BigDecimal valorTotalCorrecao = BigDecimal.ZERO;
    private Long totalRegistros;
    private Long numeroRegistroFolha;
    private Long idJob;
    private String jobStatus;

    public static LivroDTO of(Livro livro) {
        return LivroDTO.ofWithTotal((Livro)livro, null);
    }

    public static LivroDTO ofWithTotal(Livro livro, Long totalRegistros) {
        LivroDTO livroDTO = new LivroDTO();
        livroDTO.setEntidade(livro.getId().getEntidade());
        livroDTO.setExercicio(livro.getId().getExercicio());
        livroDTO.setLivro(livro.getId().getLivro());
        livroDTO.setDataInclusao(livro.getDataInclusao());
        livroDTO.setUsuario(livro.getUsuario());
        livroDTO.setEnglobaParcelas(livro.getEnglobaParcelas());
        livroDTO.setValorTotal(livro.getValorTotal());
        livroDTO.setValorTotalOriginal(livro.getValorTotalOriginal());
        livroDTO.setValorTotalJuros(livro.getValorTotalJuros());
        livroDTO.setValorTotalMulta(livro.getValorTotalMulta());
        livroDTO.setValorTotalCorrecao(livro.getValorTotalCorrecao());
        livroDTO.setTotalRegistros(totalRegistros);
        livroDTO.setNumeroRegistroFolha(livro.getNumeroRegistroFolha());
        if (Objects.nonNull(livro.getBatchJobExecution())) {
            livroDTO.setIdJob(livro.getBatchJobExecution().getId());
            livroDTO.setJobStatus(livro.getBatchJobExecution().getStatus().toString());
        }
        return livroDTO;
    }

    @Generated
    public LivroDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLivro() {
        return this.livro;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getEnglobaParcelas() {
        return this.englobaParcelas;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public BigDecimal getValorTotalOriginal() {
        return this.valorTotalOriginal;
    }

    @Generated
    public BigDecimal getValorTotalJuros() {
        return this.valorTotalJuros;
    }

    @Generated
    public BigDecimal getValorTotalMulta() {
        return this.valorTotalMulta;
    }

    @Generated
    public BigDecimal getValorTotalCorrecao() {
        return this.valorTotalCorrecao;
    }

    @Generated
    public Long getTotalRegistros() {
        return this.totalRegistros;
    }

    @Generated
    public Long getNumeroRegistroFolha() {
        return this.numeroRegistroFolha;
    }

    @Generated
    public Long getIdJob() {
        return this.idJob;
    }

    @Generated
    public String getJobStatus() {
        return this.jobStatus;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLivro(Long livro) {
        this.livro = livro;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setEnglobaParcelas(Boolean englobaParcelas) {
        this.englobaParcelas = englobaParcelas;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorTotalOriginal(BigDecimal valorTotalOriginal) {
        this.valorTotalOriginal = valorTotalOriginal;
    }

    @Generated
    public void setValorTotalJuros(BigDecimal valorTotalJuros) {
        this.valorTotalJuros = valorTotalJuros;
    }

    @Generated
    public void setValorTotalMulta(BigDecimal valorTotalMulta) {
        this.valorTotalMulta = valorTotalMulta;
    }

    @Generated
    public void setValorTotalCorrecao(BigDecimal valorTotalCorrecao) {
        this.valorTotalCorrecao = valorTotalCorrecao;
    }

    @Generated
    public void setTotalRegistros(Long totalRegistros) {
        this.totalRegistros = totalRegistros;
    }

    @Generated
    public void setNumeroRegistroFolha(Long numeroRegistroFolha) {
        this.numeroRegistroFolha = numeroRegistroFolha;
    }

    @Generated
    public void setIdJob(Long idJob) {
        this.idJob = idJob;
    }

    @Generated
    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LivroDTO)) {
            return false;
        }
        LivroDTO other = (LivroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$livro = this.getLivro();
        Long other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !((Object)this$livro).equals(other$livro)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        Boolean this$englobaParcelas = this.getEnglobaParcelas();
        Boolean other$englobaParcelas = other.getEnglobaParcelas();
        if (this$englobaParcelas == null ? other$englobaParcelas != null : !((Object)this$englobaParcelas).equals(other$englobaParcelas)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        BigDecimal this$valorTotalOriginal = this.getValorTotalOriginal();
        BigDecimal other$valorTotalOriginal = other.getValorTotalOriginal();
        if (this$valorTotalOriginal == null ? other$valorTotalOriginal != null : !((Object)this$valorTotalOriginal).equals(other$valorTotalOriginal)) {
            return false;
        }
        BigDecimal this$valorTotalJuros = this.getValorTotalJuros();
        BigDecimal other$valorTotalJuros = other.getValorTotalJuros();
        if (this$valorTotalJuros == null ? other$valorTotalJuros != null : !((Object)this$valorTotalJuros).equals(other$valorTotalJuros)) {
            return false;
        }
        BigDecimal this$valorTotalMulta = this.getValorTotalMulta();
        BigDecimal other$valorTotalMulta = other.getValorTotalMulta();
        if (this$valorTotalMulta == null ? other$valorTotalMulta != null : !((Object)this$valorTotalMulta).equals(other$valorTotalMulta)) {
            return false;
        }
        BigDecimal this$valorTotalCorrecao = this.getValorTotalCorrecao();
        BigDecimal other$valorTotalCorrecao = other.getValorTotalCorrecao();
        if (this$valorTotalCorrecao == null ? other$valorTotalCorrecao != null : !((Object)this$valorTotalCorrecao).equals(other$valorTotalCorrecao)) {
            return false;
        }
        Long this$totalRegistros = this.getTotalRegistros();
        Long other$totalRegistros = other.getTotalRegistros();
        if (this$totalRegistros == null ? other$totalRegistros != null : !((Object)this$totalRegistros).equals(other$totalRegistros)) {
            return false;
        }
        Long this$numeroRegistroFolha = this.getNumeroRegistroFolha();
        Long other$numeroRegistroFolha = other.getNumeroRegistroFolha();
        if (this$numeroRegistroFolha == null ? other$numeroRegistroFolha != null : !((Object)this$numeroRegistroFolha).equals(other$numeroRegistroFolha)) {
            return false;
        }
        Long this$idJob = this.getIdJob();
        Long other$idJob = other.getIdJob();
        if (this$idJob == null ? other$idJob != null : !((Object)this$idJob).equals(other$idJob)) {
            return false;
        }
        String this$jobStatus = this.getJobStatus();
        String other$jobStatus = other.getJobStatus();
        return !(this$jobStatus == null ? other$jobStatus != null : !this$jobStatus.equals(other$jobStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LivroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : ((Object)$livro).hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        Boolean $englobaParcelas = this.getEnglobaParcelas();
        result = result * 59 + ($englobaParcelas == null ? 43 : ((Object)$englobaParcelas).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        BigDecimal $valorTotalOriginal = this.getValorTotalOriginal();
        result = result * 59 + ($valorTotalOriginal == null ? 43 : ((Object)$valorTotalOriginal).hashCode());
        BigDecimal $valorTotalJuros = this.getValorTotalJuros();
        result = result * 59 + ($valorTotalJuros == null ? 43 : ((Object)$valorTotalJuros).hashCode());
        BigDecimal $valorTotalMulta = this.getValorTotalMulta();
        result = result * 59 + ($valorTotalMulta == null ? 43 : ((Object)$valorTotalMulta).hashCode());
        BigDecimal $valorTotalCorrecao = this.getValorTotalCorrecao();
        result = result * 59 + ($valorTotalCorrecao == null ? 43 : ((Object)$valorTotalCorrecao).hashCode());
        Long $totalRegistros = this.getTotalRegistros();
        result = result * 59 + ($totalRegistros == null ? 43 : ((Object)$totalRegistros).hashCode());
        Long $numeroRegistroFolha = this.getNumeroRegistroFolha();
        result = result * 59 + ($numeroRegistroFolha == null ? 43 : ((Object)$numeroRegistroFolha).hashCode());
        Long $idJob = this.getIdJob();
        result = result * 59 + ($idJob == null ? 43 : ((Object)$idJob).hashCode());
        String $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : $jobStatus.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LivroDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", livro=" + this.getLivro() + ", dataInclusao=" + this.getDataInclusao() + ", usuario=" + this.getUsuario() + ", englobaParcelas=" + this.getEnglobaParcelas() + ", valorTotal=" + this.getValorTotal() + ", valorTotalOriginal=" + this.getValorTotalOriginal() + ", valorTotalJuros=" + this.getValorTotalJuros() + ", valorTotalMulta=" + this.getValorTotalMulta() + ", valorTotalCorrecao=" + this.getValorTotalCorrecao() + ", totalRegistros=" + this.getTotalRegistros() + ", numeroRegistroFolha=" + this.getNumeroRegistroFolha() + ", idJob=" + this.getIdJob() + ", jobStatus=" + this.getJobStatus() + ")";
    }
}

