/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DocumentoPessoa;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class DocumentoPessoasDTO {
    private Long id;
    private String nome;
    private String cpfCnpj;
    private Long idEndereco;
    private Long sequenciaEndereco;
    private String tipoLogradouro;
    private String logradouro;
    private String numero;
    private String bairro;
    private String cidade;
    private String unidadeFederacao;
    private Long cep;

    public static DocumentoPessoasDTO from(DocumentoPessoa documentoPessoa) {
        DocumentoPessoasDTO dto = new DocumentoPessoasDTO();
        dto.setId(documentoPessoa.getId());
        dto.setNome(documentoPessoa.getPessoa().getNome());
        dto.setCpfCnpj(documentoPessoa.getPessoa().getCnpjCpf());
        Optional.ofNullable(documentoPessoa.getPessoa().getEnderecoPrincipal()).ifPresent(enderecoPessoa -> {
            dto.setIdEndereco(enderecoPessoa.getId());
            dto.setSequenciaEndereco(enderecoPessoa.getCodigo());
            if (Objects.nonNull(enderecoPessoa.getLogradouro())) {
                dto.setTipoLogradouro(enderecoPessoa.getLogradouro().getTipoLogradouroDescricao());
                dto.setLogradouro(enderecoPessoa.getLogradouro().getDescricao());
            }
            dto.setNumero(enderecoPessoa.getNumero());
            dto.setCep(enderecoPessoa.getCep());
            if (Objects.nonNull(enderecoPessoa.getBairro())) {
                dto.setBairro(enderecoPessoa.getBairro().getDescricao());
                dto.setCidade(enderecoPessoa.getBairro().getCidade().getDescricao());
                dto.setUnidadeFederacao(enderecoPessoa.getBairro().getCidade().getUnidadeFederacao());
            }
        });
        return dto;
    }

    @Generated
    public DocumentoPessoasDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public Long getIdEndereco() {
        return this.idEndereco;
    }

    @Generated
    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setIdEndereco(Long idEndereco) {
        this.idEndereco = idEndereco;
    }

    @Generated
    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentoPessoasDTO)) {
            return false;
        }
        DocumentoPessoasDTO other = (DocumentoPessoasDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        Long this$idEndereco = this.getIdEndereco();
        Long other$idEndereco = other.getIdEndereco();
        if (this$idEndereco == null ? other$idEndereco != null : !((Object)this$idEndereco).equals(other$idEndereco)) {
            return false;
        }
        Long this$sequenciaEndereco = this.getSequenciaEndereco();
        Long other$sequenciaEndereco = other.getSequenciaEndereco();
        if (this$sequenciaEndereco == null ? other$sequenciaEndereco != null : !((Object)this$sequenciaEndereco).equals(other$sequenciaEndereco)) {
            return false;
        }
        String this$tipoLogradouro = this.getTipoLogradouro();
        String other$tipoLogradouro = other.getTipoLogradouro();
        if (this$tipoLogradouro == null ? other$tipoLogradouro != null : !this$tipoLogradouro.equals(other$tipoLogradouro)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$unidadeFederacao = this.getUnidadeFederacao();
        String other$unidadeFederacao = other.getUnidadeFederacao();
        if (this$unidadeFederacao == null ? other$unidadeFederacao != null : !this$unidadeFederacao.equals(other$unidadeFederacao)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        return !(this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DocumentoPessoasDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        Long $idEndereco = this.getIdEndereco();
        result = result * 59 + ($idEndereco == null ? 43 : ((Object)$idEndereco).hashCode());
        Long $sequenciaEndereco = this.getSequenciaEndereco();
        result = result * 59 + ($sequenciaEndereco == null ? 43 : ((Object)$sequenciaEndereco).hashCode());
        String $tipoLogradouro = this.getTipoLogradouro();
        result = result * 59 + ($tipoLogradouro == null ? 43 : $tipoLogradouro.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $unidadeFederacao = this.getUnidadeFederacao();
        result = result * 59 + ($unidadeFederacao == null ? 43 : $unidadeFederacao.hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DocumentoPessoasDTO(id=" + this.getId() + ", nome=" + this.getNome() + ", cpfCnpj=" + this.getCpfCnpj() + ", idEndereco=" + this.getIdEndereco() + ", sequenciaEndereco=" + this.getSequenciaEndereco() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", unidadeFederacao=" + this.getUnidadeFederacao() + ", cep=" + this.getCep() + ")";
    }
}

