/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.dto.AgrupamentoTributosDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class DebitoPagamentoNegociadoDTO
extends CalculaAcrescimoBaseDTO
implements Cloneable {
    private BigDecimal valorAbatido;
    private BigDecimal valorRestante;
    private StatusPagamentoNegociado status;
    private Long idDebitoParcelaReceita;
    private BigDecimal valorNovoDebito;
    private List<AgrupamentoTributosDTO> tributosAgrupados = new ArrayList();

    public <T extends CalculaAcrescimoBaseDTO> T add(T dto) {
        if (this.tributosAgrupados.isEmpty()) {
            this.tributosAgrupados.add(this.getBuild(this));
        }
        if (dto instanceof DebitoPagamentoNegociadoDTO) {
            this.tributosAgrupados.add(this.getBuild((DebitoPagamentoNegociadoDTO)dto));
        }
        return (T)super.internalAdd(dto);
    }

    private AgrupamentoTributosDTO getBuild(DebitoPagamentoNegociadoDTO dto) {
        return AgrupamentoTributosDTO.builder().idDebitoParcelaTributo(dto.getIdDebitoParcelaReceita()).valorPrincipal(dto.getValorPrincipal()).valorDescontoPrincipal(dto.getValorDescontoPrincipal()).valorCorrecao(dto.getValorCorrecao()).valorDescontoCorrecao(dto.getValorDescontoCorrecao()).valorJuros(dto.getValorJuros()).valorDescontoJuros(dto.getValorDescontoJuros()).valorMulta(dto.getValorMulta()).valorDescontoMulta(dto.getValorDescontoMulta()).tributo(dto.getTributo()).build();
    }

    public static DebitoPagamentoNegociadoDTO from(Debito debito) {
        DebitoParcela debitoParcela = (DebitoParcela)debito.getParcelas().get(0);
        List debitoParcelaTributos = debitoParcela.getTributos();
        DebitoPagamentoNegociadoDTO dto = new DebitoPagamentoNegociadoDTO();
        if (Objects.nonNull(debitoParcela.getId())) {
            dto.setEntidade(debitoParcela.getId().getEntidade());
            dto.setExercicio(debitoParcela.getId().getExercicio());
            dto.setDivida(debitoParcela.getId().getDivida());
            dto.setSubDivida(debitoParcela.getId().getSubDivida());
            dto.setParcela(debitoParcela.getId().getParcela());
            dto.setTipoCadastro(debitoParcela.getId().getTipoCadastro());
            dto.setCadastroGeral(debitoParcela.getId().getCadastroGeral());
        }
        Optional.ofNullable(debitoParcela.getSituacaoLegal()).ifPresent(dp -> dto.setSituacaoLegal(dp.getCodigo()));
        Optional.ofNullable(debitoParcela.getDataLancamento()).ifPresent(arg_0 -> ((DebitoPagamentoNegociadoDTO)dto).setDataLancamento(arg_0));
        Optional.ofNullable(debitoParcela.getDataVencimento()).ifPresent(arg_0 -> ((DebitoPagamentoNegociadoDTO)dto).setDataVencimento(arg_0));
        Optional.ofNullable(debitoParcela.getSituacaoDebito()).map(SituacaoParcela::getTipoSituacaoParcela).ifPresent(situacaoParcela -> dto.setTipoSituacaoParcela(situacaoParcela.getValue()));
        if (!debitoParcela.getTributos().isEmpty()) {
            dto.setIdDebitoParcelaReceita(((DebitoParcelaTributo)debitoParcela.getTributos().get(0)).getId());
            dto.setTributo(((DebitoParcelaTributo)debitoParcela.getTributos().get(0)).getTributo());
        }
        dto.setIdDebito(debito.getId());
        if (debitoParcelaTributos.size() == 1) {
            DebitoParcelaTributo tributo = (DebitoParcelaTributo)debitoParcelaTributos.get(0);
            dto.setIdDebitoParcelaReceita(tributo.getId());
            dto.setTributo(tributo.getTributo());
            dto.setValorPrincipal(tributo.getValorOriginal());
            dto.setValorJuros(tributo.getValorJuros());
            dto.setValorMulta(tributo.getValorMulta());
            dto.setValorCorrecao(tributo.getValorCorrecao());
            dto.setValorDescontoPrincipal(BigDecimal.ZERO);
            dto.setValorDescontoJuros(BigDecimal.ZERO);
            dto.setValorDescontoMulta(BigDecimal.ZERO);
            dto.setValorDescontoCorrecao(BigDecimal.ZERO);
            dto.setValorNovoDebito(tributo.getValor());
            return dto;
        }
        if (!debitoParcelaTributos.isEmpty()) {
            debitoParcelaTributos.stream().forEach(element -> {
                AgrupamentoTributosDTO agrupamentoTributosDTO = new AgrupamentoTributosDTO();
                agrupamentoTributosDTO.setIdDebitoParcelaTributo(element.getId());
                agrupamentoTributosDTO.setTributo(element.getTributo());
                agrupamentoTributosDTO.setValorPrincipal(element.getValorOriginal());
                agrupamentoTributosDTO.setValorJuros(element.getValorJuros());
                agrupamentoTributosDTO.setValorMulta(element.getValorMulta());
                agrupamentoTributosDTO.setValorCorrecao(element.getValorCorrecao());
                agrupamentoTributosDTO.setValorDescontoPrincipal(BigDecimal.ZERO);
                agrupamentoTributosDTO.setValorDescontoJuros(BigDecimal.ZERO);
                agrupamentoTributosDTO.setValorDescontoMulta(BigDecimal.ZERO);
                agrupamentoTributosDTO.setValorDescontoCorrecao(BigDecimal.ZERO);
                agrupamentoTributosDTO.setValorNovoDebito(element.getValor());
                dto.getTributosAgrupados().add(agrupamentoTributosDTO);
            });
        }
        return dto;
    }

    public static List<DebitoPagamentoNegociadoDTO> fromDebitoForCalculaAcrescimo(Debito debito) {
        ArrayList<DebitoPagamentoNegociadoDTO> calculaAcrescimos = new ArrayList<DebitoPagamentoNegociadoDTO>();
        List debitoParcelas = debito.getParcelas();
        if (debitoParcelas.isEmpty()) {
            return calculaAcrescimos;
        }
        DebitoParcela debitoParcela = (DebitoParcela)debitoParcelas.get(0);
        List debitoParcelaTributos = debitoParcela.getTributos();
        debitoParcelaTributos.stream().forEach(tributo -> {
            DebitoPagamentoNegociadoDTO dto = new DebitoPagamentoNegociadoDTO();
            dto.setEntidade(debitoParcela.getId().getEntidade());
            dto.setExercicio(debitoParcela.getId().getExercicio());
            dto.setDivida(debitoParcela.getId().getDivida());
            dto.setSubDivida(debitoParcela.getId().getSubDivida());
            dto.setParcela(debitoParcela.getId().getParcela());
            dto.setTipoCadastro(debitoParcela.getId().getTipoCadastro());
            dto.setCadastroGeral(debitoParcela.getId().getCadastroGeral());
            dto.setSituacaoLegal(debitoParcela.getSituacaoLegal().getCodigo());
            dto.setDataLancamento(debitoParcela.getDataLancamento());
            dto.setDataVencimento(debitoParcela.getDataVencimento());
            dto.setTipoSituacaoParcela(debitoParcela.getSituacaoDebito().getTipoSituacaoParcela().getValue());
            dto.setIdDebitoParcelaReceita(tributo.getId());
            dto.setTributo(tributo.getTributo());
            dto.setValorPrincipal(tributo.getValorOriginal());
            dto.setValorJuros(tributo.getValorJuros());
            dto.setValorMulta(tributo.getValorMulta());
            dto.setValorCorrecao(tributo.getValorCorrecao());
            dto.setValorDescontoPrincipal(BigDecimal.ZERO);
            dto.setValorDescontoJuros(BigDecimal.ZERO);
            dto.setValorDescontoMulta(BigDecimal.ZERO);
            dto.setValorDescontoCorrecao(BigDecimal.ZERO);
            dto.setValorNovoDebito(tributo.getValor());
            calculaAcrescimos.add(dto);
        });
        return calculaAcrescimos;
    }

    public DebitoPagamentoNegociadoDTO clone() {
        try {
            DebitoPagamentoNegociadoDTO clone = (DebitoPagamentoNegociadoDTO)super.clone();
            List tributosAgrupadosClone = clone.getTributosAgrupados().stream().map(element -> element.clone()).collect(Collectors.toList());
            clone.setTributosAgrupados(tributosAgrupadosClone);
            return clone;
        }
        catch (Exception ex) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel clonar o DebitoPagamentoNegociadoDTO");
        }
    }

    public BigDecimal getTotalNovoDebito() {
        return this.tributosAgrupados.isEmpty() ? this.valorNovoDebito : this.tributosAgrupados.stream().map(agrupamentoTributosDTO -> Optional.ofNullable(agrupamentoTributosDTO.getValorNovoDebito()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getPercentualPrincipal() {
        return this.getValorTotal().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.getValorPrincipal().divide(this.getValorTotal(), 10, RoundingMode.HALF_EVEN);
    }

    @Generated
    public DebitoPagamentoNegociadoDTO() {
    }

    @Generated
    public BigDecimal getValorAbatido() {
        return this.valorAbatido;
    }

    @Generated
    public BigDecimal getValorRestante() {
        return this.valorRestante;
    }

    @Generated
    public StatusPagamentoNegociado getStatus() {
        return this.status;
    }

    @Generated
    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    @Generated
    public BigDecimal getValorNovoDebito() {
        return this.valorNovoDebito;
    }

    @Generated
    public List<AgrupamentoTributosDTO> getTributosAgrupados() {
        return this.tributosAgrupados;
    }

    @Generated
    public void setValorAbatido(BigDecimal valorAbatido) {
        this.valorAbatido = valorAbatido;
    }

    @Generated
    public void setValorRestante(BigDecimal valorRestante) {
        this.valorRestante = valorRestante;
    }

    @Generated
    public void setStatus(StatusPagamentoNegociado status) {
        this.status = status;
    }

    @Generated
    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    @Generated
    public void setValorNovoDebito(BigDecimal valorNovoDebito) {
        this.valorNovoDebito = valorNovoDebito;
    }

    @Generated
    public void setTributosAgrupados(List<AgrupamentoTributosDTO> tributosAgrupados) {
        this.tributosAgrupados = tributosAgrupados;
    }

    @Generated
    public String toString() {
        return "DebitoPagamentoNegociadoDTO(valorAbatido=" + this.getValorAbatido() + ", valorRestante=" + this.getValorRestante() + ", status=" + this.getStatus() + ", idDebitoParcelaReceita=" + this.getIdDebitoParcelaReceita() + ", valorNovoDebito=" + this.getValorNovoDebito() + ", tributosAgrupados=" + this.getTributosAgrupados() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoPagamentoNegociadoDTO)) {
            return false;
        }
        DebitoPagamentoNegociadoDTO other = (DebitoPagamentoNegociadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BigDecimal this$valorAbatido = this.getValorAbatido();
        BigDecimal other$valorAbatido = other.getValorAbatido();
        if (this$valorAbatido == null ? other$valorAbatido != null : !((Object)this$valorAbatido).equals(other$valorAbatido)) {
            return false;
        }
        BigDecimal this$valorRestante = this.getValorRestante();
        BigDecimal other$valorRestante = other.getValorRestante();
        if (this$valorRestante == null ? other$valorRestante != null : !((Object)this$valorRestante).equals(other$valorRestante)) {
            return false;
        }
        StatusPagamentoNegociado this$status = this.getStatus();
        StatusPagamentoNegociado other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Long this$idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        Long other$idDebitoParcelaReceita = other.getIdDebitoParcelaReceita();
        if (this$idDebitoParcelaReceita == null ? other$idDebitoParcelaReceita != null : !((Object)this$idDebitoParcelaReceita).equals(other$idDebitoParcelaReceita)) {
            return false;
        }
        BigDecimal this$valorNovoDebito = this.getValorNovoDebito();
        BigDecimal other$valorNovoDebito = other.getValorNovoDebito();
        if (this$valorNovoDebito == null ? other$valorNovoDebito != null : !((Object)this$valorNovoDebito).equals(other$valorNovoDebito)) {
            return false;
        }
        List this$tributosAgrupados = this.getTributosAgrupados();
        List other$tributosAgrupados = other.getTributosAgrupados();
        return !(this$tributosAgrupados == null ? other$tributosAgrupados != null : !((Object)this$tributosAgrupados).equals(other$tributosAgrupados));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoPagamentoNegociadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $valorAbatido = this.getValorAbatido();
        result = result * 59 + ($valorAbatido == null ? 43 : ((Object)$valorAbatido).hashCode());
        BigDecimal $valorRestante = this.getValorRestante();
        result = result * 59 + ($valorRestante == null ? 43 : ((Object)$valorRestante).hashCode());
        StatusPagamentoNegociado $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Long $idDebitoParcelaReceita = this.getIdDebitoParcelaReceita();
        result = result * 59 + ($idDebitoParcelaReceita == null ? 43 : ((Object)$idDebitoParcelaReceita).hashCode());
        BigDecimal $valorNovoDebito = this.getValorNovoDebito();
        result = result * 59 + ($valorNovoDebito == null ? 43 : ((Object)$valorNovoDebito).hashCode());
        List $tributosAgrupados = this.getTributosAgrupados();
        result = result * 59 + ($tributosAgrupados == null ? 43 : ((Object)$tributosAgrupados).hashCode());
        return result;
    }
}

