/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.parcelamento;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.converter.TipoParcelamentoConverter;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DocumentoAutenticadoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequerenteDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribparcelamento")
public class Parcelamento
implements EloEntity<Long>,
Serializable {
    private static final long serialVersionUID = 4789269775384604027L;
    private static final Long TIPODOCUMENTO_PARCELAMENTO = 999L;
    @Id
    @Column(name="idparcelamento")
    @EloSequence(sequenceName="S05IDPARCELAMENTO")
    private Long id;
    private Long entidade;
    @Convert(converter=TipoParcelamentoConverter.class)
    private TipoParcelamento tipo;
    private Long anoContrato;
    private Long numeroContrato;
    private LocalDate dataParcelamento;
    private LocalDate dataInclusao;
    private LocalDate dataEntrada;
    private Long numeroParcela;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @Length(max=4000)
    private @Length(max=4000) String observacaoUsuario;
    private BigDecimal valorEntrada = BigDecimal.ZERO;
    private String usuario;
    private Long anoProcesso;
    private Long numeroProcesso;
    private Long anoProcessoQuitacao;
    private Long processoQuitacao;
    private Long anoProcessoPrazo;
    private Long numeroProcessoPrazo;
    @Column(name="idparametroparcelamento")
    private Long idParametroParcelamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnOrFormula(formula=@JoinFormula(value="idparametroparcelamento"))
    private ParamParcelamento paramParcelamento;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estornado;
    @ManyToOne
    @JoinColumn(name="REQUERENTE")
    private Pessoa requerente;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean conversao;
    @ManyToOne
    private SituacaoParcelamento situacao;
    private LocalDate dataQuitacao;
    @JsonIgnore
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="tribparcelamentodebito", joinColumns={@JoinColumn(name="idparcelamento", insertable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="iddebito")})
    private List<Debito> debitos;
    @Length(max=100)
    private @Length(max=100) String codigoValidacao;
    private UUID idArquivo;
    @Length(max=60)
    private @Length(max=60) String tenant;

    public CadastroGeralResumidoDTO getCadastroGeralResumido() {
        return CadastroGeralResumidoDTO.from((CadastroGeral)this.cadastroGeral);
    }

    public ParcelamentoDTO toDto() {
        ParcelamentoDTO dto = new ParcelamentoDTO();
        dto.setId(this.getId());
        dto.setEntidade(this.getEntidade());
        dto.setTipo(this.getTipo().getCodigo());
        dto.setTipoDescricao(this.getTipo().getDescricao());
        dto.setAnoContrato(this.getAnoContrato());
        dto.setNumeroContrato(this.getNumeroContrato());
        dto.setDataParcelamento(this.getDataParcelamento());
        dto.setDataInclusao(this.getDataInclusao());
        dto.setDataEntrada(this.getDataEntrada());
        dto.setNumeroParcela(this.getNumeroParcela());
        dto.setObservacao(this.getObservacao());
        dto.setValorEntrada(this.getValorEntrada());
        dto.setUsuario(this.getUsuario());
        dto.setAnoProcessoPrazo(this.getAnoProcessoPrazo());
        dto.setNumeroProcessoPrazo(this.getNumeroProcessoPrazo());
        dto.setIdParametroParcelamento(this.getIdParametroParcelamento());
        dto.setEstornado(this.getEstornado());
        dto.setConversao(this.getConversao());
        dto.setSituacaoId(this.getSituacao().getId());
        dto.setSituacaoDescricao(this.getSituacao().getDescricao());
        dto.setTipoCadastro(this.getCadastroGeral().getTipoCadastro().getValue());
        dto.setCadastroGeral(this.getCadastroGeral().getCadastroGeral());
        if (Objects.nonNull(this.getRequerente())) {
            RequerenteDTO requerenteDTO = new RequerenteDTO();
            requerenteDTO.setId(this.getRequerente().getId());
            requerenteDTO.setNome(this.getRequerente().getNome());
            requerenteDTO.setNomeFantasia(this.getRequerente().getNomeFantasia());
            requerenteDTO.setAtividadePrincipal(this.getRequerente().getAtividadePrincipal());
            requerenteDTO.setInscricaoEstadual(this.getRequerente().getInscricaoEstadual());
            requerenteDTO.setCnpjCpf(this.getRequerente().getCnpjCpf());
            requerenteDTO.setRg(this.getRequerente().getRg());
            dto.setRequerente(requerenteDTO);
        }
        return dto;
    }

    @JsonIgnore
    public BigDecimal getValorTotal() {
        if (Objects.nonNull(this.getDebitos())) {
            return this.getDebitos().stream().map(Debito::getValorTotalDebito).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return new BigDecimal("0");
    }

    public DocumentoAutenticadoDTO toDocumentoAutenticadoDTO() {
        DocumentoAutenticadoDTO documentoAutenticadoDTO = new DocumentoAutenticadoDTO();
        documentoAutenticadoDTO.setNumeroContrato(this.numeroContrato);
        documentoAutenticadoDTO.setAnoContrato(this.anoContrato);
        if (Objects.nonNull(this.cadastroGeral)) {
            documentoAutenticadoDTO.setTipoCadastro(this.cadastroGeral.getTipoCadastro().getValue());
            documentoAutenticadoDTO.setCadastroGeral(this.cadastroGeral.getCadastroGeral());
        }
        documentoAutenticadoDTO.setParcelas(this.numeroParcela);
        documentoAutenticadoDTO.setDataEntrada(this.dataEntrada);
        documentoAutenticadoDTO.setDataParcelamento(this.dataParcelamento);
        documentoAutenticadoDTO.setValorEntrada(this.valorEntrada);
        if (Objects.nonNull(this.requerente)) {
            documentoAutenticadoDTO.setCpfRequerente(this.requerente.getCnpjCpf());
            documentoAutenticadoDTO.setRequerente(this.requerente.getNome());
        }
        if (Objects.nonNull(this.paramParcelamento)) {
            documentoAutenticadoDTO.setDescricaoParametro(this.paramParcelamento.getDescricao());
        }
        documentoAutenticadoDTO.setTipoDocumento(TIPODOCUMENTO_PARCELAMENTO);
        documentoAutenticadoDTO.setDescricao("PARCELAMENTO");
        if (Objects.nonNull(this.situacao)) {
            documentoAutenticadoDTO.setDescricaoSituacao(this.situacao.getDescricao());
        }
        documentoAutenticadoDTO.setValorTotalParcelamento(this.getValorTotal());
        documentoAutenticadoDTO.setIdParcelamento(this.getId());
        return documentoAutenticadoDTO;
    }

    @Generated
    public Parcelamento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public TipoParcelamento getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public LocalDate getDataParcelamento() {
        return this.dataParcelamento;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataEntrada() {
        return this.dataEntrada;
    }

    @Generated
    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getObservacaoUsuario() {
        return this.observacaoUsuario;
    }

    @Generated
    public BigDecimal getValorEntrada() {
        return this.valorEntrada;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getAnoProcesso() {
        return this.anoProcesso;
    }

    @Generated
    public Long getNumeroProcesso() {
        return this.numeroProcesso;
    }

    @Generated
    public Long getAnoProcessoQuitacao() {
        return this.anoProcessoQuitacao;
    }

    @Generated
    public Long getProcessoQuitacao() {
        return this.processoQuitacao;
    }

    @Generated
    public Long getAnoProcessoPrazo() {
        return this.anoProcessoPrazo;
    }

    @Generated
    public Long getNumeroProcessoPrazo() {
        return this.numeroProcessoPrazo;
    }

    @Generated
    public Long getIdParametroParcelamento() {
        return this.idParametroParcelamento;
    }

    @Generated
    public ParamParcelamento getParamParcelamento() {
        return this.paramParcelamento;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public Pessoa getRequerente() {
        return this.requerente;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Boolean getConversao() {
        return this.conversao;
    }

    @Generated
    public SituacaoParcelamento getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataQuitacao() {
        return this.dataQuitacao;
    }

    @Generated
    public List<Debito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    @Generated
    public UUID getIdArquivo() {
        return this.idArquivo;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setTipo(TipoParcelamento tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setAnoContrato(Long anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setDataParcelamento(LocalDate dataParcelamento) {
        this.dataParcelamento = dataParcelamento;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataEntrada(LocalDate dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @Generated
    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setObservacaoUsuario(String observacaoUsuario) {
        this.observacaoUsuario = observacaoUsuario;
    }

    @Generated
    public void setValorEntrada(BigDecimal valorEntrada) {
        this.valorEntrada = valorEntrada;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setAnoProcesso(Long anoProcesso) {
        this.anoProcesso = anoProcesso;
    }

    @Generated
    public void setNumeroProcesso(Long numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setAnoProcessoQuitacao(Long anoProcessoQuitacao) {
        this.anoProcessoQuitacao = anoProcessoQuitacao;
    }

    @Generated
    public void setProcessoQuitacao(Long processoQuitacao) {
        this.processoQuitacao = processoQuitacao;
    }

    @Generated
    public void setAnoProcessoPrazo(Long anoProcessoPrazo) {
        this.anoProcessoPrazo = anoProcessoPrazo;
    }

    @Generated
    public void setNumeroProcessoPrazo(Long numeroProcessoPrazo) {
        this.numeroProcessoPrazo = numeroProcessoPrazo;
    }

    @Generated
    public void setIdParametroParcelamento(Long idParametroParcelamento) {
        this.idParametroParcelamento = idParametroParcelamento;
    }

    @Generated
    public void setParamParcelamento(ParamParcelamento paramParcelamento) {
        this.paramParcelamento = paramParcelamento;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public void setRequerente(Pessoa requerente) {
        this.requerente = requerente;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setConversao(Boolean conversao) {
        this.conversao = conversao;
    }

    @Generated
    public void setSituacao(SituacaoParcelamento situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataQuitacao(LocalDate dataQuitacao) {
        this.dataQuitacao = dataQuitacao;
    }

    @Generated
    public void setDebitos(List<Debito> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    @Generated
    public void setIdArquivo(UUID idArquivo) {
        this.idArquivo = idArquivo;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parcelamento)) {
            return false;
        }
        Parcelamento other = (Parcelamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        TipoParcelamento this$tipo = this.getTipo();
        TipoParcelamento other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        Long this$anoContrato = this.getAnoContrato();
        Long other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        LocalDate this$dataParcelamento = this.getDataParcelamento();
        LocalDate other$dataParcelamento = other.getDataParcelamento();
        if (this$dataParcelamento == null ? other$dataParcelamento != null : !((Object)this$dataParcelamento).equals(other$dataParcelamento)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataEntrada = this.getDataEntrada();
        LocalDate other$dataEntrada = other.getDataEntrada();
        if (this$dataEntrada == null ? other$dataEntrada != null : !((Object)this$dataEntrada).equals(other$dataEntrada)) {
            return false;
        }
        Long this$numeroParcela = this.getNumeroParcela();
        Long other$numeroParcela = other.getNumeroParcela();
        if (this$numeroParcela == null ? other$numeroParcela != null : !((Object)this$numeroParcela).equals(other$numeroParcela)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$observacaoUsuario = this.getObservacaoUsuario();
        String other$observacaoUsuario = other.getObservacaoUsuario();
        if (this$observacaoUsuario == null ? other$observacaoUsuario != null : !this$observacaoUsuario.equals(other$observacaoUsuario)) {
            return false;
        }
        BigDecimal this$valorEntrada = this.getValorEntrada();
        BigDecimal other$valorEntrada = other.getValorEntrada();
        if (this$valorEntrada == null ? other$valorEntrada != null : !((Object)this$valorEntrada).equals(other$valorEntrada)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        Long this$anoProcesso = this.getAnoProcesso();
        Long other$anoProcesso = other.getAnoProcesso();
        if (this$anoProcesso == null ? other$anoProcesso != null : !((Object)this$anoProcesso).equals(other$anoProcesso)) {
            return false;
        }
        Long this$numeroProcesso = this.getNumeroProcesso();
        Long other$numeroProcesso = other.getNumeroProcesso();
        if (this$numeroProcesso == null ? other$numeroProcesso != null : !((Object)this$numeroProcesso).equals(other$numeroProcesso)) {
            return false;
        }
        Long this$anoProcessoQuitacao = this.getAnoProcessoQuitacao();
        Long other$anoProcessoQuitacao = other.getAnoProcessoQuitacao();
        if (this$anoProcessoQuitacao == null ? other$anoProcessoQuitacao != null : !((Object)this$anoProcessoQuitacao).equals(other$anoProcessoQuitacao)) {
            return false;
        }
        Long this$processoQuitacao = this.getProcessoQuitacao();
        Long other$processoQuitacao = other.getProcessoQuitacao();
        if (this$processoQuitacao == null ? other$processoQuitacao != null : !((Object)this$processoQuitacao).equals(other$processoQuitacao)) {
            return false;
        }
        Long this$anoProcessoPrazo = this.getAnoProcessoPrazo();
        Long other$anoProcessoPrazo = other.getAnoProcessoPrazo();
        if (this$anoProcessoPrazo == null ? other$anoProcessoPrazo != null : !((Object)this$anoProcessoPrazo).equals(other$anoProcessoPrazo)) {
            return false;
        }
        Long this$numeroProcessoPrazo = this.getNumeroProcessoPrazo();
        Long other$numeroProcessoPrazo = other.getNumeroProcessoPrazo();
        if (this$numeroProcessoPrazo == null ? other$numeroProcessoPrazo != null : !((Object)this$numeroProcessoPrazo).equals(other$numeroProcessoPrazo)) {
            return false;
        }
        Long this$idParametroParcelamento = this.getIdParametroParcelamento();
        Long other$idParametroParcelamento = other.getIdParametroParcelamento();
        if (this$idParametroParcelamento == null ? other$idParametroParcelamento != null : !((Object)this$idParametroParcelamento).equals(other$idParametroParcelamento)) {
            return false;
        }
        ParamParcelamento this$paramParcelamento = this.getParamParcelamento();
        ParamParcelamento other$paramParcelamento = other.getParamParcelamento();
        if (this$paramParcelamento == null ? other$paramParcelamento != null : !this$paramParcelamento.equals(other$paramParcelamento)) {
            return false;
        }
        Boolean this$estornado = this.getEstornado();
        Boolean other$estornado = other.getEstornado();
        if (this$estornado == null ? other$estornado != null : !((Object)this$estornado).equals(other$estornado)) {
            return false;
        }
        Pessoa this$requerente = this.getRequerente();
        Pessoa other$requerente = other.getRequerente();
        if (this$requerente == null ? other$requerente != null : !this$requerente.equals(other$requerente)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        Boolean this$conversao = this.getConversao();
        Boolean other$conversao = other.getConversao();
        if (this$conversao == null ? other$conversao != null : !((Object)this$conversao).equals(other$conversao)) {
            return false;
        }
        SituacaoParcelamento this$situacao = this.getSituacao();
        SituacaoParcelamento other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        LocalDate this$dataQuitacao = this.getDataQuitacao();
        LocalDate other$dataQuitacao = other.getDataQuitacao();
        if (this$dataQuitacao == null ? other$dataQuitacao != null : !((Object)this$dataQuitacao).equals(other$dataQuitacao)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        String this$codigoValidacao = this.getCodigoValidacao();
        String other$codigoValidacao = other.getCodigoValidacao();
        if (this$codigoValidacao == null ? other$codigoValidacao != null : !this$codigoValidacao.equals(other$codigoValidacao)) {
            return false;
        }
        UUID this$idArquivo = this.getIdArquivo();
        UUID other$idArquivo = other.getIdArquivo();
        if (this$idArquivo == null ? other$idArquivo != null : !((Object)this$idArquivo).equals(other$idArquivo)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Parcelamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        TipoParcelamento $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        Long $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        LocalDate $dataParcelamento = this.getDataParcelamento();
        result = result * 59 + ($dataParcelamento == null ? 43 : ((Object)$dataParcelamento).hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataEntrada = this.getDataEntrada();
        result = result * 59 + ($dataEntrada == null ? 43 : ((Object)$dataEntrada).hashCode());
        Long $numeroParcela = this.getNumeroParcela();
        result = result * 59 + ($numeroParcela == null ? 43 : ((Object)$numeroParcela).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $observacaoUsuario = this.getObservacaoUsuario();
        result = result * 59 + ($observacaoUsuario == null ? 43 : $observacaoUsuario.hashCode());
        BigDecimal $valorEntrada = this.getValorEntrada();
        result = result * 59 + ($valorEntrada == null ? 43 : ((Object)$valorEntrada).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        Long $anoProcesso = this.getAnoProcesso();
        result = result * 59 + ($anoProcesso == null ? 43 : ((Object)$anoProcesso).hashCode());
        Long $numeroProcesso = this.getNumeroProcesso();
        result = result * 59 + ($numeroProcesso == null ? 43 : ((Object)$numeroProcesso).hashCode());
        Long $anoProcessoQuitacao = this.getAnoProcessoQuitacao();
        result = result * 59 + ($anoProcessoQuitacao == null ? 43 : ((Object)$anoProcessoQuitacao).hashCode());
        Long $processoQuitacao = this.getProcessoQuitacao();
        result = result * 59 + ($processoQuitacao == null ? 43 : ((Object)$processoQuitacao).hashCode());
        Long $anoProcessoPrazo = this.getAnoProcessoPrazo();
        result = result * 59 + ($anoProcessoPrazo == null ? 43 : ((Object)$anoProcessoPrazo).hashCode());
        Long $numeroProcessoPrazo = this.getNumeroProcessoPrazo();
        result = result * 59 + ($numeroProcessoPrazo == null ? 43 : ((Object)$numeroProcessoPrazo).hashCode());
        Long $idParametroParcelamento = this.getIdParametroParcelamento();
        result = result * 59 + ($idParametroParcelamento == null ? 43 : ((Object)$idParametroParcelamento).hashCode());
        ParamParcelamento $paramParcelamento = this.getParamParcelamento();
        result = result * 59 + ($paramParcelamento == null ? 43 : $paramParcelamento.hashCode());
        Boolean $estornado = this.getEstornado();
        result = result * 59 + ($estornado == null ? 43 : ((Object)$estornado).hashCode());
        Pessoa $requerente = this.getRequerente();
        result = result * 59 + ($requerente == null ? 43 : $requerente.hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        Boolean $conversao = this.getConversao();
        result = result * 59 + ($conversao == null ? 43 : ((Object)$conversao).hashCode());
        SituacaoParcelamento $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        LocalDate $dataQuitacao = this.getDataQuitacao();
        result = result * 59 + ($dataQuitacao == null ? 43 : ((Object)$dataQuitacao).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        String $codigoValidacao = this.getCodigoValidacao();
        result = result * 59 + ($codigoValidacao == null ? 43 : $codigoValidacao.hashCode());
        UUID $idArquivo = this.getIdArquivo();
        result = result * 59 + ($idArquivo == null ? 43 : ((Object)$idArquivo).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Parcelamento(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", tipo=" + this.getTipo() + ", anoContrato=" + this.getAnoContrato() + ", numeroContrato=" + this.getNumeroContrato() + ", dataParcelamento=" + this.getDataParcelamento() + ", dataInclusao=" + this.getDataInclusao() + ", dataEntrada=" + this.getDataEntrada() + ", numeroParcela=" + this.getNumeroParcela() + ", observacao=" + this.getObservacao() + ", observacaoUsuario=" + this.getObservacaoUsuario() + ", valorEntrada=" + this.getValorEntrada() + ", usuario=" + this.getUsuario() + ", anoProcesso=" + this.getAnoProcesso() + ", numeroProcesso=" + this.getNumeroProcesso() + ", anoProcessoQuitacao=" + this.getAnoProcessoQuitacao() + ", processoQuitacao=" + this.getProcessoQuitacao() + ", anoProcessoPrazo=" + this.getAnoProcessoPrazo() + ", numeroProcessoPrazo=" + this.getNumeroProcessoPrazo() + ", idParametroParcelamento=" + this.getIdParametroParcelamento() + ", paramParcelamento=" + this.getParamParcelamento() + ", estornado=" + this.getEstornado() + ", requerente=" + this.getRequerente() + ", cadastroGeral=" + this.getCadastroGeral() + ", conversao=" + this.getConversao() + ", situacao=" + this.getSituacao() + ", dataQuitacao=" + this.getDataQuitacao() + ", debitos=" + this.getDebitos() + ", codigoValidacao=" + this.getCodigoValidacao() + ", idArquivo=" + this.getIdArquivo() + ", tenant=" + this.getTenant() + ")";
    }
}

