/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.enums.Origem;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="TRIBIMOBILIARIOAVALIACAO")
@Audited
public class CadastroImobiliarioAvaliacao
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOAVALIACAO_ID")
    private Long id;
    @Caption(value="Sequ\u00eancia")
    private Long sequencia;
    @Caption(value="Data Avalia\u00e7\u00e3o")
    private LocalDate dataAvaliacao = LocalDate.now();
    @Min(value=0L)
    @Caption(value="Valor Venal Territorial")
    private @Min(value=0L) BigDecimal valorVenalTerritorial = BigDecimal.ZERO;
    @Min(value=0L)
    @Caption(value="Valor Venal Predial")
    private @Min(value=0L) BigDecimal valorVenalPredial = BigDecimal.ZERO;
    @Min(value=0L)
    @Caption(value="Valor Venal Territorial ITBI")
    private @Min(value=0L) BigDecimal valorVenalTerritorialItbi = BigDecimal.ZERO;
    @Min(value=0L)
    @Caption(value="Valor Venal Predial ITBI")
    private @Min(value=0L) BigDecimal valorVenalPredialItbi = BigDecimal.ZERO;
    @Caption(value="Usu\u00e1rio")
    @Column(length=250)
    private String usuario;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Informado Manual")
    private Boolean informadoManual = Boolean.TRUE;
    @Caption(value="Entidade")
    private Long entidade;
    @Caption(value="Exerc\u00edcio")
    private Long exercicio;
    @Caption(value="Tipo de C\u00e1lculo do D\u00e9bito")
    private Long tipoCalculoDebito;
    @Caption(value="C\u00e1lculo")
    private Long calculo;
    @Caption(value="Valor Venal Condominio")
    private BigDecimal valorVenalCondominio = BigDecimal.ZERO;
    @Caption(value="C\u00f3digo C\u00e1lculo")
    private Long idCalculo;
    @Enumerated(value=EnumType.STRING)
    private Origem origem;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", nullable=false)
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="calculooxy")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @MetaModelIgnore
    @JsonIgnore
    private Calculo calculoOxy;

    public boolean isNew() {
        return this.id == null || this.getSequencia() == null;
    }

    public static CadastroImobiliarioAvaliacao fromGeracaoDebito(CalculoCadastro calculoCadastro, BigDecimal valorPredial, BigDecimal valorTerritorial) {
        CadastroImobiliarioAvaliacao avaliacao = new CadastroImobiliarioAvaliacao();
        avaliacao.setUsuario(SecurityUtils.getUserAise());
        avaliacao.setCadastroGeral(calculoCadastro.getCadastro());
        avaliacao.setInformadoManual(Boolean.valueOf(false));
        avaliacao.setValorVenalTerritorial(valorTerritorial);
        avaliacao.setValorVenalPredial(valorPredial);
        avaliacao.setValorVenalPredialItbi(BigDecimal.ZERO);
        avaliacao.setValorVenalTerritorialItbi(BigDecimal.ZERO);
        avaliacao.setCalculoOxy(calculoCadastro.getCalculo());
        avaliacao.setOrigem(Origem.CALCULO);
        return avaliacao;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioAvaliacao(dataAvaliacao=" + this.getDataAvaliacao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioAvaliacao)) {
            return false;
        }
        CadastroImobiliarioAvaliacao other = (CadastroImobiliarioAvaliacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioAvaliacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public CadastroImobiliarioAvaliacao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public LocalDate getDataAvaliacao() {
        return this.dataAvaliacao;
    }

    @Generated
    public BigDecimal getValorVenalTerritorial() {
        return this.valorVenalTerritorial;
    }

    @Generated
    public BigDecimal getValorVenalPredial() {
        return this.valorVenalPredial;
    }

    @Generated
    public BigDecimal getValorVenalTerritorialItbi() {
        return this.valorVenalTerritorialItbi;
    }

    @Generated
    public BigDecimal getValorVenalPredialItbi() {
        return this.valorVenalPredialItbi;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getInformadoManual() {
        return this.informadoManual;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCalculoDebito() {
        return this.tipoCalculoDebito;
    }

    @Generated
    public Long getCalculo() {
        return this.calculo;
    }

    @Generated
    public BigDecimal getValorVenalCondominio() {
        return this.valorVenalCondominio;
    }

    @Generated
    public Long getIdCalculo() {
        return this.idCalculo;
    }

    @Generated
    public Origem getOrigem() {
        return this.origem;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Calculo getCalculoOxy() {
        return this.calculoOxy;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setDataAvaliacao(LocalDate dataAvaliacao) {
        this.dataAvaliacao = dataAvaliacao;
    }

    @Generated
    public void setValorVenalTerritorial(BigDecimal valorVenalTerritorial) {
        this.valorVenalTerritorial = valorVenalTerritorial;
    }

    @Generated
    public void setValorVenalPredial(BigDecimal valorVenalPredial) {
        this.valorVenalPredial = valorVenalPredial;
    }

    @Generated
    public void setValorVenalTerritorialItbi(BigDecimal valorVenalTerritorialItbi) {
        this.valorVenalTerritorialItbi = valorVenalTerritorialItbi;
    }

    @Generated
    public void setValorVenalPredialItbi(BigDecimal valorVenalPredialItbi) {
        this.valorVenalPredialItbi = valorVenalPredialItbi;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setInformadoManual(Boolean informadoManual) {
        this.informadoManual = informadoManual;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCalculoDebito(Long tipoCalculoDebito) {
        this.tipoCalculoDebito = tipoCalculoDebito;
    }

    @Generated
    public void setCalculo(Long calculo) {
        this.calculo = calculo;
    }

    @Generated
    public void setValorVenalCondominio(BigDecimal valorVenalCondominio) {
        this.valorVenalCondominio = valorVenalCondominio;
    }

    @Generated
    public void setIdCalculo(Long idCalculo) {
        this.idCalculo = idCalculo;
    }

    @Generated
    public void setOrigem(Origem origem) {
        this.origem = origem;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCalculoOxy(Calculo calculoOxy) {
        this.calculoOxy = calculoOxy;
    }
}

