/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoIsencaoId;
import br.com.elotech.tributos.domain.Isencao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBDEBITORECEITAISENCAO")
public class DebitoTributoIsencao
implements EloEntity<DebitoTributoIsencaoId>,
Serializable {
    @EmbeddedId
    private DebitoTributoIsencaoId id;
    private BigDecimal valorIsencao;
    @EloSequence(sequenceName="s05iddebitoreceitaisencao", applyOnMerge=true)
    private Long idDebitoReceitaIsencao;
    @JsonIgnore
    @MetaModelIgnore
    @MapsId(value="entidade,exercicio,divida,tipocadastro,cadastrogeral,subdivida,tributo")
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida"), @JoinColumn(name="receita", referencedColumnName="receita")})
    private DebitoTributo tributo;
    @ManyToOne
    @JoinColumn(name="isencao", referencedColumnName="isencao", updatable=false, insertable=false)
    private Isencao isencao;

    public static DebitoTributoIsencao from(DebitoTributo tributo, BigDecimal valorIsencao) {
        DebitoTributoIsencaoId debitoTributoIsencaoId = new DebitoTributoIsencaoId();
        debitoTributoIsencaoId.setTributo(tributo.getId().getTributo());
        debitoTributoIsencaoId.setDivida(tributo.getId().getDivida());
        debitoTributoIsencaoId.setEntidade(tributo.getId().getEntidade());
        debitoTributoIsencaoId.setExercicio(tributo.getId().getExercicio());
        debitoTributoIsencaoId.setSubDivida(tributo.getId().getSubDivida());
        debitoTributoIsencaoId.setCadastroGeral(tributo.getId().getCadastroGeral());
        debitoTributoIsencaoId.setTipoCadastro(tributo.getId().getTipoCadastro());
        debitoTributoIsencaoId.setIsencao(Long.valueOf(5L));
        DebitoTributoIsencao debitoTributoIsencao = new DebitoTributoIsencao();
        debitoTributoIsencao.setId(debitoTributoIsencaoId);
        debitoTributoIsencao.setValorIsencao(valorIsencao);
        debitoTributoIsencao.setTributo(tributo);
        return debitoTributoIsencao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoTributoIsencao)) {
            return false;
        }
        DebitoTributoIsencao other = (DebitoTributoIsencao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DebitoTributoIsencaoId this$id = this.getId();
        DebitoTributoIsencaoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoTributoIsencao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DebitoTributoIsencaoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoTributoIsencao(id=" + this.getId() + ")";
    }

    @Generated
    public DebitoTributoIsencao() {
    }

    @Generated
    public DebitoTributoIsencaoId getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getValorIsencao() {
        return this.valorIsencao;
    }

    @Generated
    public Long getIdDebitoReceitaIsencao() {
        return this.idDebitoReceitaIsencao;
    }

    @Generated
    public DebitoTributo getTributo() {
        return this.tributo;
    }

    @Generated
    public Isencao getIsencao() {
        return this.isencao;
    }

    @Generated
    public void setId(DebitoTributoIsencaoId id) {
        this.id = id;
    }

    @Generated
    public void setValorIsencao(BigDecimal valorIsencao) {
        this.valorIsencao = valorIsencao;
    }

    @Generated
    public void setIdDebitoReceitaIsencao(Long idDebitoReceitaIsencao) {
        this.idDebitoReceitaIsencao = idDebitoReceitaIsencao;
    }

    @Generated
    public void setTributo(DebitoTributo tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setIsencao(Isencao isencao) {
        this.isencao = isencao;
    }
}

