/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoatualizacaocredito;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class EstornoAtualizacaoCreditoJobListener
extends JobExecutionListenerSupport {
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String JOB_TYPE = "jobType";
    private static final String ESTORNO_ATUALIZACAO_CREDITO_TIPO = JobType.SIMAM_ESTORNO_ATUALIZACAO_CREDITO.getTipo();
    private static final String ESTORNO_ATUALIZACAO_CREDITO = "SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - ";
    private final NotificacaoClient notificacaoClient;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao notificacao = Notificacao.builder().text(String.format("Iniciada a gera\u00e7\u00e3o de dados de Estorno Atualiza\u00e7\u00e3o de Cr\u00e9dito para a entidade %s - %s -> %s", entidade, dataInicial.toString(), dataFinal.toString())).title(ESTORNO_ATUALIZACAO_CREDITO).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)ESTORNO_ATUALIZACAO_CREDITO_TIPO).metadata(ENTIDADE, (Object)entidade).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long entidade = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ENTIDADE));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao.text(String.format("Os dados referentes a estorno atualiza\u00e7\u00e3o de cr\u00e9dito da entidade %d foram gerados com sucesso.", entidade)).title("SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - finalizado com sucesso").metadata(JOB_TYPE, (Object)ESTORNO_ATUALIZACAO_CREDITO_TIPO).metadata(ENTIDADE, (Object)entidade).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("N\u00e3o foi poss\u00edvel gerar os dados.").title("Erro na gera\u00e7\u00e3o de dados do SIM-AM - Estorno Atualiza\u00e7\u00e3o Cr\u00e9dito - ").metadata(JOB_TYPE, (Object)ESTORNO_ATUALIZACAO_CREDITO_TIPO).metadata(ENTIDADE, (Object)entidade).metadata(DATA_INICIAL, (Object)dataInicial).metadata(DATA_FINAL, (Object)dataFinal).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    @Generated
    public EstornoAtualizacaoCreditoJobListener(NotificacaoClient notificacaoClient) {
        this.notificacaoClient = notificacaoClient;
    }
}

