/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicadolivroda;

import br.com.elotech.tributos.batch.ComunicadoGeracaoBatchProcessor;
import br.com.elotech.tributos.dto.ComunicadoConsultaReceitas;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.ComunicadoCadastroService;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoLivroDABatchProcessor
extends ComunicadoGeracaoBatchProcessor {
    private final DebitoRepository debitoRepository;

    protected ComunicadoLivroDABatchProcessor(ComunicadoCadastroService comunicadoCadastroService, EntityManager em, DebitoRepository debitoRepository) {
        super(comunicadoCadastroService, em);
        this.debitoRepository = debitoRepository;
    }

    protected List<ComunicadoConsultaReceitas> findReceitas(ComunicadoDebitoConsultaDTO comunicadoDebitoConsultaDTO) {
        Long livro = this.stepExecution.getJobExecution().getJobParameters().getLong("livro");
        Long exericio = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicio");
        return this.debitoRepository.findIdDebitoParcelaAndValoresTributoByIdDebito(comunicadoDebitoConsultaDTO.getIdDebito(), livro, exericio);
    }
}

