/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.protesto;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.GeracaoProtestoErroService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class GeracaoProtestoLoteCdaJobListener
extends JobExecutionListenerSupport {
    private static final String JOB_TYPE = "jobType";
    private final GeracaoProtestoErroService geracaoProtestoErroService;
    private final NotificacaoClient notificacaoClient;
    private final LoteCdaService loteCdaService;
    protected StepExecution stepExecution;

    public GeracaoProtestoLoteCdaJobListener(GeracaoProtestoErroService geracaoProtestoErroService, NotificacaoClient notificacaoClient, LoteCdaService loteCdaService) {
        this.geracaoProtestoErroService = geracaoProtestoErroService;
        this.notificacaoClient = notificacaoClient;
        this.loteCdaService = loteCdaService;
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
            Long idLote = jobParameters.getLong("idLote");
            List erros = this.geracaoProtestoErroService.findByBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
            if (CollectionUtils.isNotEmpty((Collection)erros)) {
                this.loteCdaService.updateSituacaoLoteProtesto(SituacaoLoteCda.ERRO_PROTESTO, idLote);
            } else {
                this.loteCdaService.updateSituacaoLoteProtesto(SituacaoLoteCda.PROTESTO_GERADO, idLote);
            }
            notificacao.text("Gera\u00e7\u00e3o de protesto a partir do lote de d\u00edvida ativa - finalizado com sucesso").title("Os dados referentes ao Protesto de d\u00edvida ativa foram gerados com sucesso.").metadata("idLote", (Object)idLote).metadata(JOB_TYPE, (Object)JobType.GERACAO_PROTESTO_LOTE_CDA);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de Protesto do lote de d\u00edvida ativa").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)JobType.GERACAO_PROTESTO_LOTE_CDA).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Notificacao notificacao = Notificacao.builder().text("Gera\u00e7\u00e3o de protesto a partir do lote de d\u00edvida ativa - iniciado").title("Foi iniciada rotina de Gera\u00e7\u00e3o protesto a partir do lote de d\u00edvida ativa").time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)JobType.GERACAO_PROTESTO_LOTE_CDA).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }
}

