/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.ComunicadoDebitoRepository;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ComunicadoByConsultaDebitoJobListener
extends JobExecutionListenerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComunicadoByConsultaDebitoJobListener.class);
    private static final String JOB_TYPE = "jobType";
    private final NotificacaoClient notificacaoClient;
    private final ComunicadoDebitoRepository comunicadoDebitoRepository;
    private final ComunicadoRepository comunicadoRepository;

    public ComunicadoByConsultaDebitoJobListener(NotificacaoClient notificacaoClient, ComunicadoDebitoRepository comunicadoDebitoRepository, ComunicadoRepository comunicadoRepository) {
        this.notificacaoClient = notificacaoClient;
        this.comunicadoDebitoRepository = comunicadoDebitoRepository;
        this.comunicadoRepository = comunicadoRepository;
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        ComunicadoId comunicadoId = new ComunicadoId();
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        comunicadoId.setEntidade(jobParameters.getLong("entidade"));
        comunicadoId.setExercicio(jobParameters.getLong("exercicioComunicado"));
        comunicadoId.setIdComunicado(jobParameters.getLong("idComunicado"));
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        comunicado.setBatchJobExecutionComunicado(BatchJobExecution.of((JobExecution)jobExecution));
        this.comunicadoRepository.save((Object)comunicado);
        Notificacao notificacao = Notificacao.builder().text("Comunicado Debito - iniciada").title(String.format("Foi iniciado rotina de Comunciado Debito", new Object[0])).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata(JOB_TYPE, (Object)JobType.COMUNICADO_DEBITO).build();
        this.notificacaoClient.send(notificacao, SecurityUtils.getUserId());
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Notificacao.Builder notificacao = Notificacao.builder().time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            ComunicadoId comunicadoId = new ComunicadoId();
            comunicadoId.setIdComunicado(jobExecution.getJobParameters().getLong("idComunicado"));
            comunicadoId.setEntidade(jobExecution.getJobParameters().getLong("entidade"));
            comunicadoId.setExercicio(jobExecution.getJobParameters().getLong("exercicio"));
            notificacao.text("Comunicado Debito - finalizado com sucesso").title(String.format("Os dados referentes ao Comunicado Debito foram gerados com sucesso.", new Object[0])).metadata("idComunicado", (Object)comunicadoId).metadata(JOB_TYPE, (Object)JobType.COMUNICADO_DEBITO);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            notificacao.text("Erro na gera\u00e7\u00e3o de dados do Comunicado Debito").title("N\u00e3o foi poss\u00edvel gerar os dados.").metadata(JOB_TYPE, (Object)JobType.COMUNICADO_DEBITO).metadata("errors", (Object)jobExecution.getAllFailureExceptions());
        }
        this.notificacaoClient.send(notificacao.build(), SecurityUtils.getUserId());
    }
}

