select tlc.nrCredito,
       tlc.nrAnoCredito,
      coalesce(md.idato, cd.idato) as cdControleLeiAto,
       cd.datacancelamento as dtEstorno,
       substr(md.descricao  || ' . ' || cd.motivo, 0, 250) as dsMotivo,
       tdpr.iddebitoparcelareceita as idDebitoParcelaReceita,
       coalesce(tcdi.valorAtualizado, tcdi.valor) as vlEstorno
from tribcancelamentodebito          cd
     join tribcancelamentodebitoitem tcdi on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and tcdi.idcancelamento = cd.idcancelamento
left join tribmotivodesconto         md   on md.motivodesconto  = cd.motivocancelamento
left join tribtipodeducao            td   on td.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)
     join tceDebitoLancCredito       tdlc on tdlc.iddebitoParcelareceita = tcdi.iddebitoparcelareceita
     join tcelanccredito             tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
     join tribdebitoparcelareceita   tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
left join tribreceita                tr   on tr.entidade =  tdpr.entidade
                                         and tr.exercicio = tdpr.exercicio
                                         and tr.receita = tdpr.receita
left join tribreceitatipo            trt  on trt.tiporeceita = tr.tiporeceita
where (cd.datacancelamento between :dataInicial and :dataFinal)
  and cd.entidade = :entidade
  and td.tipotce = 8
  and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
  and not exists (
    select 1
    from tcedebitolanccreditoEst tdlc
    where tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
  )
order by cd.datacancelamento,
         tlc.nrCredito,
         tlc.nrAnoCredito,
         coalesce(md.idato, cd.idato)