select x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       'INSCRICAO' as tipomovimento,
       x.iddebito,
       sum(x.valor) as valor
from (
select
      td.entidade,
      case
         when td.datacontabilizacao >= tdp.datalancamento then td.datacontabilizacao
         when td.datainclusao > tdp.datalancamento then td.datainclusao
         else tdp.datalancamento
       end datamovimentacao,
       td.iddebito,
       tr.id as idtributo,
       tdpr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.classificacao as classificacaotributo,
       0 as situacaolegal,
       cast(null as numeric(10)) as tipooperacaodeducao,
       sum(tdpr.valor - coalesce(tdpr.valoratualizacao,0)) + coalesce(dados.valorisencao, 0) as valor,
       tdp.datadividaativa
from tribdebito td
left outer join tribdebitoparcela tdp
 on td.entidade         = tdp.entidade
and td.exercicio        = tdp.exercicio
and td.tipocadastro     = tdp.tipocadastro
and td.cadastrogeral    = tdp.cadastrogeral
and td.guiarecolhimento = tdp.guiarecolhimento
and td.subdivida        = tdp.subdivida
left outer join tribdebitoparcelareceita tdpr
 on tdp.entidade         = tdpr.entidade
and tdp.exercicio        = tdpr.exercicio
and tdp.tipocadastro     = tdpr.tipocadastro
and tdp.cadastrogeral    = tdpr.cadastrogeral
and tdp.guiarecolhimento = tdpr.guiarecolhimento
and tdp.subdivida        = tdpr.subdivida
and tdp.parcela          = tdpr.parcela
left outer join tribdebitoreceita tdr
 on tdpr.entidade         = tdr.entidade
and tdpr.exercicio        = tdr.exercicio
and tdpr.tipocadastro     = tdr.tipocadastro
and tdpr.cadastrogeral    = tdr.cadastrogeral
and tdpr.guiarecolhimento = tdr.guiarecolhimento
and tdpr.subdivida        = tdr.subdivida
and tdpr.receita          = tdr.receita
left outer join tribreceita tr
 on tdr.entidade  = tr.entidade
and tdr.exercicio = tr.exercicio
and tdr.receita   = tr.receita
left outer join (select isrec.entidade,
                        isrec.exercicio,
                        isrec.tipocadastro,
                        isrec.cadastrogeral,
                        isrec.guiarecolhimento,
                        isrec.subdivida,
                        isrec.receita,
                        sum(isrec.valorisencao) as valorisencao
                  from tribdebitoreceitaisencao isrec
                  where isrec.valorisencao > 0
                  group by isrec.entidade, isrec.exercicio, isrec.tipocadastro, isrec.cadastrogeral, isrec.guiarecolhimento, isrec.subdivida, isrec.receita
) dados
 on dados.entidade         = tdr.entidade
and dados.exercicio        = tdr.exercicio
and dados.tipocadastro     = tdr.tipocadastro
and dados.cadastrogeral    = tdr.cadastrogeral
and dados.guiarecolhimento = tdr.guiarecolhimento
and dados.subdivida        = tdr.subdivida
and dados.receita          = tdr.receita
where td.constituido = 'S'
  and not exists (select 1 from tribparcelamentodebito rdeb
                  where rdeb.iddebito = td.iddebito)
  and not exists (select 1 from tribestornoparcelamentodebito tepd
                    where tepd.iddebitodestino = td.iddebito)
  and not exists(select 1
                 from triblivroparcelareceita tlpr
                          inner join tribdebitoparcelareceita tdpro
                                     on tlpr.iddebitoparcelareceita = tdpro.iddebitoparcelareceita
                          inner join tribdebitoparcelareceita tdprd on tdprd.entidade = tdpro.entidade
                     and tdprd.exercicio = tdpro.exercicio
                     and tdprd.tipocadastro = tdpro.tipocadastro
                     and tdprd.cadastrogeral = tdpro.cadastrogeral
                     and tdprd.guiarecolhimento = tdpro.guiarecolhimento
                     and tdprd.subdivida = tlpr.novasubdivida
                     and tdprd.receita = tdpro.receita
                 where tdprd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                   and tdprd.subdivida != tdpro.subdivida)
  and ((td.datacontabilizacao >= tdp.datalancamento and td.datacontabilizacao in (:datasMovimento)) or
       (((td.datacontabilizacao is null) or (td.datacontabilizacao < tdp.datalancamento)) and
        ((td.datainclusao >= tdp.datalancamento and td.datainclusao in (:datasMovimento))
          or (((td.datainclusao is null) or (td.datainclusao < tdp.datalancamento))  and tdp.datalancamento in (:datasMovimento)))))
group by
      td.entidade,
      case
         when td.datacontabilizacao >= tdp.datalancamento then td.datacontabilizacao
         when td.datainclusao > tdp.datalancamento then td.datainclusao
         else tdp.datalancamento
       end,
       td.iddebito,
       tr.id,
       tdpr.receita,
       tr.descricao,
       tr.classificacao,
       dados.valorisencao,
       tdp.datadividaativa
) x
group by x.entidade,
       x.datamovimentacao,
       x.tributo,
       x.descricaotributo,
       x.classificacaotributo,
       x.situacaolegal,
       x.tipooperacaodeducao,
       x.iddebito