SELECT DEBITOPARCELARECEITA.RECEITA                            AS tributo,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORPRINCIPAL, 0)) AS valorPrincipal,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORJUROS, 0))     AS valorJuros,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORMULTA, 0))     AS valorMulta,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORCORRECAO, 0))  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0)) > 0
               THEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                        COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                        COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                        COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0))
           ELSE SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTO, 0))
           END                                         AS VALORDESCONTO
FROM TRIBDEVOLUCAOCREDITO DEVOLUCAOCREDITO
         LEFT JOIN TRIBDEVOLUCAOCREDITOITEM DEVOLUCAOCREDITOITEM
                   ON DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITO.IDDEVOLUCAOCREDITO AND
                      DEVOLUCAOCREDITOITEM.GERAMOVIMENTACAO = 'S'
         LEFT JOIN TRIBDEVOLUCAOCREDITODEBITO DEVOLUCAOCREDITODEBITO
                   ON DEVOLUCAOCREDITODEBITO.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO AND
                      DEVOLUCAOCREDITODEBITO.SEQUENCIAITEM = DEVOLUCAOCREDITOITEM.SEQUENCIAITEM
		 LEFT JOIN CONTABANCARIA
		 		   ON CONTABANCARIA.ENTIDADE = DEVOLUCAOCREDITO.ENTIDADE AND
					  CONTABANCARIA.CONTABANCARIA = DEVOLUCAOCREDITO.CONTABANCARIA
         LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                   ON DEVOLUCAOCREDITODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT JOIN TRIBRECEITA RECEITA
                   ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                      RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                      RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
         LEFT OUTER JOIN TRIBRECEITATIPO TIPORECEITA
                         ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE DEVOLUCAOCREDITO.DATA = :dataLancamento
AND DEVOLUCAOCREDITO.DATACANCELAMENTO IS NOT NULL
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA