/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.rest.dto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class BloquetoDTO {
    private Long id;
    private Long entidade;
    private Long exercicioBloqueto;
    private Long bloqueto;
    private String codigoBarras;
    private LocalDate dataEmissao;
    private LocalDate dataVencimento;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private String campo1;
    private String campo2;
    private String campo3;
    private String campo4;
    private String campo5;
    private String urlImpressao;
    private String codigoValidacao;
    private BigDecimal valorAPagar = BigDecimal.ZERO;
    private String nossoNumero;
    private String instrucao;
    private String linhaDigitavel;
    private String textoQrCode;
    private CadastroGeralDTO cadastro;

    public static BloquetoDTO of(Bloqueto boleto) {
        BloquetoDTO boletoDTO = new BloquetoDTO();
        boletoDTO.setId(boleto.getId());
        boletoDTO.setEntidade(boleto.getEntidade());
        boletoDTO.setExercicioBloqueto(boleto.getExercicioBloqueto());
        boletoDTO.setBloqueto(boleto.getBloqueto());
        boletoDTO.setCodigoBarras(boleto.getCodigoBarras());
        boletoDTO.setDataEmissao(boleto.getDataEmissao());
        boletoDTO.setDataVencimento(boleto.getDataVencimento());
        boletoDTO.setValorPrincipal(boleto.getValorPrincipal());
        boletoDTO.setValorJuros(boleto.getValorJuros());
        boletoDTO.setValorMulta(boleto.getValorMulta());
        boletoDTO.setValorCorrecao(boleto.getValorCorrecao());
        boletoDTO.setValorDesconto(boleto.getValorDesconto());
        boletoDTO.setCampo1(boleto.getCampo1());
        boletoDTO.setCampo2(boleto.getCampo2());
        boletoDTO.setCampo3(boleto.getCampo3());
        boletoDTO.setCampo4(boleto.getCampo4());
        boletoDTO.setCampo5(boleto.getCampo5());
        boletoDTO.setCodigoValidacao(boleto.getCodigoValidacao());
        boletoDTO.setNossoNumero(boleto.getNossoNumero());
        boletoDTO.setLinhaDigitavel(boleto.getLinhaDigitavel());
        boletoDTO.setValorAPagar(boleto.getValorPrincipal().add(boleto.getValorJuros()).add(boleto.getValorMulta()).add(boleto.getValorCorrecao()).subtract(boleto.getValorDesconto()));
        boletoDTO.setTextoQrCode(boleto.getTextoQrCode());
        return boletoDTO;
    }

    public String getCampo1() {
        return Optional.ofNullable(this.campo1).orElse("");
    }

    public String getCampo2() {
        return Optional.ofNullable(this.campo2).orElse("");
    }

    public String getCampo3() {
        return Optional.ofNullable(this.campo3).orElse("");
    }

    public String getCampo4() {
        return Optional.ofNullable(this.campo4).orElse("");
    }

    public String getCampo5() {
        return Optional.ofNullable(this.campo5).orElse("");
    }

    public String getLinhaDigitavel() {
        this.linhaDigitavel = this.getCampo1().concat(this.getCampo2()).concat(this.getCampo3()).concat(this.getCampo4()).concat(this.getCampo5());
        return this.linhaDigitavel;
    }

    public BloquetoDTO setCadastroPessoaDTO() {
        Optional.ofNullable(this.getCadastro()).ifPresent(CadastroGeralDTO::set);
        return this;
    }

    @Generated
    public BloquetoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicioBloqueto() {
        return this.exercicioBloqueto;
    }

    @Generated
    public Long getBloqueto() {
        return this.bloqueto;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public String getUrlImpressao() {
        return this.urlImpressao;
    }

    @Generated
    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    @Generated
    public BigDecimal getValorAPagar() {
        return this.valorAPagar;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getInstrucao() {
        return this.instrucao;
    }

    @Generated
    public String getTextoQrCode() {
        return this.textoQrCode;
    }

    @Generated
    public CadastroGeralDTO getCadastro() {
        return this.cadastro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicioBloqueto(Long exercicioBloqueto) {
        this.exercicioBloqueto = exercicioBloqueto;
    }

    @Generated
    public void setBloqueto(Long bloqueto) {
        this.bloqueto = bloqueto;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setCampo1(String campo1) {
        this.campo1 = campo1;
    }

    @Generated
    public void setCampo2(String campo2) {
        this.campo2 = campo2;
    }

    @Generated
    public void setCampo3(String campo3) {
        this.campo3 = campo3;
    }

    @Generated
    public void setCampo4(String campo4) {
        this.campo4 = campo4;
    }

    @Generated
    public void setCampo5(String campo5) {
        this.campo5 = campo5;
    }

    @Generated
    public void setUrlImpressao(String urlImpressao) {
        this.urlImpressao = urlImpressao;
    }

    @Generated
    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    @Generated
    public void setValorAPagar(BigDecimal valorAPagar) {
        this.valorAPagar = valorAPagar;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setInstrucao(String instrucao) {
        this.instrucao = instrucao;
    }

    @Generated
    public void setLinhaDigitavel(String linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    @Generated
    public void setTextoQrCode(String textoQrCode) {
        this.textoQrCode = textoQrCode;
    }

    @Generated
    public void setCadastro(CadastroGeralDTO cadastro) {
        this.cadastro = cadastro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BloquetoDTO)) {
            return false;
        }
        BloquetoDTO other = (BloquetoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicioBloqueto = this.getExercicioBloqueto();
        Long other$exercicioBloqueto = other.getExercicioBloqueto();
        if (this$exercicioBloqueto == null ? other$exercicioBloqueto != null : !((Object)this$exercicioBloqueto).equals(other$exercicioBloqueto)) {
            return false;
        }
        Long this$bloqueto = this.getBloqueto();
        Long other$bloqueto = other.getBloqueto();
        if (this$bloqueto == null ? other$bloqueto != null : !((Object)this$bloqueto).equals(other$bloqueto)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        if (this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valorPrincipal = this.getValorPrincipal();
        BigDecimal other$valorPrincipal = other.getValorPrincipal();
        if (this$valorPrincipal == null ? other$valorPrincipal != null : !((Object)this$valorPrincipal).equals(other$valorPrincipal)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorDescontoPrincipal = this.getValorDescontoPrincipal();
        BigDecimal other$valorDescontoPrincipal = other.getValorDescontoPrincipal();
        if (this$valorDescontoPrincipal == null ? other$valorDescontoPrincipal != null : !((Object)this$valorDescontoPrincipal).equals(other$valorDescontoPrincipal)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        String this$campo1 = this.getCampo1();
        String other$campo1 = other.getCampo1();
        if (this$campo1 == null ? other$campo1 != null : !this$campo1.equals(other$campo1)) {
            return false;
        }
        String this$campo2 = this.getCampo2();
        String other$campo2 = other.getCampo2();
        if (this$campo2 == null ? other$campo2 != null : !this$campo2.equals(other$campo2)) {
            return false;
        }
        String this$campo3 = this.getCampo3();
        String other$campo3 = other.getCampo3();
        if (this$campo3 == null ? other$campo3 != null : !this$campo3.equals(other$campo3)) {
            return false;
        }
        String this$campo4 = this.getCampo4();
        String other$campo4 = other.getCampo4();
        if (this$campo4 == null ? other$campo4 != null : !this$campo4.equals(other$campo4)) {
            return false;
        }
        String this$campo5 = this.getCampo5();
        String other$campo5 = other.getCampo5();
        if (this$campo5 == null ? other$campo5 != null : !this$campo5.equals(other$campo5)) {
            return false;
        }
        String this$urlImpressao = this.getUrlImpressao();
        String other$urlImpressao = other.getUrlImpressao();
        if (this$urlImpressao == null ? other$urlImpressao != null : !this$urlImpressao.equals(other$urlImpressao)) {
            return false;
        }
        String this$codigoValidacao = this.getCodigoValidacao();
        String other$codigoValidacao = other.getCodigoValidacao();
        if (this$codigoValidacao == null ? other$codigoValidacao != null : !this$codigoValidacao.equals(other$codigoValidacao)) {
            return false;
        }
        BigDecimal this$valorAPagar = this.getValorAPagar();
        BigDecimal other$valorAPagar = other.getValorAPagar();
        if (this$valorAPagar == null ? other$valorAPagar != null : !((Object)this$valorAPagar).equals(other$valorAPagar)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$instrucao = this.getInstrucao();
        String other$instrucao = other.getInstrucao();
        if (this$instrucao == null ? other$instrucao != null : !this$instrucao.equals(other$instrucao)) {
            return false;
        }
        String this$linhaDigitavel = this.getLinhaDigitavel();
        String other$linhaDigitavel = other.getLinhaDigitavel();
        if (this$linhaDigitavel == null ? other$linhaDigitavel != null : !this$linhaDigitavel.equals(other$linhaDigitavel)) {
            return false;
        }
        String this$textoQrCode = this.getTextoQrCode();
        String other$textoQrCode = other.getTextoQrCode();
        if (this$textoQrCode == null ? other$textoQrCode != null : !this$textoQrCode.equals(other$textoQrCode)) {
            return false;
        }
        CadastroGeralDTO this$cadastro = this.getCadastro();
        CadastroGeralDTO other$cadastro = other.getCadastro();
        return !(this$cadastro == null ? other$cadastro != null : !this$cadastro.equals(other$cadastro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BloquetoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicioBloqueto = this.getExercicioBloqueto();
        result = result * 59 + ($exercicioBloqueto == null ? 43 : ((Object)$exercicioBloqueto).hashCode());
        Long $bloqueto = this.getBloqueto();
        result = result * 59 + ($bloqueto == null ? 43 : ((Object)$bloqueto).hashCode());
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valorPrincipal = this.getValorPrincipal();
        result = result * 59 + ($valorPrincipal == null ? 43 : ((Object)$valorPrincipal).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorDescontoPrincipal = this.getValorDescontoPrincipal();
        result = result * 59 + ($valorDescontoPrincipal == null ? 43 : ((Object)$valorDescontoPrincipal).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        String $campo1 = this.getCampo1();
        result = result * 59 + ($campo1 == null ? 43 : $campo1.hashCode());
        String $campo2 = this.getCampo2();
        result = result * 59 + ($campo2 == null ? 43 : $campo2.hashCode());
        String $campo3 = this.getCampo3();
        result = result * 59 + ($campo3 == null ? 43 : $campo3.hashCode());
        String $campo4 = this.getCampo4();
        result = result * 59 + ($campo4 == null ? 43 : $campo4.hashCode());
        String $campo5 = this.getCampo5();
        result = result * 59 + ($campo5 == null ? 43 : $campo5.hashCode());
        String $urlImpressao = this.getUrlImpressao();
        result = result * 59 + ($urlImpressao == null ? 43 : $urlImpressao.hashCode());
        String $codigoValidacao = this.getCodigoValidacao();
        result = result * 59 + ($codigoValidacao == null ? 43 : $codigoValidacao.hashCode());
        BigDecimal $valorAPagar = this.getValorAPagar();
        result = result * 59 + ($valorAPagar == null ? 43 : ((Object)$valorAPagar).hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $instrucao = this.getInstrucao();
        result = result * 59 + ($instrucao == null ? 43 : $instrucao.hashCode());
        String $linhaDigitavel = this.getLinhaDigitavel();
        result = result * 59 + ($linhaDigitavel == null ? 43 : $linhaDigitavel.hashCode());
        String $textoQrCode = this.getTextoQrCode();
        result = result * 59 + ($textoQrCode == null ? 43 : $textoQrCode.hashCode());
        CadastroGeralDTO $cadastro = this.getCadastro();
        result = result * 59 + ($cadastro == null ? 43 : $cadastro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BloquetoDTO(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicioBloqueto=" + this.getExercicioBloqueto() + ", bloqueto=" + this.getBloqueto() + ", codigoBarras=" + this.getCodigoBarras() + ", dataEmissao=" + this.getDataEmissao() + ", dataVencimento=" + this.getDataVencimento() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorDesconto=" + this.getValorDesconto() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", campo1=" + this.getCampo1() + ", campo2=" + this.getCampo2() + ", campo3=" + this.getCampo3() + ", campo4=" + this.getCampo4() + ", campo5=" + this.getCampo5() + ", urlImpressao=" + this.getUrlImpressao() + ", codigoValidacao=" + this.getCodigoValidacao() + ", valorAPagar=" + this.getValorAPagar() + ", nossoNumero=" + this.getNossoNumero() + ", instrucao=" + this.getInstrucao() + ", linhaDigitavel=" + this.getLinhaDigitavel() + ", textoQrCode=" + this.getTextoQrCode() + ", cadastro=" + this.getCadastro() + ")";
    }
}

