/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.LancamentoCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LancamentoCreditoMaService
implements ManutencaoArquivoSimAmService<LancamentoCreditoMaDTO> {
    @Autowired
    private LancamentoCreditoRepository lancamentoCreditoRepository;
    @Autowired
    private AtoRepository atoRepository;
    @Autowired
    private ContextService contextService;
    @Autowired
    private EntityManager entityManager;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.LANCAMENTO_CREDITO;
    }

    public Page<LancamentoCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dataLancamento"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.lancamentoCreditoRepository.findAll(specification, pageable).map(LancamentoCreditoMaDTO::from);
    }

    public List<LancamentoCreditoMaDTO> updateAll(List<LancamentoCreditoMaDTO> arquivos) {
        if (!this.areArquivosValidos(arquivos)) {
            return arquivos.stream().filter(LancamentoCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.lancamentoCreditoRepository.saveAll((Iterable)arquivos.stream().map(LancamentoCreditoMaDTO::toLancamentoCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areArquivosValidos(List<LancamentoCreditoMaDTO> arquivos) {
        Long entidade = this.contextService.getEntidadePrincipal();
        AtomicBoolean valido = new AtomicBoolean(true);
        arquivos.forEach(arquivo -> {
            Ato ato = this.atoRepository.findByIdTce(entidade, arquivo.getCdControleLeiAto()).orElse(null);
            Long idTce = Optional.ofNullable(ato).map(Ato::getIdTce).orElse(null);
            Long idTipoEscopoLei = Optional.ofNullable(ato).map(Ato::getIdTipoEscopoLei).orElse(null);
            try {
                this.validateIdTceNotFound(idTce, arquivo.getIdTceLancCredito(), arquivo.getCdControleLeiAto());
                this.validateEscopoTributoMunicipal(idTipoEscopoLei, arquivo.getIdTceLancCredito(), arquivo.getCdControleLeiAto());
            }
            catch (Exception e) {
                arquivo.setErrorMessage(e.getMessage());
                valido.set(false);
            }
        });
        return valido.get();
    }

    private void validateIdTceNotFound(Long idTce, Long idTceLancCredito, Long cdControleLeiAto) {
        if (Objects.isNull(idTce)) {
            throw new EloValidationException(String.format("Regra 1784 - O controle de Lei/Ato %d com c\u00f3digo %d da tabela TceLancCredito n\u00e3o est\u00e1 presente na tabela CgAto.", cdControleLeiAto, idTceLancCredito));
        }
    }

    private void validateEscopoTributoMunicipal(Long idTipoEscopoLei, Long idTceLancCredito, Long cdControleLeiAto) {
        if (Objects.isNull(idTipoEscopoLei) || !idTipoEscopoLei.equals(22L)) {
            throw new EloValidationException(String.format("Regra 1313 - O controle de Lei/Ato %d com c\u00f3digo %d da tabela TceLancCredito n\u00e3o existe na tabela CgAto com idTipoEscopoLei = 22 - Tributos Municipais.", cdControleLeiAto, idTceLancCredito));
        }
    }
}

