/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.procuradoria.client.feign.EnviaPeticaoProcuradoriaFeignClient;
import br.com.elotech.procuradoria.dto.ArquivoPeticaoAgrupadoRequestDTO;
import br.com.elotech.procuradoria.dto.ArquivoPeticaoAgrupadoResponseDTO;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoService;
import br.com.elotech.tributos.service.exception.EnvioArquivoProcuradoriaException;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnviarPeticaoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnviarPeticaoService.class);
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final LotePeticaoService lotePeticaoService;
    private final DocumentoService documentoService;
    private final ArquivoClient arquivoClient;
    private final ArquivoClient arquivoClientNovo;
    private final EnviaPeticaoProcuradoriaFeignClient enviaPeticaoProcuradoriaFeignClient;

    @Transactional(noRollbackFor={EnvioArquivoProcuradoriaException.class})
    public Documento agruparArquivoPeticaoLoteCda(Long idPeticao) throws IOException {
        PDDocument document = new PDDocument();
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idPeticao);
        if (documento.getEnviadoProcuradoria().booleanValue()) {
            throw new EnvioArquivoProcuradoriaException(String.format("A Peti\u00e7\u00e3o %d j\u00e1 foi enviado para Procuradoria!", idPeticao));
        }
        LOGGER.info("Iniciando impress\u00e3o do documento da Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        byte[] peticaoInfo = this.lotePeticaoService.printPeticao(idPeticao);
        this.mergeInfoToDocument(document, peticaoInfo);
        LOGGER.info("Iniciando impress\u00e3o do documento das CDA da Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        for (Documento documentoCda : documento.getCertidoesDividaAtivaPeticao()) {
            byte[] certidaoDividaAtivaInfo = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(documentoCda.getId());
            this.mergeInfoToDocument(document, certidaoDividaAtivaInfo);
        }
        InputStream fileStream = this.saveDocument(document);
        ArquivoNovoRequest arquivoNovoRequest = this.createNewFileRequest(idPeticao, fileStream);
        LOGGER.info("Salvando arquivo agrupado no S3");
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        ArquivoPeticaoAgrupadoRequestDTO arquivoPeticaoAgrupadoRequestDTO = this.createBodyRequestArquivoAgrupado(documento, arquivo);
        LOGGER.debug("Abrindo o contexto do Hystrix!");
        LOGGER.info("Enviando arquivo para o sistema de Procuradoria S3");
        ArquivoPeticaoAgrupadoResponseDTO arquivoPeticaoAgrupadoResponseDTO = this.enviaPeticaoProcuradoriaFeignClient.saveArquivoPeticaoCdaAgrupado(arquivoPeticaoAgrupadoRequestDTO);
        if (Objects.nonNull(arquivoPeticaoAgrupadoResponseDTO) && Objects.nonNull(arquivoPeticaoAgrupadoResponseDTO.getIdArquivoPeticaoAgrupado())) {
            documento.setEnviadoProcuradoria(Boolean.TRUE);
            this.documentoService.save((EloEntity)documento, null);
        }
        return documento;
    }

    private ArquivoPeticaoAgrupadoRequestDTO createBodyRequestArquivoAgrupado(Documento documento, Arquivo arquivo) {
        ArquivoPeticaoAgrupadoRequestDTO arquivoPeticaoAgrupadoRequestDTO = new ArquivoPeticaoAgrupadoRequestDTO();
        arquivoPeticaoAgrupadoRequestDTO.setDocumento(documento.getDocumento());
        arquivoPeticaoAgrupadoRequestDTO.setExercicio(documento.getExercicio());
        arquivoPeticaoAgrupadoRequestDTO.setIdArquivoS3(arquivo.getId().toString());
        return arquivoPeticaoAgrupadoRequestDTO;
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        PDFMergerUtility pdfMerge = new PDFMergerUtility();
        this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        document.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private ArquivoNovoRequest createNewFileRequest(Long idPeticao, InputStream inputStream) {
        String nomeArquivo = String.format("Peticao_CDA_Procuradoria_%d_%s", idPeticao, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
        return arquivoNovoRequest;
    }

    private ArquivoClient resolveArquivoClient() {
        return TenantUtils.usesNovoS3() != false ? this.arquivoClientNovo : this.arquivoClient;
    }

    @Generated
    public EnviarPeticaoService(CertidaoDividaAtivaService certidaoDividaAtivaService, LotePeticaoService lotePeticaoService, DocumentoService documentoService, ArquivoClient arquivoClient, ArquivoClient arquivoClientNovo, EnviaPeticaoProcuradoriaFeignClient enviaPeticaoProcuradoriaFeignClient) {
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.lotePeticaoService = lotePeticaoService;
        this.documentoService = documentoService;
        this.arquivoClient = arquivoClient;
        this.arquivoClientNovo = arquivoClientNovo;
        this.enviaPeticaoProcuradoriaFeignClient = enviaPeticaoProcuradoriaFeignClient;
    }
}

