/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributoId;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.PagNegDebOrigemId;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.domain.SituacaoPagNegociadoNovo;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.CertidaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.DadosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoComTotalizadorDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoPagamentoNegociado;
import br.com.elotech.tributos.dto.FiltroPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.FiltroSimulacaoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.enums.OperacoesPagamentoNegociado;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.repository.DebitoEmAbertoRepository;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.LivroParcelaTributoService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PagamentoNegociadoService
extends CrudService<PagamentoNegociado, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagamentoNegociadoService.class);
    private final CadastroGeralService cadastroGeralService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final CertidaoDividaAtivaService cdaService;
    private final ContextService contextService;
    private final ConvenioService convenioService;
    private final DebitoEmAbertoRepository debitoEmAbertoRepository;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoService debitoService;
    private final DividaService dividaService;
    private final DocumentoItemDividaAtivaService documentoIDAService;
    private final DocumentoService documentoService;
    private final EntityManager em;
    private final FormaPagamentoService formaPagamentoService;
    private final GeraBoletoService geraBoletoService;
    private final GeraDebitoService geraDebitoService;
    private final GeraLivroRepository geraLivroRepository;
    private final LivroParcelaTributoService livroParcelaTributoService;
    private final PagamentoLoteManualService pagamentoLoteManualService;
    private final PagamentoService pagamentoService;
    private final SituacaoParcelaService situacaoParcelaService;

    public DebitoPagamentoNegociadoComTotalizadorDTO findDebitosPagamentoNegociado(FiltroConsultaDebitoPagamentoNegociado filtro) {
        Long entidade = this.contextService.getEntidadePrincipal();
        List debitos = this.debitoEmAbertoRepository.loadDebitosPagamentoNegociado(filtro, entidade);
        if (!debitos.isEmpty()) {
            FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.ofNullable(filtro.getExercicioFormaPagamento()));
            debitos = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento.getId(), filtro.getDataReferencia());
            debitos = CalculaAcrescimoBaseDTO.agruparPorParcela((List)debitos);
        }
        return new DebitoPagamentoNegociadoComTotalizadorDTO(debitos);
    }

    public DebitoPagamentoNegociadoComTotalizadorDTO generateSimulacaoPagamentoNegociado(FiltroSimulacaoPagamentoNegociadoDTO filtro) {
        filtro.gerarRateioNegociacao();
        return new DebitoPagamentoNegociadoComTotalizadorDTO(filtro.getDebitos());
    }

    public PagamentoNegociado finalizarGeracaoPagamentoNegociado(ParametrosPagamentoNegociadoDTO parametrosPagamentoNegociadoDTO) {
        log.debug("Foi inicializado a gera\u00e7\u00e3o do pagamento negociado. ");
        DadosPagamentoNegociadoDTO dadosPagamento = parametrosPagamentoNegociadoDTO.getDadosPagamento();
        FiltroPagamentoNegociadoDTO filtro = parametrosPagamentoNegociadoDTO.getFiltroPagamentoNegociada();
        List debitosTotalmenteBaixados = this.agruparDebitosPorStatus(parametrosPagamentoNegociadoDTO.getDebitos(), StatusPagamentoNegociado.TOTAL);
        List debitoParcialBaixados = this.agruparDebitosPorStatus(parametrosPagamentoNegociadoDTO.getDebitos(), StatusPagamentoNegociado.PARCIAL);
        PagamentoNegociado pagamentoNegociado = this.montarNovoPagamentoNegociado(dadosPagamento, filtro);
        List debOrigem = this.gerarListaDePagamentosDebOrigem(parametrosPagamentoNegociadoDTO.getDebitos(), pagamentoNegociado);
        pagamentoNegociado.setDebitosOrigem(debOrigem);
        if (debitoParcialBaixados.size() > 0) {
            DebitoIdDTO debitoId = this.tratarDebitosParcialmenteBaixados(dadosPagamento, filtro, (DebitoPagamentoNegociadoDTO)debitoParcialBaixados.get(0), pagamentoNegociado);
            Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoId.getIdDebito());
            debitosTotalmenteBaixados.add(DebitoPagamentoNegociadoDTO.fromDebito((Debito)debito));
        }
        List pagamentosGeradosPelosDebitosTotais = this.gerarPagamentoDosDebitosAbatido(debitosTotalmenteBaixados, dadosPagamento, filtro);
        pagamentoNegociado.setPagamentoGerado((Pagamento)pagamentosGeradosPelosDebitosTotais.get(0));
        log.debug("Pagamento negociado gerado com sucesso");
        return (PagamentoNegociado)this.save((EloEntity)pagamentoNegociado, null);
    }

    private List<Pagamento> gerarPagamentoDosDebitosAbatido(List<DebitoPagamentoNegociadoDTO> debitosAbatidos, DadosPagamentoNegociadoDTO dadosPagamento, FiltroPagamentoNegociadoDTO filtro) {
        CadastroGeral cadastroGeral = this.getCadastroGeral(filtro.getTipoCadastro(), filtro.getCadastroGeral());
        MotivoDeducao motivoDeducao = dadosPagamento.getMotivo();
        Convenio convenio = (Convenio)this.convenioService.findOne((Serializable)dadosPagamento.getConvenio().getId());
        Bloqueto boleto = this.geraBoletoService.createBoletoForPagamentoNegociado(debitosAbatidos, motivoDeducao, cadastroGeral);
        this.em.detach((Object)boleto);
        PagamentoLoteManualDTO pagamentoLoteManualDTO = PagamentoLoteManualDTO.from((Bloqueto)boleto, (Long)convenio.getId(), (LocalDate)dadosPagamento.getDataCredito(), (Long)this.contextService.getExercicioAtual(), (LocalDate)this.contextService.getDataAtual());
        PagamentoLoteDTO pagamentoLoteDTO = this.pagamentoLoteManualService.salvarPagamentoLote(pagamentoLoteManualDTO);
        PagamentoLoteId pagamentoLoteID = new PagamentoLoteId();
        pagamentoLoteID.setLote(pagamentoLoteDTO.getLote());
        pagamentoLoteID.setExercicio(pagamentoLoteDTO.getExercicio());
        pagamentoLoteID.setEntidade(pagamentoLoteDTO.getEntidade());
        List pagamentos = this.pagamentoService.buscarPagamentosPorPagamentoLoteId(pagamentoLoteID);
        return pagamentos;
    }

    public PagamentoNegociado montarNovoPagamentoNegociado(DadosPagamentoNegociadoDTO dadosPagamento, FiltroPagamentoNegociadoDTO filtro) {
        Convenio convenio = (Convenio)this.convenioService.findOne((Serializable)dadosPagamento.getConvenio().getId());
        PagamentoNegociado pagamentoNegociado = new PagamentoNegociado();
        pagamentoNegociado.setCadastroGeralfiltro(filtro.getCadastroGeral().toString());
        pagamentoNegociado.setTipoCadastrofiltro(filtro.getTipoCadastro().toString());
        pagamentoNegociado.setCancelado(PagamentoNegociadoSituacaoEnum.EFETIVADO);
        Optional.ofNullable(filtro.getNumeroCDA()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setCda(arg_0));
        pagamentoNegociado.setContaBancaria(convenio.getContaBancaria());
        pagamentoNegociado.setConvenio(convenio);
        pagamentoNegociado.setDataCredito(dadosPagamento.getDataCredito());
        pagamentoNegociado.setDataNegociacao(dadosPagamento.getDtNegociacao());
        pagamentoNegociado.setDataReferencia(filtro.getDataReferencia());
        Optional.ofNullable(filtro.getAnoCDA()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setExercicioCDA(arg_0));
        Optional.ofNullable(filtro.getExercicio()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setExercicioFiltro(arg_0));
        Optional.ofNullable(filtro.getDivida()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setGuiaRecolhimentoFiltro(arg_0));
        pagamentoNegociado.setMotivoDesconto(dadosPagamento.getMotivo().getId());
        Optional.ofNullable(filtro.getParcela()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setParcelaFiltro(arg_0));
        Optional.ofNullable(filtro.getSituacaoLegal()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setSituacaoLegal(arg_0));
        Optional.ofNullable(filtro.getSubDivida()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setSubDividaFiltro(arg_0));
        Optional.ofNullable(filtro.getParcela()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setParcelaFiltro(arg_0));
        pagamentoNegociado.setUsuario(dadosPagamento.getUsuario());
        pagamentoNegociado.setValorNegociado(dadosPagamento.getValorNegociado());
        Optional.ofNullable(filtro.getDataVencimentoFinal()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setVenctoFinal(arg_0));
        Optional.ofNullable(filtro.getDataVencimentoInicial()).ifPresent(arg_0 -> ((PagamentoNegociado)pagamentoNegociado).setVenctoInicial(arg_0));
        return pagamentoNegociado;
    }

    private DebitoIdDTO tratarDebitosParcialmenteBaixados(DadosPagamentoNegociadoDTO dadosPagamento, FiltroPagamentoNegociadoDTO filtro, DebitoPagamentoNegociadoDTO debitoParcialBaixados, PagamentoNegociado pagamentoNegociado) {
        List debitosParciaisTratados = this.recalcularDebitoParcial(debitoParcialBaixados);
        DebitoPagamentoNegociadoDTO debitoPNDTOAbatido = (DebitoPagamentoNegociadoDTO)debitosParciaisTratados.get(0);
        DebitoPagamentoNegociadoDTO debitoPNDTONovo = (DebitoPagamentoNegociadoDTO)debitosParciaisTratados.get(1);
        DebitoIdDTO debitoIdDTOAbatido = this.gerarNovoDebito(debitoPNDTOAbatido);
        DebitoIdDTO DebitoIdDTONovo = this.gerarNovoDebito(debitoPNDTONovo);
        ArrayList<PagamentoNegociadoDebNovo> debNovos = new ArrayList<PagamentoNegociadoDebNovo>();
        debNovos.add(this.adicionarPagamentoNegociadoDebNovo(debitoIdDTOAbatido, debitoPNDTOAbatido, pagamentoNegociado, SituacaoPagNegociadoNovo.ABATIDO));
        debNovos.add(this.adicionarPagamentoNegociadoDebNovo(DebitoIdDTONovo, debitoPNDTONovo, pagamentoNegociado, SituacaoPagNegociadoNovo.ABERTO));
        pagamentoNegociado.setDebitosNovos(debNovos);
        pagamentoNegociado.setValorDebitoBaixado(debitoPNDTOAbatido.getValorNovoDebito());
        pagamentoNegociado.setValorDebitoNovo(debitoPNDTONovo.getValorNovoDebito());
        if (this.debitoPossuiDividaAtiva(debitoParcialBaixados.getSituacaoLegal())) {
            FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.ofNullable(this.contextService.getExercicioAtual()));
            ArrayList todosAcrescimos = new ArrayList();
            Debito novoDebitoQueSeraAbatido = (Debito)this.debitoService.findOne((Serializable)debitoIdDTOAbatido.getIdDebito());
            novoDebitoQueSeraAbatido.setDivida((Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(debitoIdDTOAbatido.getEntidade(), debitoIdDTOAbatido.getExercicio(), debitoIdDTOAbatido.getDivida()).get());
            todosAcrescimos.addAll(DebitoPagamentoNegociadoDTO.fromDebitoForCalculaAcrescimo((Debito)novoDebitoQueSeraAbatido));
            Debito novoDebitoQueVaiFicarAberto = (Debito)this.debitoService.findOne((Serializable)DebitoIdDTONovo.getIdDebito());
            novoDebitoQueVaiFicarAberto.setDivida((Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(DebitoIdDTONovo.getEntidade(), DebitoIdDTONovo.getExercicio(), DebitoIdDTONovo.getDivida()).get());
            todosAcrescimos.addAll(DebitoPagamentoNegociadoDTO.fromDebitoForCalculaAcrescimo((Debito)novoDebitoQueVaiFicarAberto));
            List acrescimos = this.calculoAcrescimoService.calculaAcrescimos(todosAcrescimos, formaPagamento.getId(), filtro.getDataReferencia());
            Map<Long, List<DebitoPagamentoNegociadoDTO>> acrescimosAgrupados = acrescimos.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getSubDivida));
            List<DebitoPagamentoNegociadoDTO> acrescimosASeremAbatidos = acrescimosAgrupados.get(novoDebitoQueSeraAbatido.getSubDivida());
            List<DebitoPagamentoNegociadoDTO> acrescimosNovo = acrescimosAgrupados.get(novoDebitoQueVaiFicarAberto.getSubDivida());
            this.alterarDividaAtivaDosTributos(novoDebitoQueSeraAbatido, debitoPNDTOAbatido, acrescimosASeremAbatidos);
            this.alterarDividaAtivaDosTributos(novoDebitoQueVaiFicarAberto, debitoPNDTONovo, acrescimosNovo);
            this.cancelarDebitoParcial(dadosPagamento, debitoParcialBaixados);
        }
        return debitoIdDTOAbatido;
    }

    private PagamentoNegociadoDebNovo adicionarPagamentoNegociadoDebNovo(DebitoIdDTO debitoNovo, DebitoPagamentoNegociadoDTO debitoAntigo, PagamentoNegociado pagamentoNegociado, SituacaoPagNegociadoNovo situacao) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoNovo.getIdDebito());
        DebitoParcela debitoParcelaOrigem = (DebitoParcela)this.debitoParcelaService.findOne((Serializable)DebitoParcelaId.fromPagamentoNegociado((DebitoPagamentoNegociadoDTO)debitoAntigo));
        PagamentoNegociadoDebNovo debNovo = new PagamentoNegociadoDebNovo();
        debNovo.setPgtonegociado(pagamentoNegociado.getId());
        debNovo.setObservacao("Pagamento negociado novo gerado atrav\u00e9s do Oxy");
        debNovo.setSituacao(situacao);
        debNovo.setDebitoNovo((DebitoParcela)debito.getParcelas().get(0));
        debNovo.setDebitoOrigem(debitoParcelaOrigem);
        return debNovo;
    }

    private void alterarDividaAtivaDosTributos(Debito debito, DebitoPagamentoNegociadoDTO dadosParcelaOrigem, List<DebitoPagamentoNegociadoDTO> acrescimosCalculados) {
        DebitoParcela parcelaNova = (DebitoParcela)debito.getParcelas().get(0);
        DebitoParcelaId idParcelaAntiga = DebitoParcelaId.fromPagamentoNegociado((DebitoPagamentoNegociadoDTO)dadosParcelaOrigem);
        List livroTributosAntigos = this.livroParcelaTributoService.findByParcela(idParcelaAntiga);
        Map<String, List<LivroParcelaTributo>> livroTributoAgrupado = livroTributosAntigos.stream().collect(Collectors.groupingBy(tributoAntigo -> tributoAntigo.getId().getDebitoParcelaTributo().getTributo()));
        parcelaNova.getTributos().forEach(parcelaTributo -> {
            DebitoPagamentoNegociadoDTO acrescimo = acrescimosCalculados.stream().filter(element -> element.getTributo().equals(parcelaTributo.getTributo())).findFirst().get();
            this.geraNovoLivroParcelaTributo(dadosParcelaOrigem, livroTributoAgrupado, parcelaTributo, acrescimo);
        });
        LivroRegistro livroRegistro = ((LivroParcelaTributo)livroTributosAntigos.get(0)).getId().getLivroRegistro();
        Boolean englobaParcela = livroRegistro.getId().getLivro().getEnglobaParcelas();
        Long novaSituacao = this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.BAIXA_INSCRICAO_DIVIDA_ATIVA, this.situacaoParcelaService.findSituacaoParcelaById(parcelaNova.getSituacaoDebito().getId())).getId();
        this.geraLivroRepository.updateDebitoParcela(parcelaNova.getId(), livroRegistro, SituacaoLegal.DIVIDA_ATIVA.getCodigo(), novaSituacao, englobaParcela);
        List listaDeIdDasCertidoes = this.cdaService.findByDebitoParcela(idParcelaAntiga);
        listaDeIdDasCertidoes.forEach(idCertidao -> {
            Documento documento = (Documento)this.documentoService.findOne((Serializable)idCertidao.getIdDocumento());
            AtomicLong ultimaSequencia = new AtomicLong(documento.getDocumentoItemDividaAtivas().stream().map(DocumentoItemDividaAtiva::getId).max(Comparator.comparing(DocumentoItemDividaAtivaId::getSequenciaItem)).get().getSequenciaItem());
            List documentoDividaAtivaNovos = parcelaNova.getTributos().stream().map(tributoDaParcela -> {
                if (!livroTributoAgrupado.containsKey(tributoDaParcela.getTributo())) {
                    return null;
                }
                DebitoPagamentoNegociadoDTO acrescimo = acrescimosCalculados.stream().filter(element -> element.getTributo().equals(tributoDaParcela.getTributo())).findFirst().get();
                return this.novoDocumentoDividaAtiva(livroRegistro, idCertidao, documento, Long.valueOf(ultimaSequencia.incrementAndGet()), tributoDaParcela, acrescimo);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            documento.getDocumentoItemDividaAtivas().addAll(documentoDividaAtivaNovos);
            this.documentoService.save((EloEntity)documento, null);
        });
    }

    private void geraNovoLivroParcelaTributo(DebitoPagamentoNegociadoDTO dadosParcelaOrigem, Map<String, List<LivroParcelaTributo>> livroTributoAgrupado, DebitoParcelaTributo debitoParcelaTributo, DebitoPagamentoNegociadoDTO calculoAcrescimosDTO) {
        Optional livroTributoAntigo = livroTributoAgrupado.getOrDefault(debitoParcelaTributo.getTributo(), Collections.emptyList()).stream().findFirst();
        if (livroTributoAntigo.isEmpty()) {
            log.info("Ignorando gera\u00e7\u00e3o do livro tributo pois n\u00e3o foi encontrado o tributo {}, do debito {}, parecela {}", new Object[]{debitoParcelaTributo.getTributo(), dadosParcelaOrigem.getIdDebito(), dadosParcelaOrigem.getParcela()});
            return;
        }
        LivroParcelaTributo livroParcelaTributo = new LivroParcelaTributo();
        LivroParcelaTributoId id = new LivroParcelaTributoId();
        id.setLivroRegistro(((LivroParcelaTributo)livroTributoAntigo.get()).getId().getLivroRegistro());
        id.setDebitoParcelaTributo(debitoParcelaTributo);
        livroParcelaTributo.setId(id);
        BigDecimal valorNovoDebito = BigDecimal.ZERO;
        valorNovoDebito = dadosParcelaOrigem.getTributosAgrupados().isEmpty() ? dadosParcelaOrigem.getValorNovoDebito() : dadosParcelaOrigem.getTributosAgrupados().stream().filter(ta -> ta.getTributo().equals(debitoParcelaTributo.getTributo())).findFirst().get().getValorNovoDebito();
        livroParcelaTributo.setNovaSubDivida(((LivroParcelaTributo)livroTributoAntigo.get()).getNovaSubDivida());
        livroParcelaTributo.setValor(calculoAcrescimosDTO.getValorPrincipal());
        livroParcelaTributo.setValorJuros(calculoAcrescimosDTO.getValorJuros());
        livroParcelaTributo.setValorMulta(calculoAcrescimosDTO.getValorMulta());
        livroParcelaTributo.setValorCorrecao(calculoAcrescimosDTO.getValorCorrecao());
        livroParcelaTributo.setValorOriginal(valorNovoDebito);
        livroParcelaTributo.setEstornado(Boolean.FALSE);
        livroParcelaTributo.setSituacaoLegal(((LivroParcelaTributo)livroTributoAntigo.get()).getSituacaoLegal());
        livroParcelaTributo.setObservacao(((LivroParcelaTributo)livroTributoAntigo.get()).getObservacao());
        this.livroParcelaTributoService.save((EloEntity)livroParcelaTributo, null);
    }

    private DocumentoItemDividaAtiva novoDocumentoDividaAtiva(LivroRegistro livroRegistro, CertidaoDividaAtivaDTO idCertidao, Documento documento, Long ultimaSequencia, DebitoParcelaTributo debitoParcelaTributo, DebitoPagamentoNegociadoDTO acrescimoDTO) {
        DocumentoItemDividaAtiva documentoItemDividaAtiva = new DocumentoItemDividaAtiva();
        DocumentoItemDividaAtivaId id = new DocumentoItemDividaAtivaId();
        id.setDocumento(idCertidao.getDocumento());
        id.setSequenciaItem(ultimaSequencia);
        id.setTipoDocumento(idCertidao.getTipoDocumento());
        id.setEntidade(idCertidao.getEntidade());
        id.setExercicio(idCertidao.getExercicio());
        documentoItemDividaAtiva.setId(id);
        documentoItemDividaAtiva.setDocumento(documento);
        documentoItemDividaAtiva.setTipoCadastro(debitoParcelaTributo.getDebitoParcela().getId().getTipoCadastro());
        documentoItemDividaAtiva.setCadastroGeral(debitoParcelaTributo.getDebitoParcela().getId().getCadastroGeral());
        documentoItemDividaAtiva.setLivro(livroRegistro.getId().getLivro());
        documentoItemDividaAtiva.setExercicioDebito(debitoParcelaTributo.getDebitoParcela().getId().getExercicio());
        documentoItemDividaAtiva.setCodigoDivida(debitoParcelaTributo.getDebitoParcela().getId().getDivida());
        documentoItemDividaAtiva.setSubDivida(debitoParcelaTributo.getDebitoParcela().getId().getSubDivida());
        documentoItemDividaAtiva.setTributo(debitoParcelaTributo.getTributo());
        documentoItemDividaAtiva.setParcela(debitoParcelaTributo.getDebitoParcela().getId().getParcela());
        documentoItemDividaAtiva.setValor(acrescimoDTO.getValorTotal());
        documentoItemDividaAtiva.setValorJuros(acrescimoDTO.getValorJuros());
        documentoItemDividaAtiva.setValorMulta(acrescimoDTO.getValorMulta());
        documentoItemDividaAtiva.setValorCorrecao(acrescimoDTO.getValorCorrecao());
        documentoItemDividaAtiva.setNumeroFolha(livroRegistro.getNumeroFolha());
        documentoItemDividaAtiva.setNumeroInscricao(livroRegistro.getNumeroInscricao());
        return documentoItemDividaAtiva;
    }

    private CancelamentoDebito cancelarDebitoParcial(DadosPagamentoNegociadoDTO dadosPagamento, DebitoPagamentoNegociadoDTO debitoParcial) {
        CancelamentoParcelasFormDTO cancelamentoParcelasFormDTO = CancelamentoParcelasFormDTO.fromPagamentoNegociado((DadosPagamentoNegociadoDTO)dadosPagamento, (DebitoPagamentoNegociadoDTO)debitoParcial);
        return this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(cancelamentoParcelasFormDTO);
    }

    private DebitoIdDTO gerarNovoDebito(DebitoPagamentoNegociadoDTO debitoPagamentoNegociadoDTO) {
        Debito debito = (Debito)this.debitoService.findById((Serializable)debitoPagamentoNegociadoDTO.getIdDebito()).get();
        NextSubdividaValueParams params = new NextSubdividaValueParams();
        params.setDivida(debito.getDivida().getDivida());
        params.setExercicio(debito.getExercicio());
        params.setCadastroGeral(debito.getCadastroGeral().getCadastroGeral());
        params.setTipoCadastro(debito.getTipoCadastro());
        Long novaSequencia = this.debitoService.getNextValueSubdivida(params);
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(debitoPagamentoNegociadoDTO.getExercicio());
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)debitoPagamentoNegociadoDTO.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(debitoPagamentoNegociadoDTO.getCadastroGeral());
        debitoManualDTO.setDivida(debitoPagamentoNegociadoDTO.getDivida());
        debitoManualDTO.setSubDivida(novaSequencia);
        debitoManualDTO.setDataLancamento(LocalDate.now());
        debitoManualDTO.setFormaCorrecao(debito.getFormaCorrecao().getId());
        if (debitoPagamentoNegociadoDTO.getTributosAgrupados().isEmpty()) {
            DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
            debitoManualTributoDTO.setTributo(debitoPagamentoNegociadoDTO.getTributo());
            debitoManualTributoDTO.setValorTributo(debitoPagamentoNegociadoDTO.getValorNovoDebito());
            debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
            debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
            debitoManualDTO.getTributos().add(debitoManualTributoDTO);
        } else {
            debitoPagamentoNegociadoDTO.getTributosAgrupados().forEach(tributos -> {
                DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
                debitoManualTributoDTO.setTributo(tributos.getTributo());
                debitoManualTributoDTO.setValorTributo(tributos.getValorNovoDebito());
                debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
                debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
                debitoManualDTO.getTributos().add(debitoManualTributoDTO);
            });
        }
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setParcela(debitoPagamentoNegociadoDTO.getParcela());
        debitoManualParcelaDTO.setSituacao(Long.valueOf(SituacaoLegal.DIVIDA_ATIVA.getCodigo().longValue()));
        debitoManualParcelaDTO.setSituacaoLegal(Long.valueOf(debitoPagamentoNegociadoDTO.getSituacaoLegal().longValue()));
        debitoManualParcelaDTO.setDataVencimento(debitoPagamentoNegociadoDTO.getDataVencimento());
        debitoManualParcelaDTO.setValor(debitoPagamentoNegociadoDTO.getValorPrincipal());
        debitoManualParcelaDTO.setValorBaseCalculo(BigDecimal.ZERO);
        debitoManualDTO.setParcelas(List.of(debitoManualParcelaDTO));
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    private List<PagamentoNegociadoDebOrigem> gerarListaDePagamentosDebOrigem(List<DebitoPagamentoNegociadoDTO> debitosBaixados, PagamentoNegociado pagamentoNegociado) {
        ArrayList<PagamentoNegociadoDebOrigem> pagamentoNegociadoDebOrigems = new ArrayList<PagamentoNegociadoDebOrigem>();
        debitosBaixados.forEach(element -> {
            DebitoParcelaId debitoParcelaId = new DebitoParcelaId();
            debitoParcelaId.setCadastroGeral(element.getCadastroGeral());
            debitoParcelaId.setDivida(element.getDivida());
            debitoParcelaId.setEntidade(element.getEntidade());
            debitoParcelaId.setExercicio(element.getExercicio());
            debitoParcelaId.setParcela(element.getParcela());
            debitoParcelaId.setSubDivida(element.getSubDivida());
            debitoParcelaId.setTipoCadastro(element.getTipoCadastro());
            DebitoParcela debitoParcela = new DebitoParcela();
            debitoParcela.setId(debitoParcelaId);
            PagNegDebOrigemId pagNegDebOrigemId = new PagNegDebOrigemId();
            pagNegDebOrigemId.setDebitoParcela(debitoParcela);
            PagamentoNegociadoDebOrigem debOrigem = new PagamentoNegociadoDebOrigem();
            debOrigem.setPagamentoNegociado(pagamentoNegociado);
            debOrigem.setId(pagNegDebOrigemId);
            debOrigem.setCorrecao(element.getValorCorrecao());
            debOrigem.setDataVencimento(element.getDataVencimento());
            debOrigem.setJuros(element.getValorJuros());
            debOrigem.setMulta(element.getValorMulta());
            debOrigem.setOperacao(OperacoesPagamentoNegociado.BAIXAR_DEBITO.getTipo());
            if (Objects.nonNull(element.getIdParcelamento())) {
                Parcelamento parcelamento = new Parcelamento();
                parcelamento.setId(element.getIdParcelamento());
                debOrigem.setParcelamento(parcelamento);
            }
            debOrigem.setReparcelado(element.getReparcelado());
            if (StatusPagamentoNegociado.PARCIAL.equals((Object)element.getStatus())) {
                debOrigem.setTotalDebito(element.getValorAbatido());
            } else {
                debOrigem.setTotalDebito(BigDecimal.ZERO);
            }
            debOrigem.setValor(element.getValorPrincipal());
            debOrigem.setValorTotal(element.getValorPrincipal().add(element.getValorAcrescimos()));
            pagamentoNegociadoDebOrigems.add(debOrigem);
        });
        return pagamentoNegociadoDebOrigems;
    }

    public List<DebitoPagamentoNegociadoDTO> recalcularDebitoParcial(DebitoPagamentoNegociadoDTO debito) {
        BigDecimal valorTotal = debito.getValorTotal();
        BigDecimal valorDivisorioAbatido = debito.getValorAbatido().divide(valorTotal, 10, RoundingMode.FLOOR);
        BigDecimal valorDivisorioRestante = debito.getValorRestante().divide(valorTotal, 10, RoundingMode.CEILING);
        BigDecimal valorDivisorioTotal = valorDivisorioRestante.add(valorDivisorioAbatido);
        if (BigDecimal.ONE.equals(valorDivisorioTotal.stripTrailingZeros())) {
            DebitoPagamentoNegociadoDTO debitoAbatido = this.recalcularTributosAgrupados(debito, valorDivisorioAbatido, debito.getValorAbatido());
            DebitoPagamentoNegociadoDTO debitoNovo = this.recalcularTributosAgrupados(debito, valorDivisorioRestante, debito.getValorRestante());
            return List.of(debitoAbatido, debitoNovo);
        }
        throw new EloValidationException("A soma dos valores percentuais n\u00e3o \u00e9 completa, percentual abatido: " + valorDivisorioAbatido.toString() + ", percentual restante: " + valorDivisorioRestante.toString());
    }

    public DebitoPagamentoNegociadoDTO recalcularTributosAgrupados(DebitoPagamentoNegociadoDTO debitoATratar, BigDecimal divisor, BigDecimal valorParaRatear) {
        DebitoPagamentoNegociadoDTO tributoAgrupadoRecalculado = debitoATratar.clone();
        AtomicReference<BigDecimal> valorRateado = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (tributoAgrupadoRecalculado.getTributosAgrupados().isEmpty()) {
            BigDecimal valorNovoDebito = tributoAgrupadoRecalculado.getValorTotal().multiply(divisor).setScale(2, RoundingMode.HALF_EVEN);
            valorRateado.set(valorNovoDebito);
            tributoAgrupadoRecalculado.setValorNovoDebito(valorNovoDebito);
        } else {
            tributoAgrupadoRecalculado.getTributosAgrupados().forEach(tributo -> {
                BigDecimal valorNovoDebito = tributo.getValorTotal().multiply(divisor).setScale(2, RoundingMode.HALF_EVEN);
                valorRateado.set(((BigDecimal)valorRateado.get()).add(valorNovoDebito));
                tributo.setValorNovoDebito(valorNovoDebito);
            });
        }
        if (BigDecimal.valueOf(valorRateado.get().doubleValue()).setScale(2).compareTo(valorParaRatear) != 0) {
            throw new EloValidationException("Erro no rateio. Esperava " + valorParaRatear.toString() + " , dividiu " + valorRateado.get());
        }
        return tributoAgrupadoRecalculado;
    }

    public boolean debitoPossuiDividaAtiva(Integer situacaoLegal) {
        return BigDecimal.ONE.equals(BigDecimal.valueOf(situacaoLegal.intValue())) || BigDecimal.valueOf(2L).equals(BigDecimal.valueOf(situacaoLegal.intValue()));
    }

    private List<DebitoPagamentoNegociadoDTO> agruparDebitosPorStatus(List<DebitoPagamentoNegociadoDTO> debitos, StatusPagamentoNegociado status) {
        return debitos.stream().filter(element -> status.equals((Object)element.getStatus())).collect(Collectors.toList());
    }

    private CadastroGeral getCadastroGeral(Long tipoCadastro, Long cadastroGeral) {
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral));
    }

    @Generated
    public PagamentoNegociadoService(CadastroGeralService cadastroGeralService, CalculoAcrescimoService calculoAcrescimoService, CancelamentoDebitoService cancelamentoDebitoService, CertidaoDividaAtivaService cdaService, ContextService contextService, ConvenioService convenioService, DebitoEmAbertoRepository debitoEmAbertoRepository, DebitoParcelaService debitoParcelaService, DebitoService debitoService, DividaService dividaService, DocumentoItemDividaAtivaService documentoIDAService, DocumentoService documentoService, EntityManager em, FormaPagamentoService formaPagamentoService, GeraBoletoService geraBoletoService, GeraDebitoService geraDebitoService, GeraLivroRepository geraLivroRepository, LivroParcelaTributoService livroParcelaTributoService, PagamentoLoteManualService pagamentoLoteManualService, PagamentoService pagamentoService, SituacaoParcelaService situacaoParcelaService) {
        this.cadastroGeralService = cadastroGeralService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.cdaService = cdaService;
        this.contextService = contextService;
        this.convenioService = convenioService;
        this.debitoEmAbertoRepository = debitoEmAbertoRepository;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.dividaService = dividaService;
        this.documentoIDAService = documentoIDAService;
        this.documentoService = documentoService;
        this.em = em;
        this.formaPagamentoService = formaPagamentoService;
        this.geraBoletoService = geraBoletoService;
        this.geraDebitoService = geraDebitoService;
        this.geraLivroRepository = geraLivroRepository;
        this.livroParcelaTributoService = livroParcelaTributoService;
        this.pagamentoLoteManualService = pagamentoLoteManualService;
        this.pagamentoService = pagamentoService;
        this.situacaoParcelaService = situacaoParcelaService;
    }
}

