/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.DocumentoTipoUsuario;
import br.com.elotech.tributos.domain.DocumentoTipoUsuarioId;
import br.com.elotech.tributos.domain.Usuario;
import br.com.elotech.tributos.dto.DocumentoTipoUsuarioDTO;
import br.com.elotech.tributos.repository.DocumentoTipoRepository;
import br.com.elotech.tributos.repository.DocumentoTipoUsuarioRepository;
import br.com.elotech.tributos.repository.UsuarioRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DocumentoTipoUsuarioService {
    private final DocumentoTipoUsuarioRepository documentoTipoUsuarioRepository;
    private final DocumentoTipoRepository documentoTipoRepository;
    private final UsuarioRepository usuarioRepository;
    private final ContextService contextService;

    public DocumentoTipoUsuarioService(DocumentoTipoUsuarioRepository documentoTipoUsuarioRepository, DocumentoTipoRepository documentoTipoRepository, UsuarioRepository usuarioRepository, ContextService contextService) {
        this.documentoTipoUsuarioRepository = documentoTipoUsuarioRepository;
        this.documentoTipoRepository = documentoTipoRepository;
        this.usuarioRepository = usuarioRepository;
        this.contextService = contextService;
    }

    public void delete(Long entidade, Long tipoDocumento, String usuario) {
        this.documentoTipoUsuarioRepository.deleteById((Object)DocumentoTipoUsuarioId.of((Long)entidade, (Long)tipoDocumento, (String)usuario));
    }

    public DocumentoTipoUsuario create(Long tipoDocumento, String usuario) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return this.documentoTipoUsuarioRepository.findByIdEntidadeAndIdTipoDocumentoAndIdUsuario(entidade, tipoDocumento, usuario).orElseGet(() -> {
            DocumentoTipoUsuario documentoTipoUsuario = new DocumentoTipoUsuario();
            documentoTipoUsuario.setId(DocumentoTipoUsuarioId.of((Long)entidade, (Long)tipoDocumento, (String)usuario));
            documentoTipoUsuario.setDocumentoTipo(this.findDocumentoTipo(tipoDocumento));
            documentoTipoUsuario.setUsuario(this.findUsuario(usuario));
            return (DocumentoTipoUsuario)this.documentoTipoUsuarioRepository.save((Object)documentoTipoUsuario);
        });
    }

    private List<DocumentoTipoUsuario> findByUsuarioId(String usuario) {
        return this.documentoTipoUsuarioRepository.findByIdUsuario(usuario);
    }

    private Usuario findUsuario(String usuario) {
        return (Usuario)this.usuarioRepository.findById((Object)usuario).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o usu\u00e1rio %s", usuario)));
    }

    private DocumentoTipo findDocumentoTipo(Long tipoDocumento) {
        return (DocumentoTipo)this.documentoTipoRepository.findById((Object)tipoDocumento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Tipo Documento com id %d", tipoDocumento)));
    }

    public List<DocumentoTipoUsuarioDTO> getAllByUsuario(String usuario) {
        return this.documentoTipoUsuarioRepository.getAllByEntidadeAndUsuario(this.contextService.getEntidadePrincipal(), usuario);
    }

    public List<DocumentoTipoUsuario> copy(String usuarioASerCopiado, String usuarioAReceber) {
        Usuario usuarioOrigem = this.findUsuario(usuarioASerCopiado);
        Usuario usuario = this.findUsuario(usuarioAReceber);
        this.deleteAllByUsuario(usuarioAReceber);
        List permissoesCopiadas = this.findByUsuarioId(usuarioOrigem.getId());
        List novasPermissoesUsuarioAReceber = permissoesCopiadas.stream().map(permissao -> {
            DocumentoTipoUsuario documentoTipoUsuario = new DocumentoTipoUsuario();
            documentoTipoUsuario.setId(DocumentoTipoUsuarioId.of((Long)permissao.getId().getEntidade(), (Long)permissao.getId().getTipoDocumento(), (String)usuario.getId()));
            documentoTipoUsuario.setDocumentoTipo(permissao.getDocumentoTipo());
            documentoTipoUsuario.setUsuario(usuario);
            documentoTipoUsuario.setAlterar(permissao.getAlterar());
            documentoTipoUsuario.setInserir(permissao.getInserir());
            documentoTipoUsuario.setCancelar(permissao.getCancelar());
            documentoTipoUsuario.setImprimir(permissao.getImprimir());
            return documentoTipoUsuario;
        }).collect(Collectors.toList());
        return this.documentoTipoUsuarioRepository.saveAll(novasPermissoesUsuarioAReceber);
    }

    protected void deleteAllByUsuario(String usuario) {
        Usuario user = this.findUsuario(usuario);
        List permissoes = this.findByUsuarioId(user.getId());
        this.documentoTipoUsuarioRepository.deleteAll((Iterable)permissoes);
    }

    public void toggleAlterar(String usuario, Long tipoDocumento) {
        DocumentoTipoUsuario documentoTipoUsuario;
        documentoTipoUsuario.setAlterar(Boolean.valueOf((documentoTipoUsuario = this.create(tipoDocumento, usuario)).getAlterar() == false));
        this.documentoTipoUsuarioRepository.save((Object)documentoTipoUsuario);
    }

    public void toggleInserir(String usuario, Long tipoDocumento) {
        DocumentoTipoUsuario documentoTipoUsuario;
        documentoTipoUsuario.setInserir(Boolean.valueOf((documentoTipoUsuario = this.create(tipoDocumento, usuario)).getInserir() == false));
        this.documentoTipoUsuarioRepository.save((Object)documentoTipoUsuario);
    }

    public void toggleCancelar(String usuario, Long tipoDocumento) {
        DocumentoTipoUsuario documentoTipoUsuario;
        documentoTipoUsuario.setCancelar(Boolean.valueOf((documentoTipoUsuario = this.create(tipoDocumento, usuario)).getCancelar() == false));
        this.documentoTipoUsuarioRepository.save((Object)documentoTipoUsuario);
    }

    public void toggleImprimir(String usuario, Long tipoDocumento) {
        DocumentoTipoUsuario documentoTipoUsuario;
        documentoTipoUsuario.setImprimir(Boolean.valueOf((documentoTipoUsuario = this.create(tipoDocumento, usuario)).getImprimir() == false));
        this.documentoTipoUsuarioRepository.save((Object)documentoTipoUsuario);
    }
}

