/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoCdaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.AtualizaItensParcelasDTO;
import br.com.elotech.tributos.dto.documento.cda.DeleteCDAItemDTO;
import br.com.elotech.tributos.repository.DocumentoItemDividaAtivaRepository;
import br.com.elotech.tributos.service.CertidaoDividaAtivaHistoricoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.exception.DocumentoNotFoundException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class DocumentoItemDividaAtivaService
extends CrudService<DocumentoItemDividaAtiva, DocumentoItemDividaAtivaId> {
    private final DocumentoItemDividaAtivaRepository documentoItemDividaAtivaRepository;
    private final DocumentoService documentoService;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService;

    public DocumentoItemDividaAtivaService(DocumentoItemDividaAtivaRepository documentoItemDividaAtivaRepository, DocumentoService documentoService, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService) {
        this.documentoItemDividaAtivaRepository = documentoItemDividaAtivaRepository;
        this.documentoService = documentoService;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.certidaoDividaAtivaHistoricoService = certidaoDividaAtivaHistoricoService;
    }

    public Documento removerVinculo(DeleteCDAItemDTO deleteCDAItemDTO) {
        Documento documento = Optional.ofNullable((Documento)this.documentoService.findOne((Serializable)deleteCDAItemDTO.getIdDocumento())).orElseThrow(() -> new DocumentoNotFoundException(deleteCDAItemDTO.getIdDocumento()));
        if (documento.getCadastroGeral().getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro %d-%d est\u00e1 em exclus\u00e3o l\u00f3gica.", documento.getCadastroGeral().getTipoCadastro().getValue(), documento.getCadastroGeral().getCadastroGeral()));
        }
        DocumentoDTO documentoDTO = DocumentoDTO.from((Documento)documento);
        List documentosItemDividaAtivaParaRemover = this.documentoItemDividaAtivaRepository.findByDebitoParcela(deleteCDAItemDTO.getEntidade(), deleteCDAItemDTO.getExercicio(), deleteCDAItemDTO.getTipoCadastro(), deleteCDAItemDTO.getCadastroGeral(), deleteCDAItemDTO.getDivida(), deleteCDAItemDTO.getSubDivida(), deleteCDAItemDTO.getParcela());
        List documentoDividaAtivaAgrupados = documentoDTO.agruparDocumentosDividaAtivaPorParcela(deleteCDAItemDTO.getEntidade());
        if (documentoDividaAtivaAgrupados.size() <= 1) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel remover o v\u00ednculo se houver apenas uma parcela");
        }
        documentosItemDividaAtivaParaRemover.forEach(itemDividaAtiva -> {
            this.documentoItemDividaAtivaRepository.deleteDocumentoItemPeticaoByDocumentoItemDividaAtivaId(itemDividaAtiva.getId().getEntidade(), itemDividaAtiva.getId().getExercicio(), itemDividaAtiva.getId().getTipoDocumento(), itemDividaAtiva.getId().getDocumento(), itemDividaAtiva.getId().getSequenciaItem());
            this.certidaoDividaAtivaHistoricoService.salvaHistoricoOperacaoRemocaoDebito(documento, itemDividaAtiva);
        });
        documento.getDocumentoItemDividaAtivas().removeAll(documentosItemDividaAtivaParaRemover);
        return (Documento)this.documentoService.save((EloEntity)documento, null);
    }

    public Documento atualizaItensParcelas(Long idDocumento, AtualizaItensParcelasDTO dto) {
        Documento documento = Optional.ofNullable((Documento)this.documentoService.findOne((Serializable)idDocumento)).orElseThrow(() -> new DocumentoNotFoundException(idDocumento));
        List idItensDiferentesDeAberto = this.documentoItemDividaAtivaRepository.findIdsDiferentesDeAberto(dto.getEntidade(), dto.getExercicio(), dto.getDocumento());
        documento.getDocumentoItemDividaAtivas().removeIf(item -> idItensDiferentesDeAberto.contains(item.getId()));
        if (documento.getDocumentoItemDividaAtivas().isEmpty()) {
            documento.setCancelado(Boolean.TRUE);
            documento.setSituacao(SituacaoDocumento.cancelado());
        } else {
            documento.getDocumentoItemDividaAtivas().forEach(documentoItemDividaAtiva -> {
                Long sequenciaItem = documentoItemDividaAtiva.getId().getSequenciaItem();
                AcrescimoDTO acrescimoDTO = this.calculoAcrescimoService.calculaAcrescimos(this.getAcrescimoDaParcela(dto.getEntidade(), dto.getExercicio(), dto.getDocumento(), sequenciaItem, dto.getDataReferencia()), Optional.empty());
                this.certidaoDividaAtivaHistoricoService.salvaHistoricoOperacaoAtualizacaoValor(documento, documentoItemDividaAtiva, acrescimoDTO);
                documentoItemDividaAtiva.setValorMulta(acrescimoDTO.getValorMulta());
                documentoItemDividaAtiva.setValorCorrecao(acrescimoDTO.getValorCorrecao());
                documentoItemDividaAtiva.setValorJuros(acrescimoDTO.getValorJuros());
            });
        }
        return (Documento)this.documentoService.save((EloEntity)documento, null);
    }

    private AcrescimoDTO getAcrescimoDaParcela(Long entidade, Long exercicio, Long idDocumento, Long sequenciaItem, LocalDate dataReferencia) {
        AcrescimoCdaDTO acrescimoCdaDTO = this.documentoItemDividaAtivaRepository.findAcrescimosCdaItem(entidade, exercicio, idDocumento, sequenciaItem);
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        return AcrescimoDTO.of((AcrescimoCdaDTO)acrescimoCdaDTO, (Long)formaPagamento.getId(), (LocalDate)dataReferencia);
    }
}

