/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.simam;

import br.com.elotech.tributos.dto.simam.ConferenciaArquivoComTotalizadorDTO;
import br.com.elotech.tributos.repository.simam.ConferenciaRepository;
import br.com.elotech.tributos.service.ContextService;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/conferencia-sim-am"})
public class ConferenciaSimAmResource {
    private final ConferenciaRepository repository;
    private final ContextService contextService;

    @GetMapping(params={"dataInicial", "dataFinal"})
    public ResponseEntity<ConferenciaArquivoComTotalizadorDTO> getConferenciaPorData(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        Long entidade = this.contextService.getEntidadePrincipal();
        List result = this.repository.getConferenciaByData(entidade, dataInicial, dataFinal);
        return ResponseEntity.ok((Object)ConferenciaArquivoComTotalizadorDTO.from((List)result));
    }

    @Generated
    public ConferenciaSimAmResource(ConferenciaRepository repository, ContextService contextService) {
        this.repository = repository;
        this.contextService = contextService;
    }
}

