/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoComTotalizadorDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoPagamentoNegociado;
import br.com.elotech.tributos.dto.FiltroSimulacaoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.service.PagamentoNegociadoService;
import java.io.Serializable;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pagamento-negociado"})
public class PagamentoNegociadoResource {
    private final PagamentoNegociadoService pagamentoNegociadoService;

    @GetMapping
    public ResponseEntity<Page<PagamentoNegociadoDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page pagamentos = this.pagamentoNegociadoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)pagamentos.map(PagamentoNegociadoDTO::from));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<PagamentoNegociadoDTO> findResumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.findById((Serializable)id).map(PagamentoNegociado::to).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o pagamento negociado de id %d.", id))));
    }

    @GetMapping(value={"/filtrar-debitos-negociados"}, params={"tipoCadastro", "cadastroGeral", "dataReferencia"})
    public ResponseEntity<DebitoPagamentoNegociadoComTotalizadorDTO> filterDebitosNegociados(@Valid FiltroConsultaDebitoPagamentoNegociado filtro) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.findDebitosPagamentoNegociado(filtro));
    }

    @PostMapping(value={"/simular-debitos-negociados"})
    public ResponseEntity<DebitoPagamentoNegociadoComTotalizadorDTO> simularDebitosNegociados(@RequestBody @Valid FiltroSimulacaoPagamentoNegociadoDTO filtro) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.generateSimulacaoPagamentoNegociado(filtro));
    }

    @Transactional
    @PostMapping(value={"/finalizar-simulacao"})
    public ResponseEntity<PagamentoNegociado> finishSimulacaoPagamentoNegociado(@RequestBody @Valid ParametrosPagamentoNegociadoDTO parametrosPagamentoNegociadoDTO) {
        return ResponseEntity.ok((Object)this.pagamentoNegociadoService.finalizarGeracaoPagamentoNegociado(parametrosPagamentoNegociadoDTO));
    }

    @Generated
    public PagamentoNegociadoResource(PagamentoNegociadoService pagamentoNegociadoService) {
        this.pagamentoNegociadoService = pagamentoNegociadoService;
    }
}

