/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoDACargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.AtualizacaoMonetariaCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoMonetariaCreditoDACustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoMonetariaCreditoDACustomRepositoryImpl
implements AtualizacaoMonetariaCreditoDACustomRepository {
    private final String sqlCargaExistente = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoMonetariaDACargaExistente.sql");
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String PESSOA = "idPessoa";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoDividaAtivaDTO> findLancamentos(@Param(value="idPessoa") Long idPessoa, @Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoMonetariaDALancamentos.sql");
        sqlLancamentos = sqlLancamentos.replace(":idPessoa", idPessoa.toString());
        sqlLancamentos = sqlLancamentos.replace(":dataInicial", String.format("'%s'", dataInicial));
        sqlLancamentos = sqlLancamentos.replace(":dataFinal", String.format("'%s'", dataFinal));
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoDividaAtivaDTO.class));
    }

    public List<AtualizacaoCreditoDACargaExistenteDTO> getCargaExistente(LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = "select t.idTceAtualizaMoneCredDA,         t.nrDivida,         t.nrAnoDivida,         t.cdControleLeiAto,         t.idTipoAtualizacaoCredito,         t.dtAtualizacao  from tceAtualizaMoneCredDA t  where t.dtAtualizacao between :dataInicial and :dataFinal  order by t.nrAtualizacao, t.nrAnoAtualizacao";
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoDACargaExistenteDTO.class));
    }

    private String getSqlUpdateValorFinal() {
        return String.format("update tceatualizamonecredda up set vlatualizacao = (select w.valor from (%s) w where w.idtceatualizamonecredda = up.idtceatualizamonecredda) where up.dtatualizacao between :dataInicial and :dataFinal ", this.sqlCargaExistente);
    }

    public void atualizaValorFinal(@Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        this.namedParameterJdbcTemplate.update(this.getSqlUpdateValorFinal(), (SqlParameterSource)parameters);
    }

    public void verificarErrors(@Param(value="dataInicial") LocalDate dataInicial, @Param(value="dataFinal") LocalDate dataFinal) {
        String nrDividaNaoLocalizada;
        List lista = this.getCargaExistente(dataInicial, dataFinal);
        StringBuilder erros = new StringBuilder();
        String leiAtoNaoCadastrado = lista.stream().filter(item -> Objects.isNull(item.getCdControleLeiAto())).map(AtualizacaoCreditoDACargaExistenteDTO::getIdTceAtualizamoneCredDA).map(Object::toString).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)leiAtoNaoCadastrado)) {
            erros.append("\n").append("Lei/Ato n\u00e3o localizado para os Ids: ").append(leiAtoNaoCadastrado);
        }
        if (StringUtils.isNotBlank((CharSequence)(nrDividaNaoLocalizada = lista.stream().filter(item -> Objects.isNull(item.getNrDivida())).map(AtualizacaoCreditoDACargaExistenteDTO::getIdTceAtualizamoneCredDA).map(Object::toString).collect(Collectors.joining(", "))))) {
            erros.append("\n").append("NrDivida n\u00e3o localizada para os Ids: ").append(nrDividaNaoLocalizada);
        }
        if (StringUtils.isNotBlank((CharSequence)erros.toString())) {
            throw new EloValidationException(erros.toString());
        }
    }

    public List<AtualizacaoMonetariaCreditoDividaAtivaMaDTO> findLancamentosMa(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/manutencaoarquivo/atualizacaoMonetariaCreditoDividaAtivaMa.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoMonetariaCreditoDividaAtivaMaDTO.class));
    }

    @Generated
    public AtualizacaoMonetariaCreditoDACustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

